package build;

import java.nio.file.*;
import org.denom.build.*;
import org.denom.log.*;

/**
 * Build JAR-files with Denom libs for Java desktop and Android platforms.
 */
class BuildLibs
{
	static String BUILD_DATE = "2026.01.26";

	static String ROOT = "../..";

	static LogConsole log = new LogConsole();

	static String[] excludeAndroid = {
			"/build",
			"/ecj",
			"/swing",
			"/testrunner",
			"LICENSE.txt",
			"LogColoredConsoleWindow.java", "LogColoredConsoleWindow.class",
			"LogColoredTextPane.java",      "LogColoredTextPane.class",

			"CardReaderPCSC.java",          "CardReaderPCSC.class",
			"CardReaderPCSCNative.java",    "CardReaderPCSCNative.class",
			"ReaderFactory.java",           "ReaderFactory.class",
			"CardScript.java",              "CardScript.class",
			"PanelSelectReader.java",       "PanelSelectReader.class",
			"SecurityModuleSAM.java",       "SecurityModuleSAM.class"
	};

	// -----------------------------------------------------------------------------------------------------------------
	public static void main( String[] args ) throws Exception
	{
		try
		{
			buildLib( "org.denom.common",         "libDenomCommon" );
			buildLib( "org.denom.crypt",          "libDenomCrypt" );
			buildLib( "org.denom.smartcard-full", "libDenomSmartcard", "libDenomCrypt", "libDenomCommon" );

			buildLibAndroid( "org.denom.common", excludeAndroid, "libDenomCommon" );
			buildLibAndroid( "org.denom.crypt", excludeAndroid, "libDenomCommon", "libDenomCrypt" );
			buildLibAndroid( "org.denom.smartcard-full", excludeAndroid, "libDenomSmartcard", "libDenomCrypt", "libDenomCommon" );
		}
		catch( Throwable ex )
		{
			log.writeln( Colors.ERROR, "Ошибка: " + ex.getMessage() );
		}
	}

	// -----------------------------------------------------------------------------------------------------------------
	private static void buildLib( String jarPrefix, String... projectNames ) throws Exception
	{
		Path buildDir = Paths.get( ROOT, "~build" );
		Files.createDirectories( buildDir );
		
		String jarName = Paths.get( buildDir.toString(), jarPrefix + "-" + BUILD_DATE + ".jar" ).toString();

		// Jar
		JarBuilder jb = new JarBuilder( log, jarName );
		jb.exclude( "LICENSE.txt" );
		for( String projectName : projectNames )
			jb.addDirectory( ROOT + "/libs/" + projectName + "/.bin" );
		jb.close();

		// Sources
		jb = new JarBuilder( log, jarName.replace( ".jar", "-sources.jar" ) );
		jb.exclude( "LICENSE.txt" );
		for( String projectName : projectNames )
			jb.addDirectory( ROOT + "/libs/" + projectName + "/src" );
		jb.close();

		log.writeln("");
	}

	// -----------------------------------------------------------------------------------------------------------------
	private static void buildLibAndroid( String jarPrefix, String[] excludeAndroid, String... projectNames ) throws Exception
	{
		Path buildDir = Paths.get( ROOT, "~buildAndroid" );
		Files.createDirectories( buildDir );
		
		String jarName = Paths.get( buildDir.toString(), jarPrefix + "-android-" + BUILD_DATE + ".jar" ).toString();

		// Jar
		JarBuilder jb = new JarBuilder( log, jarName );
		jb.exclude( excludeAndroid );
		for( String projectName : projectNames )
			jb.addDirectory( ROOT + "/libs/" + projectName + "/.bin" );
		jb.close();

		// Sources
		jb = new JarBuilder( log, jarName.replace( ".jar", "-sources.jar" ) );
		jb.exclude( excludeAndroid );
		for( String projectName : projectNames )
			jb.addDirectory( ROOT + "/libs/" + projectName + "/src" );
		jb.close();
	}

}
