// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.crypt.blockcipher;

/**
 * NIST Special Publication 800-38A.
 * Recommendation for Block Cipher Modes of Operation.
 */
public enum CryptoMode
{
	/**
	 * Electronic Codebook Mode
	 */
	ECB,

	/**
	 * Cipher Block Chaining Mode 
	 */
	CBC,

	/**
	 * Cipher Feedback Mode
	 */
	CFB,

	/**
	 * Output Feedback Mode
	 */
	OFB,

	/**
	 * GOST 28147-89, RFC 5830, The Counter Encryption Mode
	 */
	Gost28147CTR
}
