// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.crypt.streamcipher;

import org.denom.Binary;

/**
 * Common interface for stream ciphers.
 */
public abstract class StreamCipher
{
	protected Binary key;

	public abstract String getAlgName();

	// -----------------------------------------------------------------------------------------------------------------
	public abstract void setKey( final Binary key );

	public void setKey( final String keyHex )
	{
		setKey( new Binary( keyHex ) );
	}

	public Binary getKey()
	{
		return key.clone();
	}

	// -----------------------------------------------------------------------------------------------------------------
	public int getKeySize()
	{
		return key.size();
	}

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * iv can be null for ciphers without IV.
	 * @return this
	 */
	public abstract StreamCipher startEncrypt( final Binary iv );
	public abstract StreamCipher startDecrypt( final Binary iv );

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * encrypt/decrypt a single byte.
	 * @return encrypted/decrypted byte.
	 */
	public abstract byte process( byte in );
	
	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * encrypt/decrypt incoming bytes.
	 * @return encrypted/decrypted data.
	 */
	public Binary process( final Binary in )
	{
		byte[] inArr = in.getDataRef();
		int len = in.size();
		Binary out = new Binary( in.size() );
		byte[] outArr = out.getDataRef();
		
		for( int i = 0; i < len; ++i )
			outArr[ i ] = process( inArr[ i ] );

		return out;
	}

}
