// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.d5.relay;

/**
 * Коды команд для общения Relay-а со своими клиентами.
 */
public final class RelayCommand
{
	// -----------------------------------------------------------------------------------------------------------------
	// Relay -> Resource
	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * При подключении клиента-ресурса Relay отправит ему эту команду.
	 * Чтобы клиент идентифицировал и аутентифицировал себя.
	 * В ответе - подпись ресурса и случайное число для формирования подписи от Relay-а.
	 */
	public final static int WHO_ARE_YOU         = 0xCD000101;

	/**
	 * Relay отправляет свою подпись для аутентификации себя на клиенте-ресурсе.
	 */
	public final static int RELAY_SIGN          = 0xCD000102;

	// -----------------------------------------------------------------------------------------------------------------
	// User -> Relay
	// -----------------------------------------------------------------------------------------------------------------
	public final static int GET_RESOURCE_INFO   = 0xCD000001;

	// -----------------------------------------------------------------------------------------------------------------
	// User -> Relay -> Resource
	public final static int SEND                = 0xCD000002;
	// User -> Relay -> Resource
	public final static int SEND_ENCRYPTED      = 0xCD000003;


	// -----------------------------------------------------------------------------------------------------------------
	// User -> Relay -> Resource
	// Эта команда передаётся в теле команды SEND
	// -----------------------------------------------------------------------------------------------------------------
	public final static int INIT_SM             = 0xCDD00001;

}
