// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - Applet.
 */
public class ComponentApplet extends CapComponent
{
	public int tag;
	public int size;

	public AppletInfo[] applets;

	// -----------------------------------------------------------------------------------------------------------------
	public static class AppletInfo
	{
		public Binary aid;
		public int installMethodOffset;
	}
	
	// -----------------------------------------------------------------------------------------------------------------
	public ComponentApplet( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_APPLET, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		int count = b.get( offs++ );
		applets = new AppletInfo[ count ];

		for( int i = 0; i < applets.length; ++i )
		{
			AppletInfo app = new AppletInfo();

			int aidLen = b.get( offs++ );
			app.aid = b.slice( offs, aidLen );
			offs += aidLen;

			app.installMethodOffset = b.getU16( offs );
			offs += 2;

			applets[ i ] = app;
		}

		MUST( (tag == TAG_APPLET) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component Applet" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );
		
		b.add( applets.length );
		for( AppletInfo app : applets )
		{
			b.add( app.aid.size() );
			b.add( app.aid );
			b.addU16( app.installMethodOffset );
		}

		return b;
	}

}
