// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - Directory.
 */
public class ComponentDirectory extends CapComponent
{
	public int tag;
	public int size;

	public int[] componentSizes;

	public StaticInfo staticInfo;

	public int importCount;
	public int appletCount;

	public CustomCompInfo[] customComps;

	// -----------------------------------------------------------------------------------------------------------------
	public static class StaticInfo
	{
		public int imageSize;
		public int arrayInitCount;
		public int arrayInitSize;
	}

	// -----------------------------------------------------------------------------------------------------------------
	public static class CustomCompInfo
	{
		public int tag;
		public int size;
		public Binary aid;
	}

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentDirectory( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_DIRECTORY, fullName );

		int offs = 0;
		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		int minorVersion = ((ComponentHeader)cap.getComp( TAG_HEADER )).minorVersion;

		componentSizes = new int[ (minorVersion == 2) ? 12 : 11 ];
		for( int i = 0; i < componentSizes.length; ++i )
		{
			componentSizes[ i ] = b.getU16( offs );
			offs += 2;
		}

		staticInfo = new StaticInfo();
		staticInfo.imageSize = b.getU16( offs ); offs += 2;
		staticInfo.arrayInitCount = b.getU16( offs ); offs += 2;
		staticInfo.arrayInitSize = b.getU16( offs ); offs += 2;

		importCount = b.get( offs++ );
		appletCount = b.get( offs++ );

		int customCount = b.get( offs++ );
		customComps = new CustomCompInfo[ customCount ];
		for( int i = 0; i < customCount; ++i )
		{
			CustomCompInfo comp = new CustomCompInfo();

			comp.tag = b.get( offs++ );
			comp.size = b.getU16( offs ); offs += 2;
			int aidLen = b.get( offs++ );
			comp.aid = b.slice( offs, aidLen );
			offs += aidLen;

			customComps[ i ] = comp;
		}

		MUST( (tag == TAG_DIRECTORY) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component Directory" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );
		for( int sz : componentSizes )
			b.addU16( sz );

		b.addU16( staticInfo.imageSize );
		b.addU16( staticInfo.arrayInitCount );
		b.addU16( staticInfo.arrayInitSize );

		b.add( importCount );
		b.add( appletCount );

		b.add( customComps.length );
		for( CustomCompInfo custom : customComps )
		{
			b.add( custom.tag );
			b.addU16( custom.size );
			b.add( custom.aid.size() );
			b.add( custom.aid );
		}

		return b;
	}

}
