// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - Export.
 */
public class ComponentExport extends CapComponent
{
	public int tag;
	public int size;

	public ClassExportInfo[] classExports;

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentExport( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_EXPORT, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		int count = b.get( offs++ );
		classExports = new ClassExportInfo[ count ];
		for( int i = 0; i < classExports.length; ++i )
		{
			classExports[ i ] = new ClassExportInfo();
			offs = classExports[ i ].parse( b, offs );
		}

		MUST( (tag == TAG_EXPORT) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component Export" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );

		b.add( classExports.length );
		for( ClassExportInfo cl : classExports )
			cl.toBin( b );

		return b;
	}


	// =================================================================================================================
	public static class ClassExportInfo
	{
		int classOffset;
		int[] staticFieldOffsets;
		int[] staticMethodOffsets;

		public int parse( Binary b, int offs )
		{
			classOffset = b.getU16( offs ); offs += 2;

			int staticFieldCount = b.get( offs++ );
			int staticMethodCount = b.get( offs++ );
			
			staticFieldOffsets = new int[ staticFieldCount ];
			for( int i = 0; i < staticFieldCount; ++i )
			{
				staticFieldOffsets[ i ] = b.getU16( offs );
				offs += 2;
			}

			staticMethodOffsets = new int[ staticMethodCount ];
			for( int i = 0; i < staticMethodCount; ++i )
			{
				staticMethodOffsets[ i ] = b.getU16( offs );
				offs += 2;
			}

			return offs;
		}

		public void toBin( Binary b )
		{
			b.addU16( classOffset );

			b.add( staticFieldOffsets.length );
			b.add( staticMethodOffsets.length );

			for( int n : staticFieldOffsets )
				b.addU16( n );

			for( int n : staticMethodOffsets )
				b.addU16( n );
		}
	}
}
