// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - StaticField.
 */
public class ComponentStaticField extends CapComponent
{
	public int tag;
	public int size;

	public int imageSize;
	public int referenceCount;

	public ArrayInitInfo[] arrayInit;

	public int defaultValueCount;

	public Binary nonDefaultValues;

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentStaticField( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_STATIC_FIELD, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		imageSize = b.getU16( offs ); offs += 2;
		referenceCount = b.getU16( offs ); offs += 2;

		int arrayInitCount = b.getU16( offs ); offs += 2;
		arrayInit = new ArrayInitInfo[ arrayInitCount ];
		for( int i = 0; i < arrayInit.length; ++i )
		{
			arrayInit[ i ] = new ArrayInitInfo();
			offs = arrayInit[ i ].parse( b, offs );
		}

		defaultValueCount = b.getU16( offs ); offs += 2;

		int nonDefaultCount = b.getU16( offs ); offs += 2;
		nonDefaultValues = b.slice( offs, nonDefaultCount );
		offs += nonDefaultCount;
		
		MUST( (tag == TAG_STATIC_FIELD) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component StaticField" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );

		b.addU16( imageSize );
		b.addU16( referenceCount );

		b.addU16( arrayInit.length );
		for( ArrayInitInfo elem : arrayInit )
			elem.toBin( b );

		b.addU16( defaultValueCount );

		b.addU16( nonDefaultValues.size() );
		b.add( nonDefaultValues );

		return b;
	}

	// =================================================================================================================
	public static class ArrayInitInfo
	{
		public int type;
		public Binary values;

		public int parse( Binary b, int offs )
		{
			type = b.get( offs++ );
			int count = b.getU16( offs ); offs += 2;
			values = b.slice( offs, count );
			offs += count;
			return offs;
		}

		public void toBin( Binary b )
		{
			b.add( type );
			b.addU16( values.size() );
			b.add( values );
		}
	}

}
