package testblockcipher;

import org.denom.crypt.blockcipher.*;

public class TestBlowfish extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestBlowfish(); }

	TestBlowfish()
	{
		Blowfish alg = new Blowfish();

		check( alg, "0000000000000000", "0000000000000000", "4EF997456198DD78" );

		check( alg, "0000000000000000", "0000000000000000", "4EF997456198DD78" );
		check( alg, "FFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFF", "51866FD5B85ECB8A" );
		check( alg, "3000000000000000", "1000000000000001", "7D856F9A613063F2" );
		check( alg, "1111111111111111", "1111111111111111", "2466DD878B963C9D" );
		check( alg, "0123456789ABCDEF", "1111111111111111", "61F9C3802281B096" );
		check( alg, "FEDCBA9876543210", "0123456789ABCDEF", "0ACEAB0FC6A0A28D" );
		check( alg, "7CA110454A1A6E57", "01A1D6D039776742", "59C68245EB05282B" );
		check( alg, "0131D9619DC1376E", "5CD54CA83DEF57DA", "B1B8CC0B250F09A0" );

		alg.generateKey( 43 );
		checkMode( alg, CryptoMode.CFB, AlignMode.NONE );

		checkAndMeasure( new Blowfish() );
	}
}
