package testblockcipher;

import org.denom.crypt.blockcipher.CAST5;

/**
 * http://www.ietf.org/rfc/rfc2144.txt
 */
class TestCAST5 extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestCAST5(); }

	TestCAST5()
	{
		CAST5 alg = new CAST5();

		check( alg, "0123456712345678234567893456789A", "0123456789ABCDEF", "238B4FE5847E44B2" );
		check( alg, "01234567123456782345", "0123456789ABCDEF", "EB6A711A2C02271B" );
		check( alg, "0123456712", "0123456789ABCDEF", "7Ac816d16E9B302E" );

		checkAndMeasure( alg );
	}
}
