package testblockcipher;

import org.denom.crypt.blockcipher.CAST6;

/**
 * http://www.ietf.org/rfc/rfc2612.txt
 */
class TestCAST6 extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestCAST6(); }

	TestCAST6()
	{
		CAST6 alg = new CAST6();
		String data = "00000000000000000000000000000000";
		check( alg, "2342bb9efa38542c0af75647f29f615d", data, "c842a08972b43d20836c91d1b7530f6b" );
		check( alg, "2342bb9efa38542cbed0ac83940ac298bac77a7717942863", data, "1b386c0210dcadcbdd0e41aa08a7a7e8" );
		check( alg, "2342bb9efa38542cbed0ac83940ac2988d7c47ce264908461cc1b5137ae6b604", data, "4f6a2038286897b9c9870136553317fa" );

		checkAndMeasure( alg );
	}
}
