package testblockcipher;

import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.Camellia128;
import org.denom.crypt.blockcipher.Camellia256;

/**
 * https://www.cosic.esat.kuleuven.be/nessie/testvectors/
 * RFC 3713
 */
class TestCamellia extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestCamellia(); }

	TestCamellia()
	{
		BlockCipher alg = new Camellia128();
		check( alg, "00000000000000000000000000000000", "80000000000000000000000000000000", "07923A39EB0A817D1C4D87BDB82D1F1C" );
		check( alg, "80000000000000000000000000000000", "00000000000000000000000000000000", "6C227F749319A3AA7DA235A9BBA05A2C" );
		check( alg, "0123456789abcdeffedcba9876543210", "0123456789abcdeffedcba9876543210", "67673138549669730857065648eabe43" );
		checkAndMeasure( alg );

		alg = new Camellia256();
		check( alg, "0123456789abcdeffedcba98765432100011223344556677", "0123456789abcdeffedcba9876543210", "b4993401b3e996f84ee5cee7d79b09b9" );
		check( alg, "000000000000000000000000000000000000000000000000", "00040000000000000000000000000000", "9BCA6C88B928C1B0F57F99866583A9BC" );
		check( alg, "949494949494949494949494949494949494949494949494", "636EB22D84B006381235641BCF0308D2", "94949494949494949494949494949494" );
		check( alg, "0123456789abcdeffedcba987654321000112233445566778899aabbccddeeff", "0123456789abcdeffedcba9876543210", "9acc237dff16d76c20ef7c919e3a7509");
		check( alg, "4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A", "057764FE3A500EDBD988C5C3B56CBA9A", "4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A");
		check( alg, "0303030303030303030303030303030303030303030303030303030303030303", "7968B08ABA92193F2295121EF8D75C8A", "03030303030303030303030303030303" );
		checkAndMeasure( alg );
	}
}
