// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package testblockcipher;

import org.denom.log.*;
import org.denom.crypt.blockcipher.*;

import static org.denom.Binary.Bin;

public class TestDES extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestDES(); }

	public TestDES()
	{
		LogConsole log = new LogConsole();
		DES alg = new DES();

		String keyHex = "0123456789abcdef";
		String dataHex = "4e6f77206973207468652074696d6520666f7220616c6c20";

		check( alg, CryptoMode.ECB, AlignMode.NONE,
				keyHex, Bin("0000000000000000"), dataHex, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53" );

		check( alg, CryptoMode.CBC, AlignMode.NONE,
				keyHex, Bin("1234567890abcdef"), dataHex, "e5c7cdde872bf27c43e934008c389c0f683788499a7c05f6" );

		check( alg, CryptoMode.CFB, AlignMode.NONE,
				keyHex, Bin("1234567890abcdef"), dataHex, "f3096249c7f46e51a69e839b1a92f78403467133898ea622" );

		checkMode( alg, CryptoMode.ECB, AlignMode.NONE );
		checkMode( alg, CryptoMode.CBC, AlignMode.NONE );
		checkMode( alg, CryptoMode.CFB, AlignMode.NONE );
		checkMode( alg, CryptoMode.OFB, AlignMode.NONE );

		checkMode( alg, CryptoMode.ECB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CBC, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CFB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.OFB, AlignMode.BLOCK );

		checkMAC( alg, AlignMode.NONE );
		checkMAC( alg, AlignMode.BLOCK );

		jceCompareEncrypt( alg, "DES", CryptoMode.ECB );
		jceCompareEncrypt( alg, "DES", CryptoMode.CBC );
		jceCompareEncrypt( alg, "DES", CryptoMode.CFB );
		jceCompareEncrypt( alg, "DES", CryptoMode.OFB );

		long t = measure( alg, CryptoMode.CBC, ITERATIONS, DATA_SIZE );
		log.writeln( "Time DES     : " + t + " ms" );

		t = jceMeasureTime( "DES", CryptoMode.CBC, ITERATIONS, Bin().random( 8 ), Bin().random( 8 ), Bin().random( DATA_SIZE ) );
		log.writeln( "Time DES JCE : " + t + " ms" );

		log.writeln( "Test DES     : OK\n" );
	}
}
