package testblockcipher;

import org.denom.Binary;
import org.denom.crypt.blockcipher.*;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

public class TestKuznyechik extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestKuznyechik(); }

	TestKuznyechik()
	{
		String key = "8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef";
		Kuznyechik alg = new Kuznyechik();
		check( alg, key, "1122334455667700ffeeddccbbaa9988", "7f679d90bebc24305a468d42b9d4edcd");

		String iv = "1234567890abcef0a1b2c3d4e5f00112";
		String plain = "1122334455667700ffeeddccbbaa998800112233445566778899aabbcceeff0a112233445566778899aabbcceeff0a002233445566778899aabbcceeff0a0011";

		check( alg, CryptoMode.CBC, AlignMode.NONE, key, Bin(iv), plain,
				"689972D4A085FA4D90E52E3D6D7DCC27ABF170B2B226C3010CCFA136D659CDAACA719272AB1D438E15507D521ECD5522E01108FF8D9D3A6D8CA2A533FA614E71" );

		check( alg, CryptoMode.CFB, AlignMode.NONE, key, Bin(iv), plain,
				"81800A59B1842B24FF1F795E897ABD9568C1B99C4DF59CC7951E3739B5B3CDBF073F4DD2D6DEB3CFB026545F7AF1D8E8E1C852E9A8567162DBB5DA7F66DEA926" );

		check( alg, CryptoMode.OFB, AlignMode.NONE, key, Bin(iv), plain,
				"81800A59B1842B24FF1F795E897ABD95779146DB2D93A94ED93CF68B32397F19E93C9E57441D870545F24036A58CEEA3CF3F0061D56423545B960D864CC868DA" );

		checkCTR( alg, key, "1234567890abcef0", plain,
				"f195d8bec10ed1dbd57b5fa240bda1b885eee733f6a13e5df33ce4b33c45dee4a5eae88be6356ed3d5e877f13564a3a5cb91fab1f20cbab6d1c6d15820bdba73" );

		checkCTR( alg, 1, key, "1234567890abcef0", plain,
				"f1a787ad3a88f9a0bc735293f98c12c3eb31621b9b2e6461c7ef73a2e6a6b1793ddf722f7b1d22a722ec4d3edbc313bcd356b313d37af9e5ef934fa223c13fe2" );

		alg.setKey( key );
		Binary cmac = alg.calcCMAC( Bin(plain), null );
		MUST( cmac.first(8).equals( "336f4d296059fbe3" ), "Wrong CMAC" );

		checkAndMeasure( alg );
	}
}
