package testblockcipher;

import org.denom.Binary;
import org.denom.crypt.blockcipher.*;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

public class TestMagma extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestMagma(); }

	// -----------------------------------------------------------------------------------------------------------------
	TestMagma()
	{
		Magma alg = new Magma();

		String key = "ffeeddccbbaa99887766554433221100f0f1f2f3f4f5f6f7f8f9fafbfcfdfeff";

		check( alg, key, "fedcba9876543210", "4ee901e5c2d8ca3d" );

		check( alg, CryptoMode.CBC, AlignMode.NONE, "8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef",
				Bin("0011223344556677"),
				"1122334455667700ffeeddccbbaa99881122334455667700ffeeddccbbaa99881122334455667700ffeeddccbbaa9988",
				"ea1fbca6a8009abfb73e10fc007c29308370e469c075690bb2965efc51b2fcea3468898d5e4fb9560686a8bba594edf2");

		alg.setKey( key );
		String plain = "92def06b3c130a59db54c704f8189d204a98fb2e67a8024c8912409b17b57e41";

		// 34.13, A.2.1 (ECB - Режим простой замены)
		check( alg, key, plain, "2b073f0494f372a0de70e715d3556e4811d8d9e9eacfbc1e7c68260996c67efb" );

		// 34.13, A.2.6
		Binary cmac = alg.calcCMAC( Bin(plain), null );
		MUST( cmac.equals( "154e72102030c5bb" ), "Wrong CMAC" );

		checkAndMeasure( alg );
	};
}
