package testblockcipher;

import org.denom.crypt.blockcipher.*;

import static org.denom.Binary.Bin;

/**
 * RC5 tester - vectors from ftp://ftp.nordu.net/rfc/rfc2040.txt
 * RFC 2040 "The RC5, RC5-CBC, RC5-CBC-Pad, and RC5-CTS Algorithms"
 */
public class TestRC5 extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestRC5(); }

	// -----------------------------------------------------------------------------------------------------------------
	private void checkRC5( int rounds, String key, String iv, String plain, String crypt )
	{
		check( new RC5_32( rounds ), CryptoMode.CBC, AlignMode.NONE, key, Bin(iv), plain, crypt );
	}
	
	// -----------------------------------------------------------------------------------------------------------------
	TestRC5()
	{
		checkRC5( 0,  "00", "0000000000000000", "0000000000000000", "7a7bba4d79111d1e" );
		checkRC5( 0,  "00", "0000000000000000", "ffffffffffffffff", "797bba4d78111d1e" );
		checkRC5( 0,  "00", "0000000000000001", "0000000000000000", "7a7bba4d79111d1f" ); 
		checkRC5( 0,  "00", "0000000000000000", "0000000000000001", "7a7bba4d79111d1f" );
		checkRC5( 0,  "00", "0102030405060708", "1020304050607080", "8b9ded91ce7794a6" );
		checkRC5( 1,  "11", "0000000000000000", "0000000000000000", "2f759fe7ad86a378" );
		checkRC5( 2,  "00", "0000000000000000", "0000000000000000", "dca2694bf40e0788" );
		checkRC5( 2,  "00000000", "0000000000000000", "0000000000000000", "dca2694bf40e0788");
		checkRC5( 8,  "00000000", "0000000000000000", "0000000000000000", "dcfe098577eca5ff");
		checkRC5( 8,  "00", "0102030405060708", "1020304050607080", "9646fb77638f9ca8" );
		checkRC5( 12, "00", "0102030405060708", "1020304050607080", "b2b3209db6594da4" );
		checkRC5( 16, "00", "0102030405060708", "1020304050607080", "545f7f32a5fc3836" );
		checkRC5( 8,  "01020304", "0000000000000000", "ffffffffffffffff", "8285e7c1b5bc7402");
		checkRC5( 12, "01020304", "0000000000000000", "ffffffffffffffff", "fc586f92f7080934");
		checkRC5( 16, "01020304", "0000000000000000", "ffffffffffffffff", "cf270ef9717ff7c4");
		checkRC5( 12, "0102030405060708", "0000000000000000", "ffffffffffffffff", "e493f1c1bb4d6e8c" );
		checkRC5( 8,  "0102030405060708", "0102030405060708", "1020304050607080", "5c4c041e0f217ac3");
		checkRC5( 12, "0102030405060708", "0102030405060708", "1020304050607080", "921f12485373b4f7");
		checkRC5( 16, "0102030405060708", "0102030405060708", "1020304050607080", "5ba0ca6bbe7f5fad" );
		checkRC5( 8,  "01020304050607081020304050607080", "0102030405060708", "1020304050607080", "c533771cd0110e63");
		checkRC5( 12, "01020304050607081020304050607080", "0102030405060708", "1020304050607080", "294ddb46b3278d60");
		checkRC5( 16, "01020304050607081020304050607080", "0102030405060708", "1020304050607080", "dad6bda9dfe8f7e8" );
		checkRC5( 12, "0102030405", "0000000000000000", "ffffffffffffffff", "97e0787837ed317f" );
		checkRC5( 8, "0102030405", "0000000000000000", "ffffffffffffffff", "7875dbf6738c6478" );
		checkRC5( 8, "0102030405", "7875dbf6738c6478", "0808080808080808", "8f34c3c681c99695" );

		check( new RC5_64( 0 ), "00", "00000000000000000000000000000000", "9f09b98d3f6062d9d4d59973d00e0e63" );
		check( new RC5_64( 0 ), "00", "ffffffffffffffffffffffffffffffff", "9e09b98d3f6062d9d3d59973d00e0e63" );

		RC5_64 alg = new RC5_64();
		checkAndMeasure( alg );
	}
}
