package testblockcipher;

import org.denom.crypt.blockcipher.SEED;

/**
 * https://www.rfc-editor.org/rfc/rfc4269
 */
public class TestSEED extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestSEED(); }

	TestSEED()
	{
		SEED alg = new SEED();
		check( alg, "00000000000000000000000000000000", "000102030405060708090A0B0C0D0E0F", "5EBAC6E0054E166819AFF1CC6D346CDB" );
		check( alg, "000102030405060708090A0B0C0D0E0F", "00000000000000000000000000000000", "C11F22F20140505084483597E4370F43" );
		check( alg, "4706480851E61BE85D74BFB3FD956185", "83A2F8A288641FB9A4E9A5CC2F131C7D", "EE54D13EBCAE706D226BC3142CD40D4A" );
		check( alg, "28DBC3BC49FFD87DCFA509B11D422BE7", "B41E6BE2EBA84A148E2EED84593C5EC7", "9B9B7BFCD1813CB95D0B3618F40F5122" );
		check( alg, "0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E", "0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E", "8296F2F1B007AB9D533FDEE35A9AD850" );

		checkAndMeasure( alg );
	}
}
