package testblockcipher;

import org.denom.crypt.blockcipher.Serpent;

class TestSerpent extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestSerpent(); }

	TestSerpent()
	{
		Serpent alg = new Serpent();
		check( alg, "00000000000000000000000000000000", "00000000000000000000000000000000", "3620b17ae6a993d09618b8768266bae9" );

		check( alg, "00000000000000000000000000000000", "00000000000000000000000000000000", "3620b17ae6a993d09618b8768266bae9" );
		check( alg, "80000000000000000000000000000000", "00000000000000000000000000000000", "264E5481EFF42A4606ABDA06C0BFDA3D" );
		check( alg, "D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9", "D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9", "20EA07F19C8E93FDA30F6B822AD5D486" );
		check( alg, "000102030405060708090A0B0C0D0E0F", "33B3DC87EDDD9B0F6A1F407D14919365", "00112233445566778899AABBCCDDEEFF" );
		check( alg, "2BD6459F82C5B300952C49104881FF48", "BEB6C069393822D3BE73FF30525EC43E", "EA024714AD5C4D84EA024714AD5C4D84" );
		check( alg, "000000000000000000000000000000000000000000008000", "00000000000000000000000000000000", "40520018C4AC2BBA285AEEB9BCB58755" );
		check( alg, "000102030405060708090A0B0C0D0E0F1011121314151617", "4528CACCB954D450655E8CFD71CBFAC7", "00112233445566778899AABBCCDDEEFF" );
		check( alg, "2BD6459F82C5B300952C49104881FF482BD6459F82C5B300", "E0208BE278E21420C4B1B9747788A954", "EA024714AD5C4D84EA024714AD5C4D84" );
		check( alg, "0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000001", "AD86DE83231C3203A86AE33B721EAA9F" );
		check( alg, "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "3DA46FFA6F4D6F30CD258333E5A61369", "00112233445566778899AABBCCDDEEFF" );
		check( alg, "2BD6459F82C5B300952C49104881FF482BD6459F82C5B300952C49104881FF48", "677C8DFAA08071743FD2B415D1B28AF2", "EA024714AD5C4D84EA024714AD5C4D84" );

		checkMonteCarlo( alg, 100, "F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3", "F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3", "8FD0E58DB7A54B929FCA6A12F96F20AF" );
		checkMonteCarlo( alg, 100, "0004000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E7B681E8871FD05FEAE5FB64DA891EA2" );
		checkMonteCarlo( alg, 100, "0000000020000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C5545D516EEC73BFA3622A8194F95620" );
		checkMonteCarlo( alg, 100, "0000000000000000000000000000000000000000000000000000000002000000", "00000000000000000000000000000000", "11FF5C9BE006F82C98BD4FAC1A19920E" );
		checkMonteCarlo( alg, 100, "0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000010000", "47CA1CA404B6481CAD4C21C8A0415A0E" );
		checkMonteCarlo( alg, 100, "0000000000000000000000000000000000000000000000000000000000000000", "00000000000000008000000000000000", "A0A2D5B07E27D539CA5BEE9DE1EAB3E6" );

		checkAndMeasure( alg );
	}
}
