package testblockcipher;

import org.denom.crypt.blockcipher.Shacal2;

import static org.denom.Binary.Bin;

/**
 * https://www.cosic.esat.kuleuven.be/nessie/testvectors/
 */
class TestShacal2 extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestShacal2(); }

	TestShacal2()
	{
		Shacal2 alg = new Shacal2();
		
		check( alg, "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F",
				"98BCC10405AB0BFC686BECECAAD01AC19B452511BCEB9CB094F905C51CA45430",
				"00112233445566778899AABBCCDDEEFF102132435465768798A9BACBDCEDFE0F" );

		check( alg, "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F",
			"98BCC10405AB0BFC686BECECAAD01AC19B452511BCEB9CB094F905C51CA45430",
			"00112233445566778899AABBCCDDEEFF102132435465768798A9BACBDCEDFE0F" );

		check( alg, "2BD6459F82C5B300952C49104881FF482BD6459F82C5B300952C49104881FF482BD6459F82C5B300952C49104881FF482BD6459F82C5B300952C49104881FF48",
			"481F122A75F2C4C3395140B5A951EBBA06D96BDFD9D8FF4FB59CBD1287808D5A",
			"EA024714AD5C4D84EA024714AD5C4D84EA024714AD5C4D84EA024714AD5C4D84" );

		check( alg, Bin( 64, 0xFF ).Hex(),
			"94FEDFF2A0CFE3C983D340C88D73F8CF4B79FC581797EC10B27D4DA1B51E1BC7",
			"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" );

		check( alg, Bin( 64, 0x64 ).Hex(),
			"6643CB84B3B3F126F5E50959EF4CE73DB8500918ABE1056368DB06CA8C1C0D45",
			"6464646464646464646464646464646464646464646464646464646464646464" );

		check( alg, Bin( 64, 0x32 ).Hex(),
			"92E937285AB11FE3561542C43C918966971DE722E9B9D38BD69EAC77899DCF81",
			"3232323232323232323232323232323232323232323232323232323232323232" );

		String zeros64 = Bin( 64 ).Hex();
		check( alg, zeros64,
			"F8C9259FA4F5D787B570AFA9219166A63636FC5C30AC289155D0CC4FFCB4B03D",
			"0000000000000000000000000000000000000000000000000000000000000000" );

		check( alg, zeros64,
			"F4E976DF0172CD961D4C8D466A12F6765B9089046E747CD2A41BF43C18A8328E",
			"0000000000000000000000000000000000000000000000000000000000000001" );

		check( alg, zeros64,
			"3B929F0597E21D0076EC399D21B67713B40E3AD559704219A26A3380212D5AD6",
			"0000000000000000000000000800000000000000000000000000000000000000" );

		check( alg, zeros64,
			"43A0DAD8307F19FBBCF166FE20BAC075C56FF14042550E472094B042BE5963EE",
			"8000000000000000000000000000000000000000000000000000000000000000" );

		String key1 = "80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
		String data1 = Bin( 32 ).Hex();
		check( alg, key1, data1, "361AB6322FA9E7A7BB23818D839E01BDDAFDF47305426EDD297AEDB9F6202BAE" );
		checkMonteCarlo( alg,  100, key1, data1, "226A582DE04383D0F3E7DE655DD848AC3E14CCFB4E76F7B7069879F67C4D5420" );
		checkMonteCarlo( alg, 1000, key1, data1, "B05D5A18C0712082CFF5BA9DBBCD7269114FC3DF83B42DAC306D95BBC473D839" );

		String key2 = "00000000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
		check( alg, key2, data1, "F703282E54592A5617E10618027BB67F639E43A90767150D8B7F5E83054B3CBD" );
		checkMonteCarlo( alg,  100, key2, data1, "3B442692B579485B8BA2F92CE3B90DE7D2EA03D8B3C8E7BE7BF6415F798EED90" );
		checkMonteCarlo( alg, 1000, key2, data1, "331B9B65F06230380BBEECFBFBA94BCF92AF6341F815D7651F996144A5377263" );

		checkAndMeasure( alg );
	}
}
