// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package testblockcipher;

import org.denom.crypt.blockcipher.*;
import org.denom.log.LogConsole;

import static org.denom.Binary.Bin;

public class TestTripleDES extends CheckBlockCipher
{
	public static void main( String[] args ) { new TestTripleDES(); }

	TestTripleDES()
	{
		LogConsole log = new LogConsole();

		checkCTR( new TripleDES(), "0123456789ABCDEF 23456789ABCDEF01 456789ABCDEF0123",
				"0000000000000000",
				"4E6F772069732074 68652074696D6520 666F7220616C6C20",
				"00D504BCF0F8EB14 36DBD9F88BC05C6C E9A3D9160F9960EE" );

		TripleDES alg = new TripleDES( Bin(16) );
		checkMode( alg, CryptoMode.ECB, AlignMode.NONE );
		checkMode( alg, CryptoMode.CBC, AlignMode.NONE );
		checkMode( alg, CryptoMode.CFB, AlignMode.NONE );
		checkMode( alg, CryptoMode.OFB, AlignMode.NONE );

		checkMode( alg, CryptoMode.ECB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CBC, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CFB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.OFB, AlignMode.BLOCK );

		checkMAC( alg, AlignMode.NONE );
		checkMAC( alg, AlignMode.BLOCK );

		alg = new TripleDES( Bin(24) );
		checkMode( alg, CryptoMode.ECB, AlignMode.NONE );
		checkMode( alg, CryptoMode.CBC, AlignMode.NONE );
		checkMode( alg, CryptoMode.CFB, AlignMode.NONE );
		checkMode( alg, CryptoMode.OFB, AlignMode.NONE );

		checkMode( alg, CryptoMode.ECB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CBC, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.CFB, AlignMode.BLOCK );
		checkMode( alg, CryptoMode.OFB, AlignMode.BLOCK );

		checkMAC( alg, AlignMode.NONE );
		checkMAC( alg, AlignMode.BLOCK );

		jceCompareEncrypt( alg, "TripleDES", CryptoMode.ECB );
		jceCompareEncrypt( alg, "TripleDES", CryptoMode.CBC );
		jceCompareEncrypt( alg, "TripleDES", CryptoMode.CFB );
		jceCompareEncrypt( alg, "TripleDES", CryptoMode.OFB );

		alg = new TripleDES();
		alg.generateKey( 24 );
		
		long t = measure( alg, CryptoMode.CBC, ITERATIONS, DATA_SIZE );
		log.writeln( "Time TripleDES     : " + t + " ms" );

		t = jceMeasureTime( "TripleDES", CryptoMode.CBC, ITERATIONS, alg.getKey(), Bin().random( 8 ), Bin().random( DATA_SIZE ) );
		log.writeln( "Time TripleDES JCE : " + t + " ms" );
		log.writeln( "Test TripleDES     : OK\n" );
	}
}