// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package testcrypthash;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.*;

/**
 * Use HMAC SHA-1
 */
class UseHMAC
{
	public static void main( String[] args )
	{
		Binary key = new Binary().fromUTF8( "key" );
		Binary data = new Binary().fromUTF8( "data" );

		HMAC hmac = new HMAC( new SHA1(), key );
		Ex.MUST( hmac.calc( data ).equals( "104152c5bfdca07bc633eebd46199f0255c9f49d" ) );

		System.out.println( "OK" );
	}
}
