package teststreamcipher;

import org.denom.Binary;
import org.denom.Ticker;
import org.denom.log.LogConsole;
import org.denom.crypt.streamcipher.StreamCipher;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

class CheckStreamCipher
{
	LogConsole log = new LogConsole();

	int ITERATIONS = 1000;
	int DATA_SIZE = 4096;
	
	// -----------------------------------------------------------------------------------------------------------------
	static void check( StreamCipher alg, String key, Binary iv, String plainHex, String cryptHex )
	{
		alg.setKey( key );

		alg.startEncrypt( iv );
		Binary crypt = alg.process( Bin( plainHex ) );
		MUST( crypt.equals( cryptHex ), "Wrong cryptogram" );

		alg.startEncrypt( iv );
		Binary plain = alg.process( crypt );
		MUST( plain.equals( plainHex ), "Wrong plain" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	static void check( StreamCipher alg, String key, String plainHex, String cryptHex )
	{
		check( alg, key, null, plainHex, cryptHex );
	}

	// -----------------------------------------------------------------------------------------------------------------
	static long measure( StreamCipher alg, Binary iv, int iterations, int dataSize )
	{
		Binary key = Bin().random( alg.getKeySize() );
		alg.setKey( key );
		Binary data = Bin().random( dataSize );

		long tMS = Ticker.measureMs( iterations, () ->
		{
			Binary crypt = alg.startEncrypt( iv ).process( data );
			alg.startDecrypt( iv ).process( crypt );
		} );
		return tMS;
	}

	// -----------------------------------------------------------------------------------------------------------------
	void measure( StreamCipher alg, Binary iv )
	{
		long t = measure( alg, iv, ITERATIONS, DATA_SIZE );
		log.writeln( "Time " + alg.getAlgName() + ": " + t + " ms" );

		log.writeln( "Test " + alg.getAlgName() + ": OK\n" );
	}
}
