package teststreamcipher;

import org.denom.Binary;
import org.denom.crypt.streamcipher.ChaCha;

import static org.denom.Binary.Bin;
import static org.denom.Ex.*;

/**
 * Test cases generated using ref version of ChaCha20 in estreambench-20080905.
 */
public class TestChaCha extends CheckStreamCipher
{
	public static void main( String[] args ) { new TestChaCha(); }

	TestChaCha()
	{
		test1( new ChaCha(), "80000000000000000000000000000000", "0000000000000000",
				"FBB87FBB8395E05DAA3B1D683C422046F913985C2AD9B23CFC06C1D8D04FF213D44A7A7CDB84929F915420A8A3DC58BF0F7ECB4B1F167BB1A5E6153FDAF4493D",
				"D9485D55B8B82D792ED1EEA8E93E9BC1E2834AD0D9B11F3477F6E106A2F6A5F2EA8244D5B925B8050EAB038F58D4DF577FAFD1B89359DAE508B2B10CBD6B488E",
				"08661A35D6F02D3D9ACA8087F421F7C8A42579047D6955D937925BA21396DDD474B1FC4ACCDCAA33025B4BCE817A4FBF3E5D07D151D7E6FE04934ED466BA4779",
				"A7E16DD38BA48CCB130E5BE9740CE359D631E91600F85C8A5D0785A612D1D98790780ACDDC26B69AB106CCF6D866411D10637483DBF08CC5591FD8B3C87A3AE0" );

		test1( new ChaCha(), "00400000000000000000000000000000", "0000000000000000",
				"A276339F99316A913885A0A4BE870F0691E72B00F1B3F2239F714FE81E88E00CBBE52B4EBBE1EA15894E29658C4CB145E6F89EE4ABB045A78514482CE75AFB7C",
				"0DFB9BD4F87F68DE54FBC1C6428FDEB063E997BE8490C9B7A4694025D6EBA2B15FE429DB82A7CAE6AAB22918E8D004496FB6291467B5AE81D4E85E81D8795EBB",
				"546F5BB315E7F71A46E56D4580F90889639A2BA528F757CF3B048738BA141AF3B31607CB21561BAD94721048930364F4B1227CFEB7CDECBA881FB44903550E68",
				"6F813586E76691305A0CF048C0D8586DC89460207D8B230CD172398AA33D19E92D24883C3A9B0BB7CD8C6B2668DB142E37A97948A7A01498A21110297984CD20" );

		test1( new ChaCha( 12 ), "80000000000000000000000000000000", "0000000000000000",
				"36CF0D56E9F7FBF287BC5460D95FBA94AA6CBF17D74E7C784DDCF7E0E882DDAE3B5A58243EF32B79A04575A8E2C2B73DC64A52AA15B9F88305A8F0CA0B5A1A25",
				"83496792AB68FEC75ADB16D3044420A4A00A6E9ADC41C3A63DBBF317A8258C85A9BC08B4F76B413A4837324AEDF8BC2A67D53C9AB9E1C5BC5F379D48DF9AF730",
				"BAA28ED593690FD760ADA07C95E3B8884B4B64E488CA7A2D9BDC262243AB9251394C5037E255F8BCCDCD31306C508FFBC9E0161380F7911FCB137D46D9269250",
				"B7ECFB6AE0B51915762FE1FD03A14D0C9E54DA5DC76EB16EBA5313BC535DE63DC72D7F9F1874E301E99C8531819F4E3775793F6A5D19C717FA5C78A39EB804A6" );

		test1( new ChaCha( 8 ), "80000000000000000000000000000000", "0000000000000000",
				"BEB1E81E0F747E43EE51922B3E87FB38D0163907B4ED49336032AB78B67C24579FE28F751BD3703E51D876C017FAA43589E63593E03355A7D57B2366F30047C5",
				"33B8B7CA8F8E89F0095ACE75A379C651FD6BDD55703C90672E44C6BAB6AACDD87C976A87FD264B906E749429284134C238E3B88CF74A68245B860D119A8BDF43",
				"F7CA95BF08688BD3BE8A27724210F9DC16F32AF974FBFB09E9F757C577A245ABF35F824B70A4C02CB4A8D7191FA8A5AD6A84568743844703D353B7F00A8601F4",
				"7B4117E8BFFD595CD8482270B08920FBC9B97794E1809E07BB271BF07C8610034C38DBA6ECA04E5474F399A284CBF6E27F70142E604D0977797DE5B58B6B25E0" );

		test2( new ChaCha(), "0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D", "0D74DB42A91077DE",
				"57459975BC46799394788DE80B928387862985A269B9E8E77801DE9D874B3F51AC4610B9F9BEE8CF8CACD8B5AD0BF17D3DDF23FD7424887EB3F81405BD498CC3",
				"EF9AEC58ACE7DB427DF012B2B91A0C1E8E4759DCE9CDB00A2BD59207357BA06CE02D327C7719E83D6348A6104B081DB03908E5186986AE41E3AE95298BB7B713",
				"17EF5FF454D85ABBBA280F3A94F1D26E950C7D5B05C4BB3A78326E0DC5731F8384205C32DB867D1B476CE121A0D7074BAA7EE90525D15300F48EC0A6624BD0AF" );

		test2( new ChaCha(), "0558ABFE51A4F74A9DF04396E93C8FE23588DB2E81D4277ACD2073C6196CBF12", "167DE44BB21980E7",
				"92A2508E2C4084567195F2A1005E552B4874EC0504A9CD5E4DAF739AB553D2E783D79C5BA11E0653BEBB5C116651302E8D381CB728CA627B0B246E83942A2B99",
				"E1974EC3063F7BD0CBA58B1CE34BC87467AAF5759B05EA46682A5D4306E5A76BD99A448DB8DE73AF97A73F5FBAE2C77635040464524CF14D7F08D4CE1220FD84",
				"BE3436141CFD62D12FF7D852F80C134481F152AD0235ECF8CA172C55CA8C031B2E785D773A988CA8D4BDA6FAE0E493AA71DCCC4C894D1F106CAC62A9FC0A9607" );

		skipTest();

		measure( new ChaCha(), Bin(8) );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void test1( ChaCha alg, String keyHex, String ivHex, String crypt0, String crypt3, String crypt4, String crypt7 )
	{
		Binary zeroes = Bin( 64 );
		Binary crypt;

		alg.setKey( keyHex );
		alg.startEncrypt( Bin( ivHex ) );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt0 ), "Wrong cryptogram" );

		alg.process( zeroes );

		alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt3 ), "Wrong cryptogram" );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt4 ), "Wrong cryptogram" );

		alg.process( zeroes );

		alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt7 ), "Wrong cryptogram" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void test2( ChaCha alg, String keyHex, String ivHex, String crypt0, String crypt1023, String crypt1024 )
	{
		Binary zeroes = Bin( 64 );
		Binary crypt;

		alg.setKey( keyHex );
		alg.startEncrypt( Bin( ivHex ) );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt0 ), "Wrong cryptogram" );
		
		for( int i = 1; i < 1023; ++i )
			alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt1023 ), "Wrong cryptogram" );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt1024 ), "Wrong cryptogram" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void skipTest()
	{
		Binary plain = Bin().random( 4000 );
		
		ChaCha alg = new ChaCha();
		alg.setKey( "0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D" );

		Binary iv = Bin("0D74DB42A91077DE");

		alg.startEncrypt( iv );
		Binary crypt = alg.process( plain );

		alg.startEncrypt( iv );
		alg.skip( 10 );
		Binary cryptPart = alg.process( plain.slice( 10, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 10, 20 ) ), "Wrong skip" );

		alg.skip( 1000 );
		cryptPart = alg.process( plain.slice( 1030, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1030, 20 ) ), "Wrong skip" );

		alg.skip( -10 );
		cryptPart = alg.process( plain.slice( 1040, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1040, 20 ) ), "Wrong skip" );

		alg.skip( -1000 );
		MUST( alg.getPosition() == 60, "Wrong position" );

		cryptPart = alg.process( plain.slice( 60, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 60, 20 ) ), "Wrong skip" );

		long pos = alg.seekTo( 1010 );
		MUST( pos == 1010, "Wrong position" );

		cryptPart = alg.process( plain.slice( 1010, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1010, 20 ) ), "Wrong skip" );
	}
}
