package teststreamcipher;

import org.denom.Binary;
import org.denom.crypt.streamcipher.Salsa20;

import static org.denom.Binary.Bin;
import static org.denom.Ex.*;

public class TestSalsa20 extends CheckStreamCipher
{
	public static void main( String[] args ) { new TestSalsa20(); }

	// -----------------------------------------------------------------------------------------------------------------
	TestSalsa20()
	{
		test1( new Salsa20(), "80000000000000000000000000000000", "0000000000000000",
				"4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA",
				"DA9C1581F429E0A00F7D67E23B730676783B262E8EB43A25F55FB90B3E753AEF8C6713EC66C51881111593CCB3E8CB8F8DE124080501EEEB389C4BCB6977CF95",
				"7D5789631EB4554400E1E025935DFA7B3E9039D61BDC58A8697D36815BF1985CEFDF7AE112E5BB81E37ECF0616CE7147FC08A93A367E08631F23C03B00A8DA2F",
				"B375703739DACED4DD4059FD71C3C47FC2F9939670FAD4A46066ADCC6A5645783308B90FFB72BE04A6B147CBE38CC0C3B9267C296A92A7C69873F9F263BE9703" );

		test1( new Salsa20(), "00400000000000000000000000000000", "0000000000000000",
				"0471076057830FB99202291177FBFE5D38C888944DF8917CAB82788B91B53D1CFB06D07A304B18BB763F888A61BB6B755CD58BEC9C4CFB7569CB91862E79C459",
				"D1D7E97556426E6CFC21312AE38114259E5A6FB10DACBD88E4354B04725569352B6DA5ACAFACD5E266F9575C2ED8E6F2EFE4B4D36114C3A623DD49F4794F865B",
				"AF06FAA82C73291231E1BD916A773DE152FD2126C40A10C3A6EB40F22834B8CC68BD5C6DBD7FC1EC8F34165C517C0B639DB0C60506D3606906B8463AA0D0EC2F",
				"AB3216F1216379EFD5EC589510B8FD35014D0AA0B613040BAE63ECAB90A9AF79661F8DA2F853A5204B0F8E72E9D9EB4DBA5A4690E73A4D25F61EE7295215140C" );

		test1( new Salsa20( 12 ), "80000000000000000000000000000000", "0000000000000000",
				"FC207DBFC76C5E1774961E7A5AAD09069B2225AC1CE0FE7A0CE77003E7E5BDF8B31AF821000813E6C56B8C1771D6EE7039B2FBD0A68E8AD70A3944B677937897",
				"4B62A4881FA1AF9560586510D5527ED48A51ECAFA4DECEEBBDDC10E9918D44AB26B10C0A31ED242F146C72940C6E9C3753F641DA84E9F68B4F9E76B6C48CA5AC",
				"F52383D9DEFB20810325F7AEC9EADE34D9D883FEE37E05F74BF40875B2D0BE79ED8886E5BFF556CEA8D1D9E86B1F68A964598C34F177F8163E271B8D2FEB5996",
				"A52ED8C37014B10EC0AA8E05B5CEEE123A1017557FB3B15C53E6C5EA8300BF74264A73B5315DC821AD2CAB0F3BB2F152BDAEA3AEE97BA04B8E72A7B40DCC6BA4" );

		test1( new Salsa20( 8 ), "80000000000000000000000000000000", "0000000000000000",
				"A9C9F888AB552A2D1BBFF9F36BEBEB337A8B4B107C75B63BAE26CB9A235BBA9D784F38BEFC3ADF4CD3E266687EA7B9F09BA650AE81EAC6063AE31FF12218DDC5",
				"BB5B6BB2CC8B8A0222DCCC1753ED4AEB23377ACCBD5D4C0B69A8A03BB115EF71871BC10559080ACA7C68F0DEF32A80DDBAF497259BB76A3853A7183B51CC4B9F",
				"4436CDC0BE39559F5E5A6B79FBDB2CAE4782910F27FFC2391E05CFC78D601AD8CD7D87B074169361D997D1BED9729C0DEB23418E0646B7997C06AA84E7640CE3",
				"BEE85903BEA506B05FC04795836FAAAC7F93F785D473EB762576D96B4A65FFE463B34AAE696777FC6351B67C3753B89BA6B197BD655D1D9CA86E067F4D770220" );

		test2( new Salsa20(), "0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D", "0D74DB42A91077DE",
				"F5FAD53F79F9DF58C4AEA0D0ED9A9601F278112CA7180D565B420A48019670EAF24CE493A86263F677B46ACE1924773D2BB25571E1AA8593758FC382B1280B71",
				"B70C50139C63332EF6E77AC54338A4079B82BEC9F9A403DFEA821B83F7860791650EF1B2489D0590B1DE772EEDA4E3BCD60FA7CE9CD623D9D2FD5758B8653E70",
				"81582C65D7562B80AEC2F1A673A9D01C9F892A23D4919F6AB47B9154E08E699B4117D7C666477B60F8391481682F5D95D96623DBC489D88DAA6956B9F0646B6E" );

		test2( new Salsa20(), "0558ABFE51A4F74A9DF04396E93C8FE23588DB2E81D4277ACD2073C6196CBF12", "167DE44BB21980E7",
				"3944F6DC9F85B128083879FDF190F7DEE4053A07BC09896D51D0690BD4DA4AC1062F1E47D3D0716F80A9B4D85E6D6085EE06947601C85F1A27A2F76E45A6AA87",
				"36E03B4B54B0B2E04D069E690082C8C592DF56E633F5D8C7682A02A65ECD13718CA4352AACCB0DA20ED6BBBA62E177F210E3560E63BB822C4158CAA806A88C82",
				"1B779E7A917C8C26039FFB23CF0EF8E08A1A13B43ACDD9402CF5DF38501098DFC945A6CC69A6A17367BC03431A86B3ED04B0245B56379BF997E25800AD837D7D" );

		skipTest();

		measure( new Salsa20(), Bin(8) );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void test1( Salsa20 alg, String keyHex, String ivHex, String crypt0, String crypt3, String crypt4, String crypt7 )
	{
		Binary zeroes = Bin( 64 );
		Binary crypt;

		alg.setKey( keyHex );
		alg.startEncrypt( Bin( ivHex ) );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt0 ), "Wrong cryptogram" );

		alg.process( zeroes );

		alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt3 ), "Wrong cryptogram" );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt4 ), "Wrong cryptogram" );

		alg.process( zeroes );

		alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt7 ), "Wrong cryptogram" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void test2( Salsa20 alg, String keyHex, String ivHex, String crypt0, String crypt1023, String crypt1024 )
	{
		Binary zeroes = Bin( 64 );
		Binary crypt;

		alg.setKey( keyHex );
		alg.startEncrypt( Bin( ivHex ) );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt0 ), "Wrong cryptogram" );
		
		for( int i = 1; i < 1023; ++i )
			alg.process( zeroes );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt1023 ), "Wrong cryptogram" );

		crypt = alg.process( zeroes );
		MUST( crypt.equals( crypt1024 ), "Wrong cryptogram" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	void skipTest()
	{
		Binary plain = Bin().random( 4000 );
		
		Salsa20 alg = new Salsa20();
		alg.setKey( "0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D" );

		Binary iv = Bin("0D74DB42A91077DE");

		alg.startEncrypt( iv );
		Binary crypt = alg.process( plain );

		alg.startEncrypt( iv );
		alg.skip( 10 );
		Binary cryptPart = alg.process( plain.slice( 10, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 10, 20 ) ), "Wrong skip" );

		alg.skip( 1000 );
		cryptPart = alg.process( plain.slice( 1030, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1030, 20 ) ), "Wrong skip" );

		alg.skip( -10 );
		cryptPart = alg.process( plain.slice( 1040, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1040, 20 ) ), "Wrong skip" );

		alg.skip( -1000 );
		MUST( alg.getPosition() == 60, "Wrong position" );

		cryptPart = alg.process( plain.slice( 60, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 60, 20 ) ), "Wrong skip" );

		long pos = alg.seekTo( 1010 );
		MUST( pos == 1010, "Wrong position" );

		cryptPart = alg.process( plain.slice( 1010, 20 ) );
		MUST( cryptPart.equals( crypt.slice( 1010, 20 ) ), "Wrong skip" );
	}
}
