// Denom.org
// bouncycastle.org

package org.denom.crypt.streamcipher;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

public class RC4 extends StreamCipher
{
	private byte[] state = new byte[ 256 ];
	private int x = 0;
	private int y = 0;

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * Set key later.
	 */
	public RC4()
	{
		this( Bin( 16 ) );
	}

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * @param key [16 bytes]
	 */
	public RC4( final Binary key )
	{
		setKey( key );
	}

	// -----------------------------------------------------------------------------------------------------------------
	@Override
	public String getAlgName()
	{
		return "RC4";
	}

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * @param 5 <= Key size <= 256 bytes.
	 */
	@Override
	public void setKey( final Binary key )
	{
		MUST( (key.size() >= 5) && (key.size() <= 256), "Wrong key size" );
		this.key = key.clone();
	}

	// -----------------------------------------------------------------------------------------------------------------
	private void init()
	{
		byte[] keyArr = key.getDataRef();
		int keyLen = key.size();

		x = 0;
		y = 0;

		for( int i = 0; i < state.length; i++ )
			state[ i ] = (byte)i;

		int i1 = 0;
		int i2 = 0;

		for( int i = 0; i < state.length; i++ )
		{
			i2 = ((keyArr[ i1 ] & 0xff) + state[ i ] + i2) & 0xff;

			byte tmp = state[ i ];
			state[ i ] = state[ i2 ];
			state[ i2 ] = tmp;
			i1 = (i1 + 1) % keyLen;
		}
	}

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * IV is not used for this algorithm.
	 */
	@Override
	public RC4 startEncrypt( final Binary iv )
	{
		init();
		return this;
	}

	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * IV is not used for this algorithm.
	 */
	@Override
	public RC4 startDecrypt( final Binary iv )
	{
		init();
		return this;
	}

	// -----------------------------------------------------------------------------------------------------------------
	@Override
	public byte process( byte in )
	{
		x = (x + 1) & 0xff;
		y = (state[ x ] + y) & 0xff;

		byte tmp = state[ x ];
		state[ x ] = state[ y ];
		state[ y ] = tmp;

		return (byte)(in ^ state[ (state[ x ] + state[ y ]) & 0xff ]);
	}

}
