// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.smartcard.cap.ComponentHeader.PackageInfo;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - Import.
 */
public class ComponentImport extends CapComponent
{
	public int tag;
	public int size;

	public PackageInfo[] packages;

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentImport( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_IMPORT, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		int count = b.get( offs++ );
		packages = new PackageInfo[ count ];
		for( int i = 0; i < packages.length; ++i )
		{
			packages[ i ] = new PackageInfo();
			offs = packages[ i ].parse( b, offs );
		}

		MUST( (tag == TAG_IMPORT) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component Import" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );

		b.add( packages.length );
		for( PackageInfo pkg : packages )
			pkg.toBin( b );

		return b;
	}

}
