// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - ReferenceLocation.
 */
public class ComponentRefLocation extends CapComponent
{
	public int tag;
	public int size;

	public Binary offsetsTo1ByteIndexes;
	public Binary offsetsTo2ByteIndexes;

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentRefLocation( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_REFLOCATION, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;

		int count = b.getU16( offs ); offs += 2;
		offsetsTo1ByteIndexes = b.slice( offs, count );
		offs += count;

		count = b.getU16( offs ); offs += 2;
		offsetsTo2ByteIndexes = b.slice( offs, count );
		offs += count;

		MUST( (tag == TAG_REFLOCATION) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component ReferenceLocation" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );

		b.addU16( offsetsTo1ByteIndexes.size() );
		b.add( offsetsTo1ByteIndexes );

		b.addU16( offsetsTo2ByteIndexes.size() );
		b.add( offsetsTo2ByteIndexes );

		return b;
	}

}
