/*
 * Decompiled with CFR 0.152.
 */
package org.denom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.denom.Ex;

public final class Binary
implements Comparable<Binary> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] mData;
    private int mSize;
    private Random rand;
    private SecureRandom randSecure;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Binary() {
        this.mData = new byte[0];
        this.mSize = 0;
    }

    public Binary(int size) {
        this.mData = new byte[size];
        this.mSize = size;
    }

    public Binary(int size, int value) {
        this.mData = new byte[size];
        this.mSize = size;
        if (value != 0) {
            Arrays.fill(this.mData, (byte)(value & 0xFF));
        }
    }

    public Binary(String hexStr) {
        this.mData = new byte[hexStr.length() >> 1];
        this.mSize = 0;
        this.add(hexStr);
    }

    public Binary(byte[] data) {
        this.mData = (byte[])data.clone();
        this.mSize = data.length;
    }

    public Binary(Binary bin) {
        this.mData = Arrays.copyOf(bin.mData, bin.size());
        this.mSize = this.mData.length;
    }

    public Binary(byte[] bin, int offset, int count) {
        Ex.MUST(offset >= 0 && count >= 0 && offset + count <= bin.length, "Out of borders");
        this.mData = Arrays.copyOfRange(bin, offset, offset + count);
        this.mSize = this.mData.length;
    }

    public byte[] getDataRef() {
        return this.mData;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.mData, this.mSize);
    }

    public void getBytes(int offset, int length, byte[] dest, int destOffset) {
        Ex.MUST(offset >= 0 && offset + length <= this.mSize, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0434\u043b\u044f Binary");
        Ex.MUST(destOffset >= 0 && destOffset + length <= dest.length, "\u0411\u0430\u0439\u0442\u043e\u0432\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043c\u0435\u043d\u044c\u0448\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u0433\u043e");
        System.arraycopy(this.mData, offset, dest, destOffset, length);
    }

    public void getBytes(byte[] dest, int destOffset) {
        Ex.MUST(destOffset >= 0 && destOffset + this.mSize <= dest.length, "\u0411\u0430\u0439\u0442\u043e\u0432\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043c\u0435\u043d\u044c\u0448\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u0433\u043e");
        System.arraycopy(this.mData, 0, dest, destOffset, this.mSize);
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        return this.Hex(1, 0, 0, 0);
    }

    public boolean empty() {
        return this.mSize == 0;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void clearMem() {
        this.mData = new byte[0];
        this.mSize = 0;
    }

    public Binary clone() {
        return new Binary(this.mData, 0, this.mSize);
    }

    public String Hex() {
        int size = this.mSize;
        if (size == 0) {
            return "";
        }
        char[] out = new char[size << 1];
        int j = 0;
        int i = 0;
        while (i < size) {
            byte b = this.mData[i];
            out[j++] = HEX_DIGITS[(0xF0 & b) >>> 4];
            out[j++] = HEX_DIGITS[b & 0xF];
            ++i;
        }
        return new String(out);
    }

    public String Hex(int oneSpace) {
        return this.Hex(oneSpace, 0, 0, 0);
    }

    public String Hex(int oneSpace, int twoSpaces, int newLine, int lineShift) {
        int size = this.mSize;
        if (size == 0) {
            return "";
        }
        int strlen = size << 1;
        strlen += oneSpace > 0 ? size / oneSpace : 0;
        strlen += twoSpaces > 0 ? size * 2 / twoSpaces : 0;
        strlen += newLine > 0 ? size / newLine : 0;
        strlen += lineShift;
        char[] out = new char[strlen += newLine > 0 ? size / newLine * lineShift : 0];
        int j = 0;
        int l = 0;
        while (l < lineShift) {
            out[j++] = 32;
            ++l;
        }
        byte b = this.mData[0];
        out[j++] = HEX_DIGITS[(0xF0 & b) >>> 4];
        out[j++] = HEX_DIGITS[b & 0xF];
        int s1 = 1;
        int s2 = 1;
        int newl = 1;
        int i = 1;
        while (i < size) {
            if (newLine == newl) {
                out[j++] = 10;
                int l2 = 0;
                while (l2 < lineShift) {
                    out[j++] = 32;
                    ++l2;
                }
                newl = 0;
                s2 = 0;
                s1 = 0;
            } else if (twoSpaces == s2) {
                out[j++] = 32;
                out[j++] = 32;
                s2 = 0;
                s1 = 0;
            } else if (oneSpace == s1) {
                out[j++] = 32;
                s1 = 0;
            }
            b = this.mData[i];
            out[j++] = HEX_DIGITS[(0xF0 & b) >>> 4];
            out[j++] = HEX_DIGITS[b & 0xF];
            ++s1;
            ++s2;
            ++newl;
            ++i;
        }
        return j == strlen ? new String(out) : new String(out, 0, j);
    }

    public void assign(byte[] other, int offset, int length) {
        if (this.mData.length >= length) {
            System.arraycopy(other, offset, this.mData, 0, length);
        } else {
            this.mData = Arrays.copyOfRange(other, offset, offset + length);
        }
        this.mSize = length;
    }

    public void assign(Binary other, int offset, int length) {
        this.assign(other.mData, offset, length);
    }

    public void assign(byte[] other) {
        this.assign(other, 0, other.length);
    }

    public void assign(Binary other) {
        this.assign(other.mData, 0, other.size());
    }

    public void assign(String otherHex) {
        this.mSize = 0;
        this.add(otherHex);
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.mData.length) {
            byte[] newData = new byte[newSize];
            System.arraycopy(this.mData, 0, newData, 0, this.mSize);
            this.mData = newData;
        }
    }

    private void ensureCapacityOptimal(int newSize) {
        if (newSize > this.mData.length) {
            this.ensureCapacity(Math.max(newSize, this.mData.length + (this.mData.length >>> 1) + 2));
        }
    }

    public Binary add(int b) {
        this.ensureCapacityOptimal(this.mSize + 1);
        this.mData[this.mSize] = (byte)(b & 0xFF);
        ++this.mSize;
        return this;
    }

    public Binary addU16(int i) {
        this.ensureCapacityOptimal(this.mSize + 2);
        this.mData[this.mSize++] = (byte)(i >>> 8);
        this.mData[this.mSize++] = (byte)(i & 0xFF);
        return this;
    }

    public Binary addU24(int i) {
        this.ensureCapacityOptimal(this.mSize + 3);
        this.mData[this.mSize++] = (byte)(i >>> 16);
        this.mData[this.mSize++] = (byte)(i >>> 8);
        this.mData[this.mSize++] = (byte)(i & 0xFF);
        return this;
    }

    public Binary addInt(int i) {
        int offset = this.mSize;
        this.ensureCapacityOptimal(this.mSize + 4);
        this.mData[offset++] = (byte)(i >>> 24);
        this.mData[offset++] = (byte)(i >>> 16);
        this.mData[offset++] = (byte)(i >>> 8);
        this.mData[offset] = (byte)(i & 0xFF);
        this.mSize += 4;
        return this;
    }

    public Binary addLong(long l) {
        int offset = this.mSize;
        this.ensureCapacityOptimal(this.mSize + 8);
        int i1 = (int)(l >>> 32);
        int i2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.mData[offset++] = (byte)(i1 >>> 24);
        this.mData[offset++] = (byte)(i1 >>> 16);
        this.mData[offset++] = (byte)(i1 >>> 8);
        this.mData[offset++] = (byte)(i1 & 0xFF);
        this.mData[offset++] = (byte)(i2 >>> 24);
        this.mData[offset++] = (byte)(i2 >>> 16);
        this.mData[offset++] = (byte)(i2 >>> 8);
        this.mData[offset] = (byte)(i2 & 0xFF);
        this.mSize += 8;
        return this;
    }

    public Binary addLongLE(long l) {
        int offset = this.mSize;
        this.ensureCapacityOptimal(this.mSize + 8);
        int hi = (int)(l >>> 32);
        int lo = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.mData[offset] = (byte)(lo & 0xFF);
        this.mData[offset + 1] = (byte)(lo >>> 8);
        this.mData[offset + 2] = (byte)(lo >>> 16);
        this.mData[offset + 3] = (byte)(lo >>> 24);
        this.mData[offset += 4] = (byte)(hi & 0xFF);
        this.mData[offset + 1] = (byte)(hi >>> 8);
        this.mData[offset + 2] = (byte)(hi >>> 16);
        this.mData[offset + 3] = (byte)(hi >>> 24);
        this.mSize += 8;
        return this;
    }

    public Binary add(byte[] data, int offset, int len) {
        this.ensureCapacityOptimal(this.mSize + len);
        System.arraycopy(data, offset, this.mData, this.mSize, len);
        this.mSize += len;
        return this;
    }

    public Binary add(byte[] data) {
        return this.add(data, 0, data.length);
    }

    public Binary add(Binary right) {
        return this.add(right.mData, 0, right.size());
    }

    public Binary add(Binary right, int offset, int len) {
        return this.add(right.mData, offset, len);
    }

    public Binary add(Binary ... bins) {
        Binary[] binaryArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            Binary b = binaryArray[n2];
            this.add(b);
            ++n2;
        }
        return this;
    }

    public Binary add(String hexStr) {
        char[] chars = hexStr.toCharArray();
        int charsLen = chars.length;
        this.ensureCapacity(this.mSize + (charsLen >> 1));
        int nibble = 0;
        int highNibble = 0;
        boolean flag = false;
        byte[] data = this.mData;
        int i = 0;
        while (i < charsLen) {
            char ch = chars[i];
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                if (ch >= '0' && ch <= '9') {
                    nibble = ch - 48;
                } else if (ch >= 'A' && ch <= 'F') {
                    nibble = ch - 65 + 10;
                } else if (ch >= 'a' && ch <= 'f') {
                    nibble = ch - 97 + 10;
                } else {
                    Ex.THROW("Wrong symbol in HEX-string");
                }
                if (flag) {
                    data[this.mSize++] = (byte)(highNibble | nibble);
                    flag = false;
                } else {
                    highNibble = nibble << 4;
                    flag = true;
                }
            }
            ++i;
        }
        Ex.MUST(!flag, "Odd number of HEX digits in HEX-string");
        return this;
    }

    public void fill(int b, int offset, int len) {
        Ex.MUST(offset + len <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        Arrays.fill(this.mData, offset, offset + len, (byte)(b & 0xFF));
    }

    public void fill(int b) {
        Arrays.fill(this.mData, 0, this.mSize, (byte)(b & 0xFF));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Binary) {
            return this.equals((Binary)obj);
        }
        return false;
    }

    public boolean equals(Binary right) {
        if (right == null) {
            return false;
        }
        return this.equals(right.getDataRef(), right.size());
    }

    public boolean equals(String hexStr) {
        if (hexStr == null) {
            return false;
        }
        return this.equals(new Binary(hexStr));
    }

    public boolean equals(byte[] data) {
        return this.equals(data, data.length);
    }

    private boolean equals(byte[] data, int len) {
        if (this.mData == data) {
            return true;
        }
        if (data == null) {
            return false;
        }
        if (this.size() != len) {
            return false;
        }
        byte[] this_data = this.mData;
        int i = 0;
        while (i < len) {
            if (this_data[i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        byte[] arr = this.mData;
        int size = this.mSize;
        int hash = 0;
        int i = 0;
        while (i < size) {
            hash = 31 * hash + arr[i];
            ++i;
        }
        return hash;
    }

    public Binary reserve(int capacity) {
        Ex.MUST(capacity >= 0, "\u0420\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c");
        this.ensureCapacity(capacity);
        return this;
    }

    public void resize(int newSize, int val) {
        Ex.MUST(newSize >= 0, "\u0420\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c");
        int oldSize = this.mSize;
        this.ensureCapacity(newSize);
        if (newSize > oldSize) {
            Arrays.fill(this.mData, oldSize, newSize, (byte)(val & 0xFF));
        }
        this.mSize = newSize;
    }

    public void resize(int newSize) {
        this.resize(newSize, 0);
    }

    public void setSize(int newSize) {
        Ex.MUST(newSize >= 0 && newSize <= this.mData.length, "Wrong size for Binary.setSize()");
        this.mSize = newSize;
    }

    public Binary reverse() {
        int left = 0;
        int right = this.mSize - 1;
        while (left < right) {
            byte temp = this.mData[left];
            this.mData[left] = this.mData[right];
            this.mData[right] = temp;
            ++left;
            --right;
        }
        return this;
    }

    public Binary slice(int offset, int partSize) {
        Ex.MUST(offset + partSize <= this.mSize, "Wrong 'offset' or 'partSize' in Binary.slice()");
        return new Binary(this.mData, offset, partSize);
    }

    public Binary first(int partSize) {
        Ex.MUST(partSize <= this.mSize, "Wrong 'partSize' in Binary.first()");
        return new Binary(this.mData, 0, partSize);
    }

    public Binary last(int partSize) {
        Ex.MUST(partSize <= this.mSize, "Wrong 'partSize' in Binary.last()");
        return new Binary(this.mData, this.mSize - partSize, partSize);
    }

    public Binary xor(Binary other) {
        int sz = this.size();
        Ex.MUST(other.size() >= sz, "Wrong array size");
        byte[] otherData = other.mData;
        int i = 0;
        while (i < sz) {
            int n = i;
            this.mData[n] = (byte)(this.mData[n] ^ otherData[i]);
            ++i;
        }
        return this;
    }

    public Binary or(Binary other) {
        int size = this.size();
        Ex.MUST(size == other.size(), "\u0414\u043b\u0438\u043d\u044b \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u0432 \u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 'or' \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u044b");
        byte[] otherData = other.mData;
        int i = 0;
        while (i < size) {
            int n = i;
            this.mData[n] = (byte)(this.mData[n] | otherData[i]);
            ++i;
        }
        return this;
    }

    public Binary and(Binary other) {
        int size = this.size();
        Ex.MUST(size == other.size(), "\u0414\u043b\u0438\u043d\u044b \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u0432 \u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 'and' \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u044b");
        byte[] otherData = other.mData;
        int i = 0;
        while (i < size) {
            int n = i;
            this.mData[n] = (byte)(this.mData[n] & otherData[i]);
            ++i;
        }
        return this;
    }

    public int getI(int index) {
        Ex.MUST(index < this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return this.mData[index];
    }

    public int get(int index) {
        Ex.MUST(index < this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return this.mData[index] & 0xFF;
    }

    public void set(int index, byte value) {
        Ex.MUST(index < this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[index] = value;
    }

    public void set(int index, int value) {
        Ex.MUST(index < this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[index] = (byte)(value & 0xFF);
    }

    public void set(int destOffset, byte[] data, int srcOffset, int len) {
        Ex.MUST(destOffset + len <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        System.arraycopy(data, srcOffset, this.mData, destOffset, len);
    }

    public void set(int destOffset, Binary data, int srcOffset, int len) {
        Ex.MUST(destOffset + len <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        Ex.MUST(srcOffset + len <= data.size(), "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        System.arraycopy(data.getDataRef(), srcOffset, this.mData, destOffset, len);
    }

    public void setU16(int offset, int value) {
        Ex.MUST(offset + 2 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[offset++] = (byte)(value >>> 8);
        this.mData[offset] = (byte)(value & 0xFF);
    }

    public void setU24(int offset, int value) {
        Ex.MUST(offset + 3 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[offset++] = (byte)(value >>> 16);
        this.mData[offset++] = (byte)(value >>> 8);
        this.mData[offset] = (byte)(value & 0xFF);
    }

    public int getU16(int offset) {
        Ex.MUST(offset + 2 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return (this.mData[offset] << 8 | this.mData[offset + 1] & 0xFF) & 0xFFFF;
    }

    public int getU24(int offset) {
        Ex.MUST(offset + 3 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return ((this.mData[offset] & 0xFF) << 16 | (this.mData[offset + 1] & 0xFF) << 8 | this.mData[offset + 2] & 0xFF) & 0xFFFFFF;
    }

    public long getU32(int offset) {
        return (long)this.getIntBE(offset) & 0xFFFFFFFFL;
    }

    public void setIntBE(int offset, int value) {
        Ex.MUST(offset + 4 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[offset] = (byte)(value >>> 24);
        this.mData[offset + 1] = (byte)(value >>> 16);
        this.mData[offset + 2] = (byte)(value >>> 8);
        this.mData[offset + 3] = (byte)(value & 0xFF);
    }

    public void setIntLE(int offset, int value) {
        Ex.MUST(offset + 4 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        this.mData[offset] = (byte)(value & 0xFF);
        this.mData[offset + 1] = (byte)(value >>> 8);
        this.mData[offset + 2] = (byte)(value >>> 16);
        this.mData[offset + 3] = (byte)(value >>> 24);
    }

    public void setLongBE(int offset, long l) {
        Ex.MUST(offset + 8 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        int i1 = (int)(l >>> 32);
        int i2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.mData[offset++] = (byte)(i1 >>> 24);
        this.mData[offset++] = (byte)(i1 >>> 16);
        this.mData[offset++] = (byte)(i1 >>> 8);
        this.mData[offset++] = (byte)(i1 & 0xFF);
        this.mData[offset++] = (byte)(i2 >>> 24);
        this.mData[offset++] = (byte)(i2 >>> 16);
        this.mData[offset++] = (byte)(i2 >>> 8);
        this.mData[offset] = (byte)(i2 & 0xFF);
    }

    public void setLongLE(int offset, long l) {
        Ex.MUST(offset + 8 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        int hi = (int)(l >>> 32);
        int lo = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.mData[offset] = (byte)(lo & 0xFF);
        this.mData[offset + 1] = (byte)(lo >>> 8);
        this.mData[offset + 2] = (byte)(lo >>> 16);
        this.mData[offset + 3] = (byte)(lo >>> 24);
        this.mData[offset += 4] = (byte)(hi & 0xFF);
        this.mData[offset + 1] = (byte)(hi >>> 8);
        this.mData[offset + 2] = (byte)(hi >>> 16);
        this.mData[offset + 3] = (byte)(hi >>> 24);
    }

    public int getIntBE(int offset) {
        Ex.MUST(offset + 4 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return this.mData[offset] << 24 | (this.mData[offset + 1] & 0xFF) << 16 | (this.mData[offset + 2] & 0xFF) << 8 | this.mData[offset + 3] & 0xFF;
    }

    public int getIntLE(int offset) {
        Ex.MUST(offset + 4 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        return this.mData[offset] & 0xFF | (this.mData[offset + 1] & 0xFF) << 8 | (this.mData[offset + 2] & 0xFF) << 16 | this.mData[offset + 3] << 24;
    }

    public long getLongBE(int offset) {
        Ex.MUST(offset + 8 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        int i1 = this.mData[offset++] << 24 | (this.mData[offset++] & 0xFF) << 16 | (this.mData[offset++] & 0xFF) << 8 | this.mData[offset++] & 0xFF;
        int i2 = this.mData[offset++] << 24 | (this.mData[offset++] & 0xFF) << 16 | (this.mData[offset++] & 0xFF) << 8 | this.mData[offset++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public long getLongLE(int offset) {
        Ex.MUST(offset + 8 <= this.mSize, "\u0412\u044b\u0445\u043e\u0434 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b Binary");
        int lo = this.mData[offset] & 0xFF | (this.mData[offset + 1] & 0xFF) << 8 | (this.mData[offset + 2] & 0xFF) << 16 | this.mData[offset + 3] << 24;
        int hi = this.mData[offset += 4] & 0xFF | (this.mData[offset + 1] & 0xFF) << 8 | (this.mData[offset + 2] & 0xFF) << 16 | this.mData[offset + 3] << 24;
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public int asU16() {
        switch (this.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.get(0);
            }
            case 2: {
                return this.getU16(0);
            }
        }
        Ex.MUST(false, "array size must be less or equal than number type size");
        return 0;
    }

    public long asNum() {
        Ex.MUST(this.mSize <= 8, "Binary too large");
        long num = 0L;
        int i = 0;
        while (i < this.mSize) {
            num <<= 8;
            num |= (long)(this.mData[i] & 0xFF);
            ++i;
        }
        return num;
    }

    public long asU32() {
        switch (this.size()) {
            case 0: 
            case 1: 
            case 2: {
                return this.asU16();
            }
            case 3: {
                return (this.mData[0] & 0xFF) << 16 | (this.mData[1] & 0xFF) << 8 | this.mData[2] & 0xFF;
            }
            case 4: {
                return (long)this.getIntBE(0) & 0xFFFFFFFFL;
            }
        }
        Ex.MUST(false, "array size must be less or equal than number type size");
        return 0L;
    }

    private void randomImpl(Random rnd, int size) {
        this.resize(size);
        int i = 0;
        while (i < size) {
            this.mData[i] = (byte)rnd.nextInt(256);
            ++i;
        }
    }

    public Binary random(int size) {
        if (this.rand == null) {
            this.rand = new Random(System.nanoTime());
        }
        this.randomImpl(this.rand, size);
        return this;
    }

    public Binary randomSecure(int size) {
        if (this.randSecure == null) {
            try {
                this.randSecure = new SecureRandom();
            }
            catch (Throwable ex) {
                Ex.THROW(ex);
            }
        }
        this.randomImpl(this.randSecure, size);
        return this;
    }

    public Binary random(Random rand, int size) {
        this.randomImpl(rand, size);
        return this;
    }

    public Binary increment() {
        if (this.empty()) {
            return this;
        }
        int i = this.size();
        do {
            this.set(--i, this.get(i) + 1);
        } while (i != 0 && this.get(i) == 0);
        return this;
    }

    public Binary decrement() {
        if (this.empty()) {
            return this;
        }
        int i = this.size();
        do {
            this.set(--i, this.get(i) - 1);
        } while (i != 0 && this.get(i) == 255);
        return this;
    }

    public Binary nibbleSwap() {
        int i = 0;
        while (i < this.mSize) {
            int b = this.mData[i] & 0xFF;
            this.mData[i] = (byte)(b >>> 4 | b << 4);
            ++i;
        }
        return this;
    }

    public boolean getBit(int index, int bitNum) {
        Ex.MUST(bitNum >= 0 && bitNum <= 7, "Wrong 'bitNum'");
        return (this.get(index) & 1 << bitNum) != 0;
    }

    public void writeBit(int index, int bitNum, boolean bitValue) {
        if (bitValue) {
            this.setBit(index, bitNum);
        } else {
            this.resetBit(index, bitNum);
        }
    }

    public void setBit(int index, int bitNum) {
        Ex.MUST(bitNum >= 0 && bitNum <= 7, "Wrong 'bitNum'");
        Ex.MUST(index < this.mSize, "Binary index out of bounds");
        int n = index;
        this.mData[n] = (byte)(this.mData[n] | 1 << bitNum);
    }

    public void resetBit(int index, int bitNum) {
        Ex.MUST(bitNum >= 0 && bitNum <= 7, "Wrong 'bitNum'");
        Ex.MUST(index < this.mSize, "Binary index out of bounds");
        int n = index;
        this.mData[n] = (byte)(this.mData[n] & ~(1 << bitNum));
    }

    public Binary fromString(String str, Charset charSet) {
        this.assign(str.getBytes(charSet));
        return this;
    }

    public Binary fromUTF8(String str) {
        this.assign(str.getBytes(UTF8));
        return this;
    }

    public String asString(Charset charSet) {
        return new String(this.mData, 0, this.size(), charSet);
    }

    public String asUTF8() {
        return new String(this.mData, 0, this.size(), UTF8);
    }

    public int indexOf(int b, int startFrom) {
        Ex.MUST(startFrom >= 0, "Binary: negative offset");
        int i = startFrom;
        while (i < this.mSize) {
            if (this.mData[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Binary subArray, int startFrom) {
        Ex.MUST(startFrom >= 0, "Binary: negative offset");
        int subSize = subArray.size();
        if (this.mSize < subSize) {
            return -1;
        }
        int endOffset = this.mSize - subSize;
        int offs = startFrom;
        while (offs <= endOffset) {
            block4: {
                int i = 0;
                while (i < subSize) {
                    if (this.mData[offs + i] == subArray.mData[i]) {
                        ++i;
                        continue;
                    }
                    break block4;
                }
                return offs;
            }
            ++offs;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Binary loadFromFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                try {
                    try (BufferedInputStream buf_in = new BufferedInputStream(fis);){
                        int size = buf_in.available();
                        Ex.MUST(size < Integer.MAX_VALUE, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430 int");
                        this.ensureCapacity(size);
                        buf_in.read(this.getDataRef());
                        this.mSize = size;
                    }
                    if (fis == null) return this;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return this;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Ex.THROW(e.toString());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveToFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                try {
                    try (BufferedOutputStream buf_out = new BufferedOutputStream(fos);){
                        buf_out.write(this.getDataRef(), 0, this.size());
                        buf_out.flush();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Ex.THROW(e.toString());
        }
    }

    @Override
    public int compareTo(Binary that) {
        int size = Math.min(this.mSize, that.mSize);
        int i = 0;
        while (i < size) {
            int cmp = Integer.compare(this.get(i), that.get(i));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return this.mSize - that.mSize;
    }

    public int contains(Binary subArray) {
        return this.contains(0, subArray);
    }

    public int contains(int startOffset, Binary subArray) {
        byte[] subArr = subArray.mData;
        int subLen = subArray.size();
        Ex.MUST(startOffset >= 0 && startOffset < this.mSize && subLen > 0 && subLen <= this.mSize, "Wrong subArray len");
        int end = this.mSize - subLen;
        int i = startOffset;
        while (i <= end) {
            block3: {
                int j = 0;
                while (j < subLen) {
                    if (this.mData[i + j] == subArr[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Binary Bin() {
        return new Binary();
    }

    public static Binary Bin(int size) {
        return new Binary(size);
    }

    public static Binary Bin(int size, int value) {
        return new Binary(size, value);
    }

    public static Binary Bin(byte[] data) {
        return new Binary(data);
    }

    public static Binary Bin(String hexStr) {
        return new Binary(hexStr);
    }

    public static Binary Bin(Binary ... bins) {
        Binary res = new Binary().reserve(100);
        Binary[] binaryArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            Binary b = binaryArray[n2];
            res.add(b);
            ++n2;
        }
        return res;
    }

    public static Binary xor(Binary left, Binary right) {
        return new Binary(left).xor(right);
    }

    public static Binary or(Binary left, Binary right) {
        return new Binary(left).or(right);
    }

    public static Binary and(Binary left, Binary right) {
        return new Binary(left).and(right);
    }

    public static Binary Num_Bin(long num, int minLen) {
        int bufSize = 8;
        byte[] buf = new byte[8];
        int len = 0;
        do {
            buf[8 - ++len] = (byte)(num & 0xFFL);
        } while ((num >>>= 8) != 0L);
        if (minLen <= len) {
            return new Binary(buf, 8 - len, len);
        }
        Binary b = new Binary(minLen, 0);
        System.arraycopy(buf, 8 - len, b.mData, minLen - len, len);
        return b;
    }

    public static <T> Binary getBinSafe(T key, Map<T, Binary> map) {
        Binary val = map.get(key);
        return val != null ? val : new Binary();
    }

    public static int getIntBE(byte[] arr, int offset) {
        return arr[offset] << 24 | (arr[offset + 1] & 0xFF) << 16 | (arr[offset + 2] & 0xFF) << 8 | arr[offset + 3] & 0xFF;
    }

    public static void setIntBE(byte[] arr, int offset, int value) {
        arr[offset] = (byte)(value >>> 24);
        arr[offset + 1] = (byte)(value >>> 16);
        arr[offset + 2] = (byte)(value >>> 8);
        arr[offset + 3] = (byte)(value & 0xFF);
    }

    public static int getIntLE(byte[] arr, int offset) {
        return arr[offset] & 0xFF | (arr[offset + 1] & 0xFF) << 8 | (arr[offset + 2] & 0xFF) << 16 | arr[offset + 3] << 24;
    }

    public static void setIntLE(byte[] arr, int offset, int value) {
        arr[offset] = (byte)(value & 0xFF);
        arr[offset + 1] = (byte)(value >>> 8);
        arr[offset + 2] = (byte)(value >>> 16);
        arr[offset + 3] = (byte)(value >>> 24);
    }

    public static long getLongBE(byte[] arr, int offset) {
        int i1 = arr[offset++] << 24 | (arr[offset++] & 0xFF) << 16 | (arr[offset++] & 0xFF) << 8 | arr[offset++] & 0xFF;
        int i2 = arr[offset++] << 24 | (arr[offset++] & 0xFF) << 16 | (arr[offset++] & 0xFF) << 8 | arr[offset++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public static void setLongBE(byte[] arr, int offset, long value) {
        int i1 = (int)(value >>> 32);
        int i2 = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        arr[offset++] = (byte)(i1 >>> 24);
        arr[offset++] = (byte)(i1 >>> 16);
        arr[offset++] = (byte)(i1 >>> 8);
        arr[offset++] = (byte)(i1 & 0xFF);
        arr[offset++] = (byte)(i2 >>> 24);
        arr[offset++] = (byte)(i2 >>> 16);
        arr[offset++] = (byte)(i2 >>> 8);
        arr[offset] = (byte)(i2 & 0xFF);
    }

    public static long getLongLE(byte[] arr, int offset) {
        int lo = arr[offset] & 0xFF | (arr[offset + 1] & 0xFF) << 8 | (arr[offset + 2] & 0xFF) << 16 | arr[offset + 3] << 24;
        int hi = arr[offset += 4] & 0xFF | (arr[offset + 1] & 0xFF) << 8 | (arr[offset + 2] & 0xFF) << 16 | arr[offset + 3] << 24;
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void setLongLE(byte[] arr, int offset, long value) {
        int hi = (int)(value >>> 32);
        int lo = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        arr[offset] = (byte)(lo & 0xFF);
        arr[offset + 1] = (byte)(lo >>> 8);
        arr[offset + 2] = (byte)(lo >>> 16);
        arr[offset + 3] = (byte)(lo >>> 24);
        arr[offset += 4] = (byte)(hi & 0xFF);
        arr[offset + 1] = (byte)(hi >>> 8);
        arr[offset + 2] = (byte)(hi >>> 16);
        arr[offset + 3] = (byte)(hi >>> 24);
    }
}

