/*
 * Decompiled with CFR 0.152.
 */
package org.denom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.denom.Ex;
import org.denom.log.ILog;

public final class Sys {
    private static Path tempDirJni = null;

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new Ex("Sleep interrupted");
        }
    }

    public static void shutdownNow(ExecutorService executor, int waitSeconds) {
        executor.shutdownNow();
        try {
            if (!executor.awaitTermination(waitSeconds, TimeUnit.SECONDS)) {
                throw new Ex("Can't stop executor " + executor.toString());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new Ex("Executor shutdownNow() interrupted!");
        }
    }

    public static int execAndWait(String cmdLine) {
        try {
            return new ProcessBuilder(cmdLine).start().waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Ex.THROW("Executing process with cmdLine '" + cmdLine + "' is interrupted");
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
        }
        return 0;
    }

    public static int execAndWait(String execFile, String ... cmdArgs) {
        ArrayList<String> args = new ArrayList<String>(cmdArgs.length + 1);
        args.add(execFile);
        String[] stringArray = cmdArgs;
        int n = cmdArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            args.add(arg);
            ++n2;
        }
        return Sys.execAndWait(args);
    }

    public static int execAndWait(List<String> cmdArgs) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs);
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            return processBuilder.start().waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Executing process with cmdLine '" + cmdArgs + "' is interrupted");
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int execAndWait(String cmdLine, String outputFile, String errorFile) {
        StringTokenizer st = new StringTokenizer(cmdLine.toString());
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdarray);
        processBuilder.redirectOutput(new File(outputFile));
        processBuilder.redirectError(new File(errorFile));
        try {
            Process p = processBuilder.start();
            return p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Ex.THROW("Executing process with cmdLine '" + cmdLine + "' is interrupted");
        }
        catch (Throwable ex) {
            Ex.THROW("Can't execute process with cmdLine: " + cmdLine + "\n" + ex.toString());
        }
        return -1;
    }

    public static int execAndWait(String cmdLine, ILog log) {
        Path outLog = Paths.get("output.log", new String[0]);
        Path errLog = Paths.get("error.log", new String[0]);
        int res = Sys.execAndWait(cmdLine, outLog.toString(), errLog.toString());
        try {
            Stream<String> stream;
            Object var6_9;
            Throwable throwable;
            if (Files.exists(outLog, new LinkOption[0])) {
                throwable = null;
                var6_9 = null;
                try {
                    stream = Files.lines(outLog);
                    try {
                        stream.forEach(line -> log.writeln((String)line));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (Files.exists(errLog, new LinkOption[0])) {
                throwable = null;
                var6_9 = null;
                try {
                    stream = Files.lines(errLog);
                    try {
                        stream.forEach(line -> log.writeln((String)line));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            Files.deleteIfExists(outLog);
            Files.deleteIfExists(errLog);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public static void renameFile(String oldName, String newName) {
        try {
            Files.move(Paths.get(oldName, new String[0]), Paths.get(newName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
    }

    public static boolean isFileExist(String fileName) {
        return Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0]);
    }

    public static void checkFileExist(String fileName) {
        Ex.MUST(Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0]), "File '" + fileName + "' not found");
    }

    public static void loadLibraryFromJar(String path) {
        try {
            if (tempDirJni == null) {
                String tempDir = System.getProperty("java.io.tmpdir");
                tempDirJni = Files.createDirectories(Paths.get(tempDir, "denom_jni_temp" + System.nanoTime()), new FileAttribute[0]);
                Ex.MUST(tempDirJni != null, "Can't create temp directory: " + tempDirJni.toString());
                tempDirJni.toFile().deleteOnExit();
            }
            Path tempFileName = Paths.get(tempDirJni.toString(), Paths.get(path, new String[0]).getFileName().toString());
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (InputStream is = ClassLoader.getSystemResourceAsStream(path);){
                    Files.copy(is, tempFileName, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                Files.deleteIfExists(tempFileName);
                Ex.THROW(ex.toString());
            }
            try {
                System.load(tempFileName.toAbsolutePath().toString());
            }
            finally {
                if (Sys.isPosixCompliant()) {
                    Files.deleteIfExists(tempFileName);
                } else {
                    tempFileName.toFile().deleteOnExit();
                }
            }
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    public static void deleteFile(String fileOrDir) {
        Sys.deleteFile(Paths.get(fileOrDir, new String[0]));
    }

    public static void deleteFile(Path fileOrDir) {
        try {
            if (Files.isDirectory(fileOrDir, new LinkOption[0])) {
                Files.walk(fileOrDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            } else {
                Files.deleteIfExists(fileOrDir);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

