/*
 * Decompiled with CFR 0.152.
 */
package org.denom;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryNamed
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final int stackSize;
    private final int priority;
    private final boolean isDaemon;

    public ThreadFactoryNamed(String groupName, int priority, int stackSize, boolean isDaemon) {
        this.group = new ThreadGroup(groupName);
        this.namePrefix = String.valueOf(groupName) + "-";
        this.stackSize = stackSize;
        this.priority = priority;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), this.stackSize);
        t.setPriority(this.priority);
        t.setDaemon(this.isDaemon);
        return t;
    }
}

