/*
 * Decompiled with CFR 0.152.
 */
package org.denom.build;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.denom.Arr;
import org.denom.Ex;
import org.denom.log.ILog;

public class JarBuilder
implements AutoCloseable {
    private final ILog log;
    private ZipOutputStream outputJar;
    private Arr<String> excludeList = new Arr();

    public JarBuilder(ILog log, String outputJarPath) {
        this.log = log;
        try {
            log.writeln("Creating JAR '" + outputJarPath + "'...");
            this.outputJar = new ZipOutputStream(new FileOutputStream(outputJarPath));
        }
        catch (FileNotFoundException ex) {
            Ex.THROW(ex.toString());
        }
    }

    @Override
    public void close() {
        try {
            this.outputJar.close();
            this.log.writeln("JAR created");
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    public void exclude(String fileName) {
        this.excludeList.add(fileName.toLowerCase());
    }

    public void exclude(String[] fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.excludeList.add(fileName.toLowerCase());
            ++n2;
        }
    }

    public void addDirectory(String inputDirPath) {
        this.log.write("  + Directory '" + inputDirPath + "' ... ");
        JarBuilder.addDirToZip(this.outputJar, inputDirPath, this.excludeList);
        this.log.writeln("OK");
    }

    public void addZip(String inputZipPath) {
        this.log.write("  + Zip '" + inputZipPath + "' ... ");
        JarBuilder.addZipToZip(this.outputJar, inputZipPath, this.excludeList);
        this.log.writeln("OK");
    }

    public void addManifest(String manifestStrings) {
        if (manifestStrings == null || manifestStrings.isEmpty()) {
            return;
        }
        this.log.write("  + Manifest ... ");
        try {
            this.outputJar.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            String manifest = "Manifest-Version: 1.0\n" + manifestStrings + "\n";
            this.outputJar.write(manifest.getBytes());
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
        }
        this.log.writeln("OK");
    }

    public void addManifest(Class<?> mainClass) {
        this.addManifest("Main-Class: " + mainClass.getCanonicalName());
    }

    private static boolean isExcluded(String fileName, Collection<String> excludeList) {
        int firstIndex;
        if (excludeList == null || excludeList.isEmpty()) {
            return false;
        }
        if (fileName.endsWith(".class") && (firstIndex = fileName.indexOf(36)) != -1) {
            fileName = String.valueOf(fileName.substring(0, firstIndex)) + ".class";
        }
        for (String excludeName : excludeList) {
            if (!fileName.toLowerCase().endsWith(excludeName)) continue;
            return true;
        }
        return false;
    }

    public static void addZipToZip(ZipOutputStream outputZip, String inputZip, Collection<String> excludeList) {
        byte[] buf = new byte[8192];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zip = new ZipFile(inputZip);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    int len;
                    ZipEntry entry = entries.nextElement();
                    if (JarBuilder.isExcluded(entry.getName(), excludeList)) continue;
                    outputZip.putNextEntry(new ZipEntry(entry.getName()));
                    InputStream in = zip.getInputStream(entry);
                    while ((len = in.read(buf)) > 0) {
                        outputZip.write(buf, 0, len);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Ex.THROW(ex);
        }
    }

    public static void addDirToZip(final ZipOutputStream outputZip, String inputDirPath, final Collection<String> excludeList) {
        Path dirPath = Paths.get(inputDirPath, new String[0]);
        Ex.MUST(Files.isDirectory(dirPath, new LinkOption[0]));
        final int baseFoldersCount = dirPath.getNameCount();
        try {
            Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String entryPath = file.subpath(baseFoldersCount, file.getNameCount()).toString();
                    String entryName = entryPath.replace('\\', '/');
                    if (JarBuilder.isExcluded(entryName, excludeList)) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        outputZip.putNextEntry(new ZipEntry(entryName));
                        Files.copy(file, outputZip);
                    }
                    catch (IOException e) {
                        Ex.THROW(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (JarBuilder.isExcluded(dir.toString().replace('\\', '/'), excludeList)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException ex) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
        }
    }
}

