/*
 * Decompiled with CFR 0.152.
 */
package org.denom.build;

import org.denom.Ex;
import org.denom.Sys;
import org.denom.log.ILog;

public class ProGuard {
    private final String proguardPath;
    private final String javaRuntimeJarPath;
    private final ILog log;

    public ProGuard(ILog log, String proguardJarPath, String javaRuntimeJarPath) {
        this.proguardPath = proguardJarPath;
        this.log = log;
        this.javaRuntimeJarPath = javaRuntimeJarPath;
    }

    public ProGuard(ILog log, String proguardJarPath) {
        this.proguardPath = proguardJarPath;
        this.log = log;
        this.javaRuntimeJarPath = String.valueOf(System.getenv("JAVA_HOME")) + "/jre/lib/rt.jar";
        Sys.checkFileExist(this.javaRuntimeJarPath);
    }

    public void obfuscateJar(String jarPath, String proguardParams, String[] externalJars) {
        StringBuilder sb = new StringBuilder(2048);
        sb.append(" -injars " + jarPath);
        sb.append(" -outjars temp.jar");
        sb.append(" -libraryjars " + this.javaRuntimeJarPath);
        if (externalJars != null) {
            String[] stringArray = externalJars;
            int n = externalJars.length;
            int n2 = 0;
            while (n2 < n) {
                String libJar = stringArray[n2];
                sb.append(';');
                sb.append(libJar);
                ++n2;
            }
        }
        sb.append(proguardParams);
        this.run(sb.toString());
        Sys.renameFile("temp.jar", jarPath);
    }

    public void run(String params) {
        StringBuilder cmdLine = new StringBuilder(2048);
        cmdLine.append("java -jar " + this.proguardPath);
        cmdLine.append(" ");
        cmdLine.append(params);
        this.log.writeln("Start ProGuard...");
        int res = Sys.execAndWait(cmdLine.toString(), this.log);
        Ex.MUST(res == 0, "ProGuard failed");
        this.log.writeln("OK");
    }

    public static String paramsApp() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(" -keepattributes Exceptions,InnerClasses,Signature,*Annotation*,EnclosingMethod");
        sb.append(" -keepclasseswithmembernames,includedescriptorclasses \"class * {native <methods>;}\"");
        sb.append(" -keepclassmembers \"class * extends java.lang.Enum { <fields>; public static **[] values(); public static ** valueOf(java.lang.String); }\"");
        sb.append(" -keepclasseswithmembers \"public class * {public static void main(java.lang.String[]);}\"");
        sb.append(" -repackageclasses");
        sb.append(" -allowaccessmodification");
        sb.append(" -forceprocessing");
        sb.append(" -dontnote org.denom.ecj.JavaCompilerECJ");
        sb.append(" -dontnote org.denom.format.BinParser");
        return sb.toString();
    }

    public static String paramsAppCleanOnly() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(" -keepattributes Exceptions,InnerClasses,Signature,*Annotation*,EnclosingMethod");
        sb.append(" -keepnames \"class *\"");
        sb.append(" -keepclasseswithmembernames,includedescriptorclasses \"class * {native <methods>;}\"");
        sb.append(" -keepclassmembers \"class * extends java.lang.Enum { <fields>; public static **[] values(); public static ** valueOf(java.lang.String); }\"");
        sb.append(" -keepclasseswithmembers \"public class * {public static void main(java.lang.String[]);}\"");
        sb.append(" -forceprocessing");
        sb.append(" -dontnote org.denom.ecj.JavaCompilerECJ");
        sb.append(" -dontnote org.denom.format.BinParser");
        return sb.toString();
    }

    public static String paramsServlet() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(" -keepattributes Exceptions,InnerClasses,Signature,*Annotation*,EnclosingMethod");
        sb.append(" -keepclasseswithmembernames,includedescriptorclasses \"class * {native <methods>;}\"");
        sb.append(" -keepclassmembers \"class * extends java.lang.Enum { <fields>; public static **[] values(); public static ** valueOf(java.lang.String); }\"");
        sb.append(" -keep,includedescriptorclasses \"public class * extends    javax.servlet.http.HttpServlet\"");
        sb.append(" -keep,includedescriptorclasses \"public class * implements javax.servlet.Filter\"");
        sb.append(" -repackageclasses");
        sb.append(" -allowaccessmodification");
        sb.append(" -forceprocessing");
        sb.append(" -dontnote org.denom.ecj.JavaCompilerECJ");
        String servletApiJar = String.valueOf(System.getenv("TOMCAT")) + "/lib/servlet-api.jar";
        Sys.checkFileExist(servletApiJar);
        sb.append(" -libraryjars " + servletApiJar);
        return sb.toString();
    }

    public static String paramsLib() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(" -keepattributes Exceptions,InnerClasses,Signature,*Annotation*,EnclosingMethod");
        sb.append(" -keepclasseswithmembernames,includedescriptorclasses \"class * {native <methods>;}\"");
        sb.append(" -keep,includedescriptorclasses \"public class * {public protected *;}\"");
        sb.append(" -dontoptimize");
        sb.append(" -forceprocessing");
        sb.append(" -dontnote org.denom.ecj.JavaCompilerECJ");
        sb.append(" -dontnote org.denom.format.BinParser");
        return sb.toString();
    }

    public static String paramsNop() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(" -dontshrink");
        sb.append(" -dontoptimize");
        sb.append(" -dontobfuscate");
        sb.append(" -dontpreverify");
        sb.append(" -forceprocessing");
        return sb.toString();
    }
}

