/*
 * Decompiled with CFR 0.152.
 */
package org.denom.build;

import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.build.JarBuilder;
import org.denom.build.ProGuard;
import org.denom.log.ILog;

public class WarBuilder {
    private final String proguardPath;
    private final ILog log;

    public WarBuilder(ILog log, String proguardPath) {
        this.log = log;
        this.proguardPath = proguardPath;
    }

    public void buildWar(String warPath, String webContentPath, String proguardParams, String[] inClassPaths, String[] externalJars) {
        Object jb;
        this.log.writeln("Creating WAR '" + warPath + "'...");
        String jarServlet = warPath.replace(".war", ".jar");
        if (inClassPaths != null) {
            jb = new JarBuilder(this.log, jarServlet);
            String[] stringArray = inClassPaths;
            int n = inClassPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String classPath = stringArray[n2];
                if (Files.isDirectory(Paths.get(classPath, new String[0]), new LinkOption[0])) {
                    ((JarBuilder)jb).addDirectory(classPath);
                } else {
                    ((JarBuilder)jb).addZip(classPath);
                }
                ++n2;
            }
            ((JarBuilder)jb).close();
            new ProGuard(this.log, this.proguardPath).obfuscateJar(jarServlet, proguardParams, externalJars);
        }
        try {
            jb = null;
            Object var8_16 = null;
            try (ZipOutputStream war = new ZipOutputStream(new FileOutputStream(warPath));){
                JarBuilder.addDirToZip(war, webContentPath, null);
                if (inClassPaths != null) {
                    war.putNextEntry(new ZipEntry("WEB-INF/lib/" + Paths.get(jarServlet, new String[0]).getFileName()));
                    war.write(new Binary().loadFromFile(jarServlet).getBytes());
                    Files.deleteIfExists(Paths.get(jarServlet, new String[0]));
                }
                if (externalJars != null) {
                    String[] stringArray = externalJars;
                    int n = externalJars.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String extJar = stringArray[n3];
                        Path p = Paths.get(extJar, new String[0]);
                        war.putNextEntry(new ZipEntry("WEB-INF/lib/" + p.getFileName()));
                        war.write(new Binary().loadFromFile(p.toString()).getBytes());
                        ++n3;
                    }
                }
            }
            catch (Throwable throwable) {
                if (jb == null) {
                    jb = throwable;
                } else if (jb != throwable) {
                    ((Throwable)jb).addSuppressed(throwable);
                }
                throw jb;
            }
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
        }
        this.log.writeln("WAR created");
    }
}

