/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.IHash;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.format.BinBuilder;
import org.denom.format.BinParser;
import org.denom.format.IBinable;
import org.denom.format.JSONObject;

public class RSA
implements IBinable,
Cloneable {
    private int NLen;
    private BigInteger N;
    private BigInteger E;
    private BigInteger D;
    private BigInteger P;
    private BigInteger Q;
    private BigInteger DP;
    private BigInteger DQ;
    private BigInteger QP;
    private SecureRandom randSecure;
    private static final Binary RSA_OID = new Binary("2A 86 48 86 F7 0D 01 01 01");

    public RSA() {
        this.clear();
    }

    public RSA(Binary n, Binary e) {
        this.setPublic(n, e);
    }

    public RSA(Binary n, Binary d, int dummy) {
        this.setPrivate(n, d);
    }

    public RSA(Binary n, Binary e, Binary d) {
        this.setNED(n, e, d);
    }

    public RSA(Binary p, Binary q, Binary dp, Binary dq, Binary qp) {
        this.clear();
        this.setPrivateCRT(p, q, dp, dq, qp);
    }

    public RSA clone() {
        RSA r = new RSA();
        r.NLen = this.NLen;
        r.N = new BigInteger(this.N.toByteArray());
        r.E = new BigInteger(this.E.toByteArray());
        r.D = new BigInteger(this.D.toByteArray());
        r.P = new BigInteger(this.P.toByteArray());
        r.Q = new BigInteger(this.Q.toByteArray());
        r.DP = new BigInteger(this.DP.toByteArray());
        r.DQ = new BigInteger(this.DQ.toByteArray());
        r.QP = new BigInteger(this.QP.toByteArray());
        return r;
    }

    public boolean isPublic() {
        return !this.E.equals(BigInteger.ZERO);
    }

    public boolean isPrivate() {
        return !this.D.equals(BigInteger.ZERO);
    }

    public boolean isPrivateCRT() {
        return !this.P.equals(BigInteger.ZERO);
    }

    public int getNLen() {
        return this.NLen;
    }

    public Binary getN() {
        return RSA.BigInt_Binary(this.N, 0);
    }

    public Binary getE() {
        return RSA.BigInt_Binary(this.E, 0);
    }

    public Binary getD() {
        return RSA.BigInt_Binary(this.D, this.NLen);
    }

    public Binary getP() {
        return RSA.BigInt_Binary(this.P, this.NLen >>> 1);
    }

    public Binary getQ() {
        return RSA.BigInt_Binary(this.Q, this.NLen >>> 1);
    }

    public Binary getDP() {
        return RSA.BigInt_Binary(this.DP, this.NLen >>> 1);
    }

    public Binary getDQ() {
        return RSA.BigInt_Binary(this.DQ, this.NLen >>> 1);
    }

    public Binary getQP() {
        return RSA.BigInt_Binary(this.QP, this.NLen >>> 1);
    }

    public void setPublic(Binary n, Binary e) {
        this.clear();
        this.N = RSA.Binary_BigInt(n);
        this.NLen = n.size();
        this.E = RSA.Binary_BigInt(e);
        Ex.MUST(!n.empty() && !e.empty() && this.checkNE(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 RSA");
    }

    public void setPrivate(Binary n, Binary d) {
        this.clear();
        Ex.MUST(!n.empty() && !d.empty(), "\u041f\u0443\u0441\u0442\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 RSA");
        this.N = RSA.Binary_BigInt(n);
        this.NLen = n.size();
        this.D = RSA.Binary_BigInt(d);
    }

    public void setNED(Binary n, Binary e, Binary d) {
        this.clear();
        this.N = RSA.Binary_BigInt(n);
        this.NLen = n.size();
        this.E = RSA.Binary_BigInt(e);
        this.D = RSA.Binary_BigInt(d);
        Ex.MUST(!n.empty() && !e.empty() && !d.empty() && this.checkNE(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 RSA");
    }

    public void setPrivateCRT(Binary p, Binary q, Binary dp, Binary dq, Binary qp) {
        this.clear();
        Ex.MUST(!p.empty() && !q.empty() && !dp.empty() && !dq.empty() && !qp.empty(), "\u041f\u0443\u0441\u0442\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 RSA");
        this.P = RSA.Binary_BigInt(p);
        this.Q = RSA.Binary_BigInt(q);
        this.DP = RSA.Binary_BigInt(dp);
        this.DQ = RSA.Binary_BigInt(dq);
        this.QP = RSA.Binary_BigInt(qp);
        Ex.MUST(!this.P.equals(BigInteger.ZERO) && !this.Q.equals(BigInteger.ZERO) && !this.DP.equals(BigInteger.ZERO) && !this.DQ.equals(BigInteger.ZERO) && !this.QP.equals(BigInteger.ZERO), "\u041d\u0443\u043b\u0438 \u0432 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u0445 \u043a\u043b\u044e\u0447\u0430 RSA");
        this.calcNED();
        Ex.MUST(this.checkPQ(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 RSA");
    }

    public void setPrivateKeyPKCS8(Binary data) {
        this.clear();
        BerTLVList l = new BerTLVList(data);
        Ex.MUST(l.find((String)"30/30/06").value.equals(RSA_OID), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043b\u044e\u0447\u0430");
        l.assign(l.find((String)"30/04").value);
        l.assign(l.find((String)"30").value);
        Ex.MUST(l.recs.size() >= 9, "RSA \u043a\u043b\u044e\u0447 \u043d\u0435 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 PKCS#8");
        this.N = new BigInteger(l.recs.get((int)1).value.getBytes());
        this.NLen = (this.N.bitLength() + 7) / 8;
        this.E = new BigInteger(l.recs.get((int)2).value.getBytes());
        this.D = new BigInteger(l.recs.get((int)3).value.getBytes());
        this.P = new BigInteger(l.recs.get((int)4).value.getBytes());
        this.Q = new BigInteger(l.recs.get((int)5).value.getBytes());
        this.DP = new BigInteger(l.recs.get((int)6).value.getBytes());
        this.DQ = new BigInteger(l.recs.get((int)7).value.getBytes());
        this.QP = new BigInteger(l.recs.get((int)8).value.getBytes());
        Ex.MUST(this.checkPQ(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 RSA");
    }

    public Binary getPrivateKeyPKCS8() {
        Ex.MUST(this.isPrivateCRT(), "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b");
        Binary key = BerTLV.Tlv(48, "" + BerTLV.Tlv(2, "00") + BerTLV.Tlv(2, Binary.Bin(this.N.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.E.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.D.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.P.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.Q.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.DP.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.DQ.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.QP.toByteArray())));
        Binary res = BerTLV.Tlv(48, "" + BerTLV.Tlv(2, "00") + BerTLV.Tlv(48, "" + BerTLV.Tlv(6, RSA_OID) + BerTLV.Tlv(5, "")) + BerTLV.Tlv(4, key));
        return res;
    }

    public void setPublicKeyX509(Binary data) {
        this.clear();
        BerTLVList l = new BerTLVList(data);
        Ex.MUST(l.find((String)"30/30/06").value.equals(RSA_OID), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043b\u044e\u0447\u0430");
        Binary bin = l.find((String)"30/03").value;
        Ex.MUST(bin.size() > 1, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043b\u044e\u0447\u0430");
        bin = bin.slice(1, bin.size() - 1);
        l.assign(bin);
        l.assign(l.find((String)"30").value);
        Ex.MUST(l.recs.size() >= 2, "RSA \u043a\u043b\u044e\u0447 \u043d\u0435 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 X.509");
        this.N = new BigInteger(l.recs.get((int)0).value.getBytes());
        this.NLen = (this.N.bitLength() + 7) / 8;
        this.E = new BigInteger(l.recs.get((int)1).value.getBytes());
        Ex.MUST(this.checkNE(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 RSA");
    }

    public Binary getPublicKeyX509() {
        Ex.MUST(this.isPublic(), "\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b");
        Binary key = BerTLV.Tlv(48, "" + BerTLV.Tlv(2, Binary.Bin(this.N.toByteArray())) + BerTLV.Tlv(2, Binary.Bin(this.E.toByteArray())));
        Binary res = BerTLV.Tlv(48, "" + BerTLV.Tlv(48, "" + BerTLV.Tlv(6, RSA_OID) + BerTLV.Tlv(5, "")) + BerTLV.Tlv(3, "00" + key));
        return res;
    }

    @Override
    public Binary toBin() {
        Binary emptyBin = Binary.Bin();
        BinBuilder bb = new BinBuilder();
        bb.append(this.NLen);
        if (this.isPrivateCRT()) {
            bb.append(this.getP());
            bb.append(this.getQ());
            bb.append(this.getDP());
            bb.append(this.getDQ());
            bb.append(this.getQP());
        } else {
            int i = 0;
            while (i < 5) {
                bb.append(emptyBin);
                ++i;
            }
        }
        bb.append(this.isPublic() ? this.getN() : emptyBin);
        bb.append(this.isPublic() ? RSA.BigInt_Binary(this.E, 4) : emptyBin);
        bb.append(this.isPrivate() ? this.getD() : emptyBin);
        return bb.getResult();
    }

    @Override
    public RSA fromBin(Binary bin, int offset) {
        BinParser parser = new BinParser(bin, offset);
        int len = parser.getInt();
        Ex.MUST(len >= 0 && len <= 65536, "Binarization: Wrong data for parsing as RSA object");
        this.NLen = len;
        int halfLen = this.NLen >> 1;
        Binary p = parser.getBinary(halfLen);
        Binary q = parser.getBinary(halfLen);
        Binary dp = parser.getBinary(halfLen);
        Binary dq = parser.getBinary(halfLen);
        Binary qp = parser.getBinary(halfLen);
        Binary n = parser.getBinary(this.NLen);
        Binary e = parser.getBinary(this.NLen);
        Binary d = parser.getBinary(this.NLen);
        if (!(p.empty() || q.empty() || dp.empty() || dq.empty() || qp.empty())) {
            this.setPrivateCRT(p, q, dp, dq, qp);
            return this;
        }
        if (!(n.empty() || d.empty() || e.empty())) {
            this.setNED(n, e, d);
            return this;
        }
        if (!n.empty() && !d.empty()) {
            this.setPrivate(n, d);
            return this;
        }
        if (!n.empty() && !e.empty()) {
            this.setPublic(n, e);
        }
        return this;
    }

    @Override
    public RSA fromBin(Binary bin) {
        return this.fromBin(bin, 0);
    }

    public JSONObject toJSON() {
        JSONObject jo = new JSONObject();
        if (this.isPrivateCRT()) {
            jo.put("P", this.getP().Hex());
            jo.put("Q", this.getQ().Hex());
            jo.put("DP", this.getDP().Hex());
            jo.put("DQ", this.getDQ().Hex());
            jo.put("QP", this.getQP().Hex());
        }
        if (this.isPrivate()) {
            jo.put("D", this.getD().Hex());
        }
        if (this.isPublic()) {
            jo.put("N", this.getN().Hex());
            jo.put("E", this.getE().Hex());
        }
        return jo;
    }

    public void fromJSON(JSONObject jo) {
        Binary p = Binary.Bin(jo.optString("P"));
        if (!p.empty()) {
            Binary q = Binary.Bin(jo.getString("Q"));
            Binary dp = Binary.Bin(jo.getString("DP"));
            Binary dq = Binary.Bin(jo.getString("DQ"));
            Binary qp = Binary.Bin(jo.getString("QP"));
            this.setPrivateCRT(p, q, dp, dq, qp);
        } else {
            Binary n = Binary.Bin(jo.optString("N"));
            Binary e = Binary.Bin(jo.optString("E"));
            Binary d = Binary.Bin(jo.optString("D"));
            if (!d.empty() && !e.empty()) {
                this.setNED(n, e, d);
            } else if (!d.empty()) {
                this.setPrivate(n, d);
            } else {
                this.setPublic(n, e);
            }
        }
    }

    public void fromJSON(String serialized) {
        this.fromJSON(new JSONObject(serialized));
    }

    public RSA generateKeyPair(int keyLenBits, Binary e) {
        this.clear();
        this.initSecureRandom();
        this.E = RSA.Binary_BigInt(e);
        BigInteger p1 = null;
        BigInteger q1 = null;
        BigInteger h = null;
        boolean good = false;
        do {
            this.P = BigInteger.probablePrime(keyLenBits + 1 >>> 1, this.randSecure);
            this.Q = BigInteger.probablePrime(keyLenBits + 1 >>> 1, this.randSecure);
            if (this.P.compareTo(this.Q) == -1) {
                BigInteger t = this.P;
                this.P = this.Q;
                this.Q = t;
            }
            if (this.P.compareTo(this.Q) == 0) continue;
            this.N = this.P.multiply(this.Q);
            if (this.N.bitLength() != keyLenBits) continue;
            p1 = this.P.subtract(BigInteger.ONE);
            h = p1.multiply(q1 = this.Q.subtract(BigInteger.ONE));
            boolean bl = good = this.E.gcd(h).compareTo(BigInteger.ONE) == 0;
        } while (!good);
        this.D = this.E.modInverse(h);
        this.DP = this.D.mod(p1);
        this.DQ = this.D.mod(q1);
        this.QP = this.Q.modInverse(this.P);
        this.NLen = keyLenBits >> 3;
        return this;
    }

    public Binary cryptPublic(Binary inputData) {
        Ex.MUST(this.isPublic(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        Ex.MUST(inputData.size() == this.NLen, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f RSA \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u043c\u043e\u0434\u0443\u043b\u044f (N)");
        BigInteger data = RSA.Binary_BigInt(inputData);
        Ex.MUST(data.compareTo(this.N) == -1, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f RSA \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u043e\u0434\u0443\u043b\u044f (N)");
        BigInteger res = data.modPow(this.E, this.N);
        return RSA.BigInt_Binary(res, this.NLen);
    }

    public Binary cryptPrivate(Binary inputData) {
        BigInteger res;
        Ex.MUST(this.isPrivate(), "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        Ex.MUST(inputData.size() == this.NLen, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f RSA \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u043c\u043e\u0434\u0443\u043b\u044f (N)");
        BigInteger data = RSA.Binary_BigInt(inputData);
        Ex.MUST(data.compareTo(this.N) == -1, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f RSA \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u043e\u0434\u0443\u043b\u044f (N)");
        if (this.P.equals(BigInteger.ZERO)) {
            res = data.modPow(this.D, this.N);
        } else {
            BigInteger T1 = data.modPow(this.DP, this.P);
            BigInteger T2 = data.modPow(this.DQ, this.Q);
            T1 = T1.subtract(T2).multiply(this.QP).mod(this.P);
            res = T1.multiply(this.Q).add(T2);
        }
        return RSA.BigInt_Binary(res, this.NLen);
    }

    public Binary encryptPublicPKCS1v1_5(Binary data) {
        Ex.MUST(this.isPublic(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        int k = this.getNLen();
        Ex.MUST(data.size() <= k - 11, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u044f RSA \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043a\u043e\u0440\u043e\u0447\u0435 \u041c\u043e\u0434\u0443\u043b\u044f (N) \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c \u043d\u0430 11 \u0431\u0430\u0439\u0442");
        this.initSecureRandom();
        Binary padded = Binary.Bin();
        padded.reserve(k);
        padded.add(0);
        padded.add(2);
        int r_size = k - data.size() - 3;
        int i = 0;
        while (i < r_size) {
            padded.add(this.randSecure.nextInt(255) + 1);
            ++i;
        }
        padded.add(0);
        padded.add(data);
        return this.cryptPublic(padded);
    }

    public Binary decryptPrivatePKCS1v1_5(Binary crypt) {
        Binary padded = this.cryptPrivate(crypt);
        Ex.MUST(padded.get(0) == 0 && padded.get(1) == 2, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430 RSA");
        int i = 2;
        while (i < padded.size() && padded.get(i) != 0) {
            ++i;
        }
        Ex.MUST(++i > 10 && i <= padded.size(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430 RSA");
        return padded.slice(i, padded.size() - i);
    }

    private static String getHashOID(int hashSize) {
        switch (hashSize) {
            case 16: {
                return "30 20 30 0c 06 08 2a 86 48 86 f7 0d 02 05 05 00 04 10";
            }
            case 20: {
                return "30 21 30 09 06 05 2b 0e 03 02 1a 05 00 04 14";
            }
            case 32: {
                return "30 31 30 0d 06 09 60 86 48 01 65 03 04 02 01 05 00 04 20";
            }
            case 48: {
                return "30 41 30 0d 06 09 60 86 48 01 65 03 04 02 02 05 00 04 30";
            }
            case 64: {
                return "30 51 30 0d 06 09 60 86 48 01 65 03 04 02 03 05 00 04 40";
            }
        }
        Ex.THROW("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0445\u0435\u0448\u0430");
        return "";
    }

    private Binary padHashPKCS1v1_5(Binary hash) {
        Ex.MUST(!hash.empty(), "\u041f\u0443\u0441\u0442\u043e\u0439 \u0445\u0435\u0448");
        int Nlen = this.getNLen();
        Binary T = Binary.Bin(String.valueOf(RSA.getHashOID(hash.size())) + hash);
        Ex.MUST(T.size() + 11 <= Nlen, "\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043b\u044e\u0447 \u0431\u043e\u043b\u044c\u0448\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430");
        Binary padded = Binary.Bin();
        padded.reserve(Nlen);
        padded.add(0);
        padded.add(1);
        padded.add(Binary.Bin(Nlen - T.size() - 3, 255));
        padded.add(0);
        padded.add(T);
        return padded;
    }

    public Binary calcSignPKCS1v1_5(Binary hash) {
        Ex.MUST(this.isPrivate(), "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        return this.cryptPrivate(this.padHashPKCS1v1_5(hash));
    }

    public boolean verifySignPKCS1v1_5(Binary hash, Binary sign) {
        Ex.MUST(this.isPublic(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        Ex.MUST(!hash.empty() && !sign.empty(), "\u041f\u0443\u0441\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
        return this.cryptPublic(sign).equals(this.padHashPKCS1v1_5(hash));
    }

    private static Binary MGF1(IHash h, Binary seed, int len) {
        Binary T = Binary.Bin();
        T.reserve(len);
        int i = 0;
        while (T.size() < len) {
            T.add(h.calc(Binary.Bin(seed, Binary.Num_Bin(i, 4))));
            ++i;
        }
        return T.slice(0, len);
    }

    public Binary encryptPublicOAEP(Binary data, IHash h, Binary label) {
        Ex.MUST(this.isPublic(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        if (label == null) {
            label = Binary.Bin();
        }
        int k = this.getNLen();
        int hLen = h.size();
        Ex.MUST(data.size() <= k - 2 * hLen - 2, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u044f RSA \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043a\u043e\u0440\u043e\u0447\u0435");
        Binary PS = Binary.Bin(k - data.size() - 2 * hLen - 2);
        Binary DB = h.calc(label).add(PS).add(1).add(data);
        Binary seed = Binary.Bin().random(hLen);
        Binary maskedDB = Binary.xor(DB, RSA.MGF1(h, seed, k - hLen - 1));
        Binary maskedSeed = Binary.xor(seed, RSA.MGF1(h, maskedDB, hLen));
        Binary EM = Binary.Bin("00").add(maskedSeed).add(maskedDB);
        return this.cryptPublic(EM);
    }

    public Binary decryptPrivateOAEP(Binary crypt, IHash h, Binary label) {
        Ex.MUST(this.isPrivate(), "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        if (label == null) {
            label = Binary.Bin();
        }
        int k = this.getNLen();
        int hLen = h.size();
        Binary EM = this.cryptPrivate(crypt);
        Ex.MUST(EM.get(0) == 0, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        Binary maskedSeed = EM.slice(1, hLen);
        Binary maskedDB = EM.slice(1 + hLen, EM.size() - 1 - hLen);
        Binary seed = Binary.xor(maskedSeed, RSA.MGF1(h, maskedDB, hLen));
        Binary DB = Binary.xor(maskedDB, RSA.MGF1(h, seed, k - hLen - 1));
        Ex.MUST(DB.slice(0, hLen).equals(h.calc(label)), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        int i = hLen;
        while (i < DB.size() && DB.get(i) == 0) {
            ++i;
        }
        Ex.MUST(DB.get(i) == 1, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        Ex.MUST(++i < DB.size(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430 RSA");
        return DB.slice(i, DB.size() - i);
    }

    public Binary calcSignPSS(Binary hash, IHash h) {
        int hLen;
        Ex.MUST(this.isPrivate(), "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        Ex.MUST(hash.size() == h.size(), "\u0420\u0430\u0437\u043c\u0435\u0440 \u0445\u0435\u0448\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0443 \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        int k = this.getNLen();
        int sLen = hLen = hash.size();
        Ex.MUST(k >= hLen + sLen + 2, "\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044b\u0432\u0430\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043b\u044e\u0447 \u0431\u043e\u043b\u044c\u0448\u0435\u0439 \u0434\u043b\u0438\u043d\u044b");
        Binary salt = Binary.Bin().random(sLen);
        Binary M_ = Binary.Bin(8).add(hash).add(salt);
        Binary H = h.calc(M_);
        Binary DB = Binary.Bin(k - sLen - hLen - 2).add(1).add(salt);
        Binary maskedDB = Binary.xor(DB, RSA.MGF1(h, H, k - hLen - 1));
        maskedDB.set(0, maskedDB.get(0) & 0x7F);
        Binary EM = maskedDB.add(H).add(188);
        return this.cryptPrivate(EM);
    }

    public boolean verifySignPSS(Binary hash, IHash h, Binary sign) {
        Ex.MUST(this.isPublic(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f RSA \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        Ex.MUST(!sign.empty(), "\u041f\u0443\u0441\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
        int k = this.getNLen();
        int hLen = hash.size();
        Ex.MUST(hLen == h.size(), "\u0420\u0430\u0437\u043c\u0435\u0440 \u0445\u0435\u0448\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0443 \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        Binary EM = this.cryptPublic(sign);
        if (EM.get(EM.size() - 1) != 188) {
            return false;
        }
        Binary maskedDB = EM.slice(0, k - hLen - 1);
        Binary H = EM.slice(k - hLen - 1, hLen);
        if (maskedDB.get(0) >= 128) {
            return false;
        }
        Binary DB = Binary.xor(maskedDB, RSA.MGF1(h, H, k - hLen - 1));
        DB.set(0, DB.get(0) & 0x7F);
        int i = 0;
        while (i < DB.size() && DB.get(i) == 0) {
            ++i;
        }
        if (DB.get(i) != 1) {
            return false;
        }
        Binary salt = DB.slice(++i, DB.size() - i);
        Binary M_ = Binary.Bin(8).add(hash).add(salt);
        Binary H_ = h.calc(M_);
        return H.equals(H_);
    }

    private boolean checkNE() {
        if (this.N.equals(BigInteger.ZERO) || this.E.equals(BigInteger.ZERO)) {
            return false;
        }
        if (!this.N.testBit(0) || !this.E.testBit(0)) {
            return false;
        }
        if (this.N.bitLength() < 128) {
            return false;
        }
        return this.E.bitLength() >= 2 && this.E.compareTo(this.N) == -1;
    }

    private void calcNED() {
        this.N = this.P.multiply(this.Q);
        this.NLen = (this.N.bitLength() + 7) / 8;
        BigInteger p1 = this.P.subtract(BigInteger.ONE);
        BigInteger q1 = this.Q.subtract(BigInteger.ONE);
        this.E = this.DP.modInverse(p1);
        BigInteger h = p1.multiply(q1);
        Ex.MUST(this.E.gcd(h).compareTo(BigInteger.ONE) == 0, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043a\u043b\u044e\u0447\u0430 RSA");
        this.D = this.E.modInverse(h);
    }

    private boolean checkPQ() {
        BigInteger q1;
        if (this.E.equals(BigInteger.ZERO) || this.P.equals(BigInteger.ZERO) || this.Q.equals(BigInteger.ZERO) || this.D.equals(BigInteger.ZERO)) {
            return false;
        }
        BigInteger pq = this.P.multiply(this.Q);
        if (!pq.equals(this.N)) {
            return false;
        }
        BigInteger p1 = this.P.subtract(BigInteger.ONE);
        BigInteger h = p1.multiply(q1 = this.Q.subtract(BigInteger.ONE));
        if (this.E.gcd(h).compareTo(BigInteger.ONE) != 0) {
            return false;
        }
        BigInteger dp = this.D.mod(p1);
        BigInteger dq = this.D.mod(q1);
        BigInteger qp = this.Q.modInverse(this.P);
        if (!(this.DP.equals(dp) && this.DQ.equals(dq) && this.QP.equals(qp))) {
            return false;
        }
        BigInteger g1 = p1.gcd(q1);
        BigInteger l1 = h.divide(g1);
        if (!h.remainder(g1).equals(BigInteger.ZERO)) {
            return false;
        }
        BigInteger de = this.D.multiply(this.E);
        BigInteger i = de.mod(l1);
        return i.equals(BigInteger.ONE);
    }

    private void clear() {
        this.NLen = 0;
        this.N = BigInteger.ZERO;
        this.E = BigInteger.ZERO;
        this.D = BigInteger.ZERO;
        this.P = BigInteger.ZERO;
        this.Q = BigInteger.ZERO;
        this.DP = BigInteger.ZERO;
        this.DQ = BigInteger.ZERO;
        this.QP = BigInteger.ZERO;
    }

    private static BigInteger Binary_BigInt(Binary bin) {
        Binary b = new Binary(bin.size() + 1);
        b.set(1, bin.getDataRef(), 0, bin.size());
        return new BigInteger(b.getDataRef());
    }

    private static Binary BigInt_Binary(BigInteger num, int minLen) {
        int size;
        byte[] arr = num.toByteArray();
        int offset = 0;
        if (arr.length > 1 && arr[0] == 0) {
            offset = 1;
        }
        Binary b = new Binary(minLen > (size = arr.length - offset) ? minLen : size);
        b.set(b.size() - size, arr, offset, size);
        return b;
    }

    private void initSecureRandom() {
        if (this.randSecure == null) {
            try {
                this.randSecure = new SecureRandom();
            }
            catch (Throwable ex) {
                Ex.THROW(ex);
            }
        }
    }
}

