/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class AES
extends BlockCipher {
    public static final int BLOCK_SIZE = 16;
    private static final byte[] Se = new byte[256];
    private static final int[] Te0 = new int[256];
    private static final int[] Te1 = new int[256];
    private static final int[] Te2 = new int[256];
    private static final int[] Te3 = new int[256];
    private static final byte[] Sd = new byte[256];
    private static final int[] Td0 = new int[256];
    private static final int[] Td1 = new int[256];
    private static final int[] Td2 = new int[256];
    private static final int[] Td3 = new int[256];
    private static final int[] rcon = new int[10];
    private int Nr;
    private int[] keyE;
    private int[] keyD;
    private static final byte[] SBOX;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        SBOX = byArray;
        int ROOT = 283;
        int i1 = 0;
        while (i1 < 256) {
            int t;
            int i8;
            int i4;
            int s1 = SBOX[i1] & 0xFF;
            int s2 = s1 << 1;
            if (s2 >= 256) {
                s2 ^= ROOT;
            }
            int s3 = s2 ^ s1;
            int i2 = i1 << 1;
            if (i2 >= 256) {
                i2 ^= ROOT;
            }
            if ((i4 = i2 << 1) >= 256) {
                i4 ^= ROOT;
            }
            if ((i8 = i4 << 1) >= 256) {
                i8 ^= ROOT;
            }
            int i9 = i8 ^ i1;
            int ib = i9 ^ i2;
            int id = i9 ^ i4;
            int ie = i8 ^ i4 ^ i2;
            AES.Se[i1] = (byte)s1;
            AES.Te0[i1] = t = s2 << 24 | s1 << 16 | s1 << 8 | s3;
            AES.Te1[i1] = t >>> 8 | t << 24;
            AES.Te2[i1] = t >>> 16 | t << 16;
            AES.Te3[i1] = t >>> 24 | t << 8;
            AES.Sd[s1] = (byte)i1;
            AES.Td0[s1] = t = ie << 24 | i9 << 16 | id << 8 | ib;
            AES.Td1[s1] = t >>> 8 | t << 24;
            AES.Td2[s1] = t >>> 16 | t << 16;
            AES.Td3[s1] = t >>> 24 | t << 8;
            ++i1;
        }
        int r = 1;
        AES.rcon[0] = r << 24;
        int i = 1;
        while (i < 10) {
            if ((r <<= 1) >= 256) {
                r ^= ROOT;
            }
            AES.rcon[i] = r << 24;
            ++i;
        }
    }

    public AES() {
        this(Binary.Bin(16));
    }

    public AES(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    public AES(String keyHex) {
        this(Binary.Bin(keyHex));
    }

    @Override
    public AES clone() {
        return new AES(this.key);
    }

    @Override
    public String getAlgName() {
        return "AES";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 24 || key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int Nk = key.size() >>> 2;
        this.Nr = Nk + 6;
        int Nw = 4 * (this.Nr + 1);
        this.keyE = new int[Nw];
        this.keyD = new int[Nw];
        int k = 0;
        int i = 0;
        while (i < Nk) {
            this.keyE[i] = key.getIntBE(k);
            k += 4;
            ++i;
        }
        int r = 0;
        int n = 0;
        int i2 = Nk;
        while (i2 < Nw) {
            int temp = this.keyE[i2 - 1];
            if (n == 0) {
                n = Nk;
                temp = Se[temp >>> 16 & 0xFF] << 24 | (Se[temp >>> 8 & 0xFF] & 0xFF) << 16 | (Se[temp & 0xFF] & 0xFF) << 8 | Se[temp >>> 24] & 0xFF;
                temp ^= rcon[r++];
            } else if (Nk == 8 && n == 4) {
                temp = Se[temp >>> 24] << 24 | (Se[temp >>> 16 & 0xFF] & 0xFF) << 16 | (Se[temp >>> 8 & 0xFF] & 0xFF) << 8 | Se[temp & 0xFF] & 0xFF;
            }
            this.keyE[i2] = this.keyE[i2 - Nk] ^ temp;
            --n;
            ++i2;
        }
        int d = 0;
        int e = 4 * this.Nr;
        this.keyD[d] = this.keyE[e];
        this.keyD[d + 1] = this.keyE[e + 1];
        this.keyD[d + 2] = this.keyE[e + 2];
        this.keyD[d + 3] = this.keyE[e + 3];
        d += 4;
        e -= 4;
        r = 1;
        while (r < this.Nr) {
            n = 0;
            while (n < 4) {
                int w = this.keyE[e + n];
                this.keyD[d + n] = Td0[Se[w >>> 24] & 0xFF] ^ Td1[Se[w >>> 16 & 0xFF] & 0xFF] ^ Td2[Se[w >>> 8 & 0xFF] & 0xFF] ^ Td3[Se[w & 0xFF] & 0xFF];
                ++n;
            }
            d += 4;
            e -= 4;
            ++r;
        }
        this.keyD[d] = this.keyE[e];
        this.keyD[d + 1] = this.keyE[e + 1];
        this.keyD[d + 2] = this.keyE[e + 2];
        this.keyD[d + 3] = this.keyE[e + 3];
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 16 || keySize == 24 || keySize == 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(16);
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int t0 = Binary.getIntBE(arr, 0) ^ this.keyE[0];
        int t1 = Binary.getIntBE(arr, 4) ^ this.keyE[1];
        int t2 = Binary.getIntBE(arr, 8) ^ this.keyE[2];
        int t3 = Binary.getIntBE(arr, 12) ^ this.keyE[3];
        int k = 0;
        int r = 1;
        while (r < this.Nr) {
            int a0 = Te0[t0 >>> 24] ^ Te1[t1 >>> 16 & 0xFF] ^ Te2[t2 >>> 8 & 0xFF] ^ Te3[t3 & 0xFF] ^ this.keyE[k += 4];
            int a1 = Te0[t1 >>> 24] ^ Te1[t2 >>> 16 & 0xFF] ^ Te2[t3 >>> 8 & 0xFF] ^ Te3[t0 & 0xFF] ^ this.keyE[k + 1];
            int a2 = Te0[t2 >>> 24] ^ Te1[t3 >>> 16 & 0xFF] ^ Te2[t0 >>> 8 & 0xFF] ^ Te3[t1 & 0xFF] ^ this.keyE[k + 2];
            int a3 = Te0[t3 >>> 24] ^ Te1[t0 >>> 16 & 0xFF] ^ Te2[t1 >>> 8 & 0xFF] ^ Te3[t2 & 0xFF] ^ this.keyE[k + 3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
            ++r;
        }
        int v = this.keyE[k += 4];
        arr[0] = (byte)(Se[t0 >>> 24] ^ v >>> 24);
        arr[1] = (byte)(Se[t1 >>> 16 & 0xFF] ^ v >>> 16);
        arr[2] = (byte)(Se[t2 >>> 8 & 0xFF] ^ v >>> 8);
        arr[3] = (byte)(Se[t3 & 0xFF] ^ v);
        v = this.keyE[k + 1];
        arr[4] = (byte)(Se[t1 >>> 24] ^ v >>> 24);
        arr[5] = (byte)(Se[t2 >>> 16 & 0xFF] ^ v >>> 16);
        arr[6] = (byte)(Se[t3 >>> 8 & 0xFF] ^ v >>> 8);
        arr[7] = (byte)(Se[t0 & 0xFF] ^ v);
        v = this.keyE[k + 2];
        arr[8] = (byte)(Se[t2 >>> 24] ^ v >>> 24);
        arr[9] = (byte)(Se[t3 >>> 16 & 0xFF] ^ v >>> 16);
        arr[10] = (byte)(Se[t0 >>> 8 & 0xFF] ^ v >>> 8);
        arr[11] = (byte)(Se[t1 & 0xFF] ^ v);
        v = this.keyE[k + 3];
        arr[12] = (byte)(Se[t3 >>> 24] ^ v >>> 24);
        arr[13] = (byte)(Se[t0 >>> 16 & 0xFF] ^ v >>> 16);
        arr[14] = (byte)(Se[t1 >>> 8 & 0xFF] ^ v >>> 8);
        arr[15] = (byte)(Se[t2 & 0xFF] ^ v);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int t0 = Binary.getIntBE(arr, 0) ^ this.keyD[0];
        int t1 = Binary.getIntBE(arr, 4) ^ this.keyD[1];
        int t2 = Binary.getIntBE(arr, 8) ^ this.keyD[2];
        int t3 = Binary.getIntBE(arr, 12) ^ this.keyD[3];
        int k = 0;
        int r = 1;
        while (r < this.Nr) {
            int a0 = Td0[t0 >>> 24] ^ Td1[t3 >>> 16 & 0xFF] ^ Td2[t2 >>> 8 & 0xFF] ^ Td3[t1 & 0xFF] ^ this.keyD[k += 4];
            int a1 = Td0[t1 >>> 24] ^ Td1[t0 >>> 16 & 0xFF] ^ Td2[t3 >>> 8 & 0xFF] ^ Td3[t2 & 0xFF] ^ this.keyD[k + 1];
            int a2 = Td0[t2 >>> 24] ^ Td1[t1 >>> 16 & 0xFF] ^ Td2[t0 >>> 8 & 0xFF] ^ Td3[t3 & 0xFF] ^ this.keyD[k + 2];
            int a3 = Td0[t3 >>> 24] ^ Td1[t2 >>> 16 & 0xFF] ^ Td2[t1 >>> 8 & 0xFF] ^ Td3[t0 & 0xFF] ^ this.keyD[k + 3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
            ++r;
        }
        int v = this.keyD[k += 4];
        byte[] block_arr = block.getDataRef();
        block_arr[0] = (byte)(Sd[t0 >>> 24] ^ v >>> 24);
        block_arr[1] = (byte)(Sd[t3 >>> 16 & 0xFF] ^ v >>> 16);
        block_arr[2] = (byte)(Sd[t2 >>> 8 & 0xFF] ^ v >>> 8);
        block_arr[3] = (byte)(Sd[t1 & 0xFF] ^ v);
        v = this.keyD[k + 1];
        block_arr[4] = (byte)(Sd[t1 >>> 24] ^ v >>> 24);
        block_arr[5] = (byte)(Sd[t0 >>> 16 & 0xFF] ^ v >>> 16);
        block_arr[6] = (byte)(Sd[t3 >>> 8 & 0xFF] ^ v >>> 8);
        block_arr[7] = (byte)(Sd[t2 & 0xFF] ^ v);
        v = this.keyD[k + 2];
        block_arr[8] = (byte)(Sd[t2 >>> 24] ^ v >>> 24);
        block_arr[9] = (byte)(Sd[t1 >>> 16 & 0xFF] ^ v >>> 16);
        block_arr[10] = (byte)(Sd[t0 >>> 8 & 0xFF] ^ v >>> 8);
        block_arr[11] = (byte)(Sd[t3 & 0xFF] ^ v);
        v = this.keyD[k + 3];
        block_arr[12] = (byte)(Sd[t3 >>> 24] ^ v >>> 24);
        block_arr[13] = (byte)(Sd[t2 >>> 16 & 0xFF] ^ v >>> 16);
        block_arr[14] = (byte)(Sd[t1 >>> 8 & 0xFF] ^ v >>> 8);
        block_arr[15] = (byte)(Sd[t0 & 0xFF] ^ v);
    }
}

