/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class ARIA
extends BlockCipher {
    public static final int BLOCK_SIZE = 16;
    private byte[][] roundKeysE;
    private byte[][] roundKeysD;
    private static final byte[][] C = new byte[][]{{81, 124, -63, -73, 39, 34, 10, -108, -2, 19, -85, -24, -6, -102, 110, -32}, {109, -79, 74, -52, -98, 33, -56, 32, -1, 40, -79, -43, -17, 93, -30, -80}, {-37, -110, 55, 29, 33, 38, -23, 112, 3, 36, -105, 117, 4, -24, -55, 14}};
    private static final byte[] SB1_sbox;
    private static final byte[] SB2_sbox;
    private static final byte[] SB3_sbox;
    private static final byte[] SB4_sbox;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        SB1_sbox = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = -30;
        byArray2[1] = 78;
        byArray2[2] = 84;
        byArray2[3] = -4;
        byArray2[4] = -108;
        byArray2[5] = -62;
        byArray2[6] = 74;
        byArray2[7] = -52;
        byArray2[8] = 98;
        byArray2[9] = 13;
        byArray2[10] = 106;
        byArray2[11] = 70;
        byArray2[12] = 60;
        byArray2[13] = 77;
        byArray2[14] = -117;
        byArray2[15] = -47;
        byArray2[16] = 94;
        byArray2[17] = -6;
        byArray2[18] = 100;
        byArray2[19] = -53;
        byArray2[20] = -76;
        byArray2[21] = -105;
        byArray2[22] = -66;
        byArray2[23] = 43;
        byArray2[24] = -68;
        byArray2[25] = 119;
        byArray2[26] = 46;
        byArray2[27] = 3;
        byArray2[28] = -45;
        byArray2[29] = 25;
        byArray2[30] = 89;
        byArray2[31] = -63;
        byArray2[32] = 29;
        byArray2[33] = 6;
        byArray2[34] = 65;
        byArray2[35] = 107;
        byArray2[36] = 85;
        byArray2[37] = -16;
        byArray2[38] = -103;
        byArray2[39] = 105;
        byArray2[40] = -22;
        byArray2[41] = -100;
        byArray2[42] = 24;
        byArray2[43] = -82;
        byArray2[44] = 99;
        byArray2[45] = -33;
        byArray2[46] = -25;
        byArray2[47] = -69;
        byArray2[49] = 115;
        byArray2[50] = 102;
        byArray2[51] = -5;
        byArray2[52] = -106;
        byArray2[53] = 76;
        byArray2[54] = -123;
        byArray2[55] = -28;
        byArray2[56] = 58;
        byArray2[57] = 9;
        byArray2[58] = 69;
        byArray2[59] = -86;
        byArray2[60] = 15;
        byArray2[61] = -18;
        byArray2[62] = 16;
        byArray2[63] = -21;
        byArray2[64] = 45;
        byArray2[65] = 127;
        byArray2[66] = -12;
        byArray2[67] = 41;
        byArray2[68] = -84;
        byArray2[69] = -49;
        byArray2[70] = -83;
        byArray2[71] = -111;
        byArray2[72] = -115;
        byArray2[73] = 120;
        byArray2[74] = -56;
        byArray2[75] = -107;
        byArray2[76] = -7;
        byArray2[77] = 47;
        byArray2[78] = -50;
        byArray2[79] = -51;
        byArray2[80] = 8;
        byArray2[81] = 122;
        byArray2[82] = -120;
        byArray2[83] = 56;
        byArray2[84] = 92;
        byArray2[85] = -125;
        byArray2[86] = 42;
        byArray2[87] = 40;
        byArray2[88] = 71;
        byArray2[89] = -37;
        byArray2[90] = -72;
        byArray2[91] = -57;
        byArray2[92] = -109;
        byArray2[93] = -92;
        byArray2[94] = 18;
        byArray2[95] = 83;
        byArray2[96] = -1;
        byArray2[97] = -121;
        byArray2[98] = 14;
        byArray2[99] = 49;
        byArray2[100] = 54;
        byArray2[101] = 33;
        byArray2[102] = 88;
        byArray2[103] = 72;
        byArray2[104] = 1;
        byArray2[105] = -114;
        byArray2[106] = 55;
        byArray2[107] = 116;
        byArray2[108] = 50;
        byArray2[109] = -54;
        byArray2[110] = -23;
        byArray2[111] = -79;
        byArray2[112] = -73;
        byArray2[113] = -85;
        byArray2[114] = 12;
        byArray2[115] = -41;
        byArray2[116] = -60;
        byArray2[117] = 86;
        byArray2[118] = 66;
        byArray2[119] = 38;
        byArray2[120] = 7;
        byArray2[121] = -104;
        byArray2[122] = 96;
        byArray2[123] = -39;
        byArray2[124] = -74;
        byArray2[125] = -71;
        byArray2[126] = 17;
        byArray2[127] = 64;
        byArray2[128] = -20;
        byArray2[129] = 32;
        byArray2[130] = -116;
        byArray2[131] = -67;
        byArray2[132] = -96;
        byArray2[133] = -55;
        byArray2[134] = -124;
        byArray2[135] = 4;
        byArray2[136] = 73;
        byArray2[137] = 35;
        byArray2[138] = -15;
        byArray2[139] = 79;
        byArray2[140] = 80;
        byArray2[141] = 31;
        byArray2[142] = 19;
        byArray2[143] = -36;
        byArray2[144] = -40;
        byArray2[145] = -64;
        byArray2[146] = -98;
        byArray2[147] = 87;
        byArray2[148] = -29;
        byArray2[149] = -61;
        byArray2[150] = 123;
        byArray2[151] = 101;
        byArray2[152] = 59;
        byArray2[153] = 2;
        byArray2[154] = -113;
        byArray2[155] = 62;
        byArray2[156] = -24;
        byArray2[157] = 37;
        byArray2[158] = -110;
        byArray2[159] = -27;
        byArray2[160] = 21;
        byArray2[161] = -35;
        byArray2[162] = -3;
        byArray2[163] = 23;
        byArray2[164] = -87;
        byArray2[165] = -65;
        byArray2[166] = -44;
        byArray2[167] = -102;
        byArray2[168] = 126;
        byArray2[169] = -59;
        byArray2[170] = 57;
        byArray2[171] = 103;
        byArray2[172] = -2;
        byArray2[173] = 118;
        byArray2[174] = -99;
        byArray2[175] = 67;
        byArray2[176] = -89;
        byArray2[177] = -31;
        byArray2[178] = -48;
        byArray2[179] = -11;
        byArray2[180] = 104;
        byArray2[181] = -14;
        byArray2[182] = 27;
        byArray2[183] = 52;
        byArray2[184] = 112;
        byArray2[185] = 5;
        byArray2[186] = -93;
        byArray2[187] = -118;
        byArray2[188] = -43;
        byArray2[189] = 121;
        byArray2[190] = -122;
        byArray2[191] = -88;
        byArray2[192] = 48;
        byArray2[193] = -58;
        byArray2[194] = 81;
        byArray2[195] = 75;
        byArray2[196] = 30;
        byArray2[197] = -90;
        byArray2[198] = 39;
        byArray2[199] = -10;
        byArray2[200] = 53;
        byArray2[201] = -46;
        byArray2[202] = 110;
        byArray2[203] = 36;
        byArray2[204] = 22;
        byArray2[205] = -126;
        byArray2[206] = 95;
        byArray2[207] = -38;
        byArray2[208] = -26;
        byArray2[209] = 117;
        byArray2[210] = -94;
        byArray2[211] = -17;
        byArray2[212] = 44;
        byArray2[213] = -78;
        byArray2[214] = 28;
        byArray2[215] = -97;
        byArray2[216] = 93;
        byArray2[217] = 111;
        byArray2[218] = -128;
        byArray2[219] = 10;
        byArray2[220] = 114;
        byArray2[221] = 68;
        byArray2[222] = -101;
        byArray2[223] = 108;
        byArray2[224] = -112;
        byArray2[225] = 11;
        byArray2[226] = 91;
        byArray2[227] = 51;
        byArray2[228] = 125;
        byArray2[229] = 90;
        byArray2[230] = 82;
        byArray2[231] = -13;
        byArray2[232] = 97;
        byArray2[233] = -95;
        byArray2[234] = -9;
        byArray2[235] = -80;
        byArray2[236] = -42;
        byArray2[237] = 63;
        byArray2[238] = 124;
        byArray2[239] = 109;
        byArray2[240] = -19;
        byArray2[241] = 20;
        byArray2[242] = -32;
        byArray2[243] = -91;
        byArray2[244] = 61;
        byArray2[245] = 34;
        byArray2[246] = -77;
        byArray2[247] = -8;
        byArray2[248] = -119;
        byArray2[249] = -34;
        byArray2[250] = 113;
        byArray2[251] = 26;
        byArray2[252] = -81;
        byArray2[253] = -70;
        byArray2[254] = -75;
        byArray2[255] = -127;
        SB2_sbox = byArray2;
        byte[] byArray3 = new byte[256];
        byArray3[0] = 82;
        byArray3[1] = 9;
        byArray3[2] = 106;
        byArray3[3] = -43;
        byArray3[4] = 48;
        byArray3[5] = 54;
        byArray3[6] = -91;
        byArray3[7] = 56;
        byArray3[8] = -65;
        byArray3[9] = 64;
        byArray3[10] = -93;
        byArray3[11] = -98;
        byArray3[12] = -127;
        byArray3[13] = -13;
        byArray3[14] = -41;
        byArray3[15] = -5;
        byArray3[16] = 124;
        byArray3[17] = -29;
        byArray3[18] = 57;
        byArray3[19] = -126;
        byArray3[20] = -101;
        byArray3[21] = 47;
        byArray3[22] = -1;
        byArray3[23] = -121;
        byArray3[24] = 52;
        byArray3[25] = -114;
        byArray3[26] = 67;
        byArray3[27] = 68;
        byArray3[28] = -60;
        byArray3[29] = -34;
        byArray3[30] = -23;
        byArray3[31] = -53;
        byArray3[32] = 84;
        byArray3[33] = 123;
        byArray3[34] = -108;
        byArray3[35] = 50;
        byArray3[36] = -90;
        byArray3[37] = -62;
        byArray3[38] = 35;
        byArray3[39] = 61;
        byArray3[40] = -18;
        byArray3[41] = 76;
        byArray3[42] = -107;
        byArray3[43] = 11;
        byArray3[44] = 66;
        byArray3[45] = -6;
        byArray3[46] = -61;
        byArray3[47] = 78;
        byArray3[48] = 8;
        byArray3[49] = 46;
        byArray3[50] = -95;
        byArray3[51] = 102;
        byArray3[52] = 40;
        byArray3[53] = -39;
        byArray3[54] = 36;
        byArray3[55] = -78;
        byArray3[56] = 118;
        byArray3[57] = 91;
        byArray3[58] = -94;
        byArray3[59] = 73;
        byArray3[60] = 109;
        byArray3[61] = -117;
        byArray3[62] = -47;
        byArray3[63] = 37;
        byArray3[64] = 114;
        byArray3[65] = -8;
        byArray3[66] = -10;
        byArray3[67] = 100;
        byArray3[68] = -122;
        byArray3[69] = 104;
        byArray3[70] = -104;
        byArray3[71] = 22;
        byArray3[72] = -44;
        byArray3[73] = -92;
        byArray3[74] = 92;
        byArray3[75] = -52;
        byArray3[76] = 93;
        byArray3[77] = 101;
        byArray3[78] = -74;
        byArray3[79] = -110;
        byArray3[80] = 108;
        byArray3[81] = 112;
        byArray3[82] = 72;
        byArray3[83] = 80;
        byArray3[84] = -3;
        byArray3[85] = -19;
        byArray3[86] = -71;
        byArray3[87] = -38;
        byArray3[88] = 94;
        byArray3[89] = 21;
        byArray3[90] = 70;
        byArray3[91] = 87;
        byArray3[92] = -89;
        byArray3[93] = -115;
        byArray3[94] = -99;
        byArray3[95] = -124;
        byArray3[96] = -112;
        byArray3[97] = -40;
        byArray3[98] = -85;
        byArray3[100] = -116;
        byArray3[101] = -68;
        byArray3[102] = -45;
        byArray3[103] = 10;
        byArray3[104] = -9;
        byArray3[105] = -28;
        byArray3[106] = 88;
        byArray3[107] = 5;
        byArray3[108] = -72;
        byArray3[109] = -77;
        byArray3[110] = 69;
        byArray3[111] = 6;
        byArray3[112] = -48;
        byArray3[113] = 44;
        byArray3[114] = 30;
        byArray3[115] = -113;
        byArray3[116] = -54;
        byArray3[117] = 63;
        byArray3[118] = 15;
        byArray3[119] = 2;
        byArray3[120] = -63;
        byArray3[121] = -81;
        byArray3[122] = -67;
        byArray3[123] = 3;
        byArray3[124] = 1;
        byArray3[125] = 19;
        byArray3[126] = -118;
        byArray3[127] = 107;
        byArray3[128] = 58;
        byArray3[129] = -111;
        byArray3[130] = 17;
        byArray3[131] = 65;
        byArray3[132] = 79;
        byArray3[133] = 103;
        byArray3[134] = -36;
        byArray3[135] = -22;
        byArray3[136] = -105;
        byArray3[137] = -14;
        byArray3[138] = -49;
        byArray3[139] = -50;
        byArray3[140] = -16;
        byArray3[141] = -76;
        byArray3[142] = -26;
        byArray3[143] = 115;
        byArray3[144] = -106;
        byArray3[145] = -84;
        byArray3[146] = 116;
        byArray3[147] = 34;
        byArray3[148] = -25;
        byArray3[149] = -83;
        byArray3[150] = 53;
        byArray3[151] = -123;
        byArray3[152] = -30;
        byArray3[153] = -7;
        byArray3[154] = 55;
        byArray3[155] = -24;
        byArray3[156] = 28;
        byArray3[157] = 117;
        byArray3[158] = -33;
        byArray3[159] = 110;
        byArray3[160] = 71;
        byArray3[161] = -15;
        byArray3[162] = 26;
        byArray3[163] = 113;
        byArray3[164] = 29;
        byArray3[165] = 41;
        byArray3[166] = -59;
        byArray3[167] = -119;
        byArray3[168] = 111;
        byArray3[169] = -73;
        byArray3[170] = 98;
        byArray3[171] = 14;
        byArray3[172] = -86;
        byArray3[173] = 24;
        byArray3[174] = -66;
        byArray3[175] = 27;
        byArray3[176] = -4;
        byArray3[177] = 86;
        byArray3[178] = 62;
        byArray3[179] = 75;
        byArray3[180] = -58;
        byArray3[181] = -46;
        byArray3[182] = 121;
        byArray3[183] = 32;
        byArray3[184] = -102;
        byArray3[185] = -37;
        byArray3[186] = -64;
        byArray3[187] = -2;
        byArray3[188] = 120;
        byArray3[189] = -51;
        byArray3[190] = 90;
        byArray3[191] = -12;
        byArray3[192] = 31;
        byArray3[193] = -35;
        byArray3[194] = -88;
        byArray3[195] = 51;
        byArray3[196] = -120;
        byArray3[197] = 7;
        byArray3[198] = -57;
        byArray3[199] = 49;
        byArray3[200] = -79;
        byArray3[201] = 18;
        byArray3[202] = 16;
        byArray3[203] = 89;
        byArray3[204] = 39;
        byArray3[205] = -128;
        byArray3[206] = -20;
        byArray3[207] = 95;
        byArray3[208] = 96;
        byArray3[209] = 81;
        byArray3[210] = 127;
        byArray3[211] = -87;
        byArray3[212] = 25;
        byArray3[213] = -75;
        byArray3[214] = 74;
        byArray3[215] = 13;
        byArray3[216] = 45;
        byArray3[217] = -27;
        byArray3[218] = 122;
        byArray3[219] = -97;
        byArray3[220] = -109;
        byArray3[221] = -55;
        byArray3[222] = -100;
        byArray3[223] = -17;
        byArray3[224] = -96;
        byArray3[225] = -32;
        byArray3[226] = 59;
        byArray3[227] = 77;
        byArray3[228] = -82;
        byArray3[229] = 42;
        byArray3[230] = -11;
        byArray3[231] = -80;
        byArray3[232] = -56;
        byArray3[233] = -21;
        byArray3[234] = -69;
        byArray3[235] = 60;
        byArray3[236] = -125;
        byArray3[237] = 83;
        byArray3[238] = -103;
        byArray3[239] = 97;
        byArray3[240] = 23;
        byArray3[241] = 43;
        byArray3[242] = 4;
        byArray3[243] = 126;
        byArray3[244] = -70;
        byArray3[245] = 119;
        byArray3[246] = -42;
        byArray3[247] = 38;
        byArray3[248] = -31;
        byArray3[249] = 105;
        byArray3[250] = 20;
        byArray3[251] = 99;
        byArray3[252] = 85;
        byArray3[253] = 33;
        byArray3[254] = 12;
        byArray3[255] = 125;
        SB3_sbox = byArray3;
        byte[] byArray4 = new byte[256];
        byArray4[0] = 48;
        byArray4[1] = 104;
        byArray4[2] = -103;
        byArray4[3] = 27;
        byArray4[4] = -121;
        byArray4[5] = -71;
        byArray4[6] = 33;
        byArray4[7] = 120;
        byArray4[8] = 80;
        byArray4[9] = 57;
        byArray4[10] = -37;
        byArray4[11] = -31;
        byArray4[12] = 114;
        byArray4[13] = 9;
        byArray4[14] = 98;
        byArray4[15] = 60;
        byArray4[16] = 62;
        byArray4[17] = 126;
        byArray4[18] = 94;
        byArray4[19] = -114;
        byArray4[20] = -15;
        byArray4[21] = -96;
        byArray4[22] = -52;
        byArray4[23] = -93;
        byArray4[24] = 42;
        byArray4[25] = 29;
        byArray4[26] = -5;
        byArray4[27] = -74;
        byArray4[28] = -42;
        byArray4[29] = 32;
        byArray4[30] = -60;
        byArray4[31] = -115;
        byArray4[32] = -127;
        byArray4[33] = 101;
        byArray4[34] = -11;
        byArray4[35] = -119;
        byArray4[36] = -53;
        byArray4[37] = -99;
        byArray4[38] = 119;
        byArray4[39] = -58;
        byArray4[40] = 87;
        byArray4[41] = 67;
        byArray4[42] = 86;
        byArray4[43] = 23;
        byArray4[44] = -44;
        byArray4[45] = 64;
        byArray4[46] = 26;
        byArray4[47] = 77;
        byArray4[48] = -64;
        byArray4[49] = 99;
        byArray4[50] = 108;
        byArray4[51] = -29;
        byArray4[52] = -73;
        byArray4[53] = -56;
        byArray4[54] = 100;
        byArray4[55] = 106;
        byArray4[56] = 83;
        byArray4[57] = -86;
        byArray4[58] = 56;
        byArray4[59] = -104;
        byArray4[60] = 12;
        byArray4[61] = -12;
        byArray4[62] = -101;
        byArray4[63] = -19;
        byArray4[64] = 127;
        byArray4[65] = 34;
        byArray4[66] = 118;
        byArray4[67] = -81;
        byArray4[68] = -35;
        byArray4[69] = 58;
        byArray4[70] = 11;
        byArray4[71] = 88;
        byArray4[72] = 103;
        byArray4[73] = -120;
        byArray4[74] = 6;
        byArray4[75] = -61;
        byArray4[76] = 53;
        byArray4[77] = 13;
        byArray4[78] = 1;
        byArray4[79] = -117;
        byArray4[80] = -116;
        byArray4[81] = -62;
        byArray4[82] = -26;
        byArray4[83] = 95;
        byArray4[84] = 2;
        byArray4[85] = 36;
        byArray4[86] = 117;
        byArray4[87] = -109;
        byArray4[88] = 102;
        byArray4[89] = 30;
        byArray4[90] = -27;
        byArray4[91] = -30;
        byArray4[92] = 84;
        byArray4[93] = -40;
        byArray4[94] = 16;
        byArray4[95] = -50;
        byArray4[96] = 122;
        byArray4[97] = -24;
        byArray4[98] = 8;
        byArray4[99] = 44;
        byArray4[100] = 18;
        byArray4[101] = -105;
        byArray4[102] = 50;
        byArray4[103] = -85;
        byArray4[104] = -76;
        byArray4[105] = 39;
        byArray4[106] = 10;
        byArray4[107] = 35;
        byArray4[108] = -33;
        byArray4[109] = -17;
        byArray4[110] = -54;
        byArray4[111] = -39;
        byArray4[112] = -72;
        byArray4[113] = -6;
        byArray4[114] = -36;
        byArray4[115] = 49;
        byArray4[116] = 107;
        byArray4[117] = -47;
        byArray4[118] = -83;
        byArray4[119] = 25;
        byArray4[120] = 73;
        byArray4[121] = -67;
        byArray4[122] = 81;
        byArray4[123] = -106;
        byArray4[124] = -18;
        byArray4[125] = -28;
        byArray4[126] = -88;
        byArray4[127] = 65;
        byArray4[128] = -38;
        byArray4[129] = -1;
        byArray4[130] = -51;
        byArray4[131] = 85;
        byArray4[132] = -122;
        byArray4[133] = 54;
        byArray4[134] = -66;
        byArray4[135] = 97;
        byArray4[136] = 82;
        byArray4[137] = -8;
        byArray4[138] = -69;
        byArray4[139] = 14;
        byArray4[140] = -126;
        byArray4[141] = 72;
        byArray4[142] = 105;
        byArray4[143] = -102;
        byArray4[144] = -32;
        byArray4[145] = 71;
        byArray4[146] = -98;
        byArray4[147] = 92;
        byArray4[148] = 4;
        byArray4[149] = 75;
        byArray4[150] = 52;
        byArray4[151] = 21;
        byArray4[152] = 121;
        byArray4[153] = 38;
        byArray4[154] = -89;
        byArray4[155] = -34;
        byArray4[156] = 41;
        byArray4[157] = -82;
        byArray4[158] = -110;
        byArray4[159] = -41;
        byArray4[160] = -124;
        byArray4[161] = -23;
        byArray4[162] = -46;
        byArray4[163] = -70;
        byArray4[164] = 93;
        byArray4[165] = -13;
        byArray4[166] = -59;
        byArray4[167] = -80;
        byArray4[168] = -65;
        byArray4[169] = -92;
        byArray4[170] = 59;
        byArray4[171] = 113;
        byArray4[172] = 68;
        byArray4[173] = 70;
        byArray4[174] = 43;
        byArray4[175] = -4;
        byArray4[176] = -21;
        byArray4[177] = 111;
        byArray4[178] = -43;
        byArray4[179] = -10;
        byArray4[180] = 20;
        byArray4[181] = -2;
        byArray4[182] = 124;
        byArray4[183] = 112;
        byArray4[184] = 90;
        byArray4[185] = 125;
        byArray4[186] = -3;
        byArray4[187] = 47;
        byArray4[188] = 24;
        byArray4[189] = -125;
        byArray4[190] = 22;
        byArray4[191] = -91;
        byArray4[192] = -111;
        byArray4[193] = 31;
        byArray4[194] = 5;
        byArray4[195] = -107;
        byArray4[196] = 116;
        byArray4[197] = -87;
        byArray4[198] = -63;
        byArray4[199] = 91;
        byArray4[200] = 74;
        byArray4[201] = -123;
        byArray4[202] = 109;
        byArray4[203] = 19;
        byArray4[204] = 7;
        byArray4[205] = 79;
        byArray4[206] = 78;
        byArray4[207] = 69;
        byArray4[208] = -78;
        byArray4[209] = 15;
        byArray4[210] = -55;
        byArray4[211] = 28;
        byArray4[212] = -90;
        byArray4[213] = -68;
        byArray4[214] = -20;
        byArray4[215] = 115;
        byArray4[216] = -112;
        byArray4[217] = 123;
        byArray4[218] = -49;
        byArray4[219] = 89;
        byArray4[220] = -113;
        byArray4[221] = -95;
        byArray4[222] = -7;
        byArray4[223] = 45;
        byArray4[224] = -14;
        byArray4[225] = -79;
        byArray4[227] = -108;
        byArray4[228] = 55;
        byArray4[229] = -97;
        byArray4[230] = -48;
        byArray4[231] = 46;
        byArray4[232] = -100;
        byArray4[233] = 110;
        byArray4[234] = 40;
        byArray4[235] = 63;
        byArray4[236] = -128;
        byArray4[237] = -16;
        byArray4[238] = 61;
        byArray4[239] = -45;
        byArray4[240] = 37;
        byArray4[241] = -118;
        byArray4[242] = -75;
        byArray4[243] = -25;
        byArray4[244] = 66;
        byArray4[245] = -77;
        byArray4[246] = -57;
        byArray4[247] = -22;
        byArray4[248] = -9;
        byArray4[249] = 76;
        byArray4[250] = 17;
        byArray4[251] = 51;
        byArray4[252] = 3;
        byArray4[253] = -94;
        byArray4[254] = -84;
        byArray4[255] = 96;
        SB4_sbox = byArray4;
    }

    public ARIA() {
        this(Binary.Bin(16));
    }

    public ARIA(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public ARIA clone() {
        return new ARIA(this.key);
    }

    @Override
    public String getAlgName() {
        return "ARIA";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 24 || key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int keyLen = key.size();
        byte[] K = key.getDataRef();
        int keyLenIdx = (keyLen >>> 3) - 2;
        byte[] CK1 = C[keyLenIdx];
        byte[] CK2 = C[(keyLenIdx + 1) % 3];
        byte[] CK3 = C[(keyLenIdx + 2) % 3];
        byte[] KL = new byte[16];
        byte[] KR = new byte[16];
        System.arraycopy(K, 0, KL, 0, 16);
        System.arraycopy(K, 16, KR, 0, keyLen - 16);
        byte[] W0 = new byte[16];
        byte[] W1 = new byte[16];
        byte[] W2 = new byte[16];
        byte[] W3 = new byte[16];
        System.arraycopy(KL, 0, W0, 0, 16);
        System.arraycopy(W0, 0, W1, 0, 16);
        ARIA.FO(W1, CK1);
        ARIA.xor(W1, KR);
        System.arraycopy(W1, 0, W2, 0, 16);
        ARIA.FE(W2, CK2);
        ARIA.xor(W2, W0);
        System.arraycopy(W2, 0, W3, 0, 16);
        ARIA.FO(W3, CK3);
        ARIA.xor(W3, W1);
        int numRounds = 12 + keyLenIdx * 2;
        this.roundKeysE = new byte[numRounds + 1][16];
        this.roundKeysD = new byte[numRounds + 1][16];
        this.keyScheduleRound(this.roundKeysE[0], W0, W1, 19);
        this.keyScheduleRound(this.roundKeysE[1], W1, W2, 19);
        this.keyScheduleRound(this.roundKeysE[2], W2, W3, 19);
        this.keyScheduleRound(this.roundKeysE[3], W3, W0, 19);
        this.keyScheduleRound(this.roundKeysE[4], W0, W1, 31);
        this.keyScheduleRound(this.roundKeysE[5], W1, W2, 31);
        this.keyScheduleRound(this.roundKeysE[6], W2, W3, 31);
        this.keyScheduleRound(this.roundKeysE[7], W3, W0, 31);
        this.keyScheduleRound(this.roundKeysE[8], W0, W1, 67);
        this.keyScheduleRound(this.roundKeysE[9], W1, W2, 67);
        this.keyScheduleRound(this.roundKeysE[10], W2, W3, 67);
        this.keyScheduleRound(this.roundKeysE[11], W3, W0, 67);
        this.keyScheduleRound(this.roundKeysE[12], W0, W1, 97);
        if (numRounds > 12) {
            this.keyScheduleRound(this.roundKeysE[13], W1, W2, 97);
            this.keyScheduleRound(this.roundKeysE[14], W2, W3, 97);
            if (numRounds > 14) {
                this.keyScheduleRound(this.roundKeysE[15], W3, W0, 97);
                this.keyScheduleRound(this.roundKeysE[16], W0, W1, 109);
            }
        }
        int i = 0;
        while (i < this.roundKeysD.length) {
            System.arraycopy(this.roundKeysE[i], 0, this.roundKeysD[i], 0, this.roundKeysE[i].length);
            ++i;
        }
        ARIA.reverseKeys(this.roundKeysD);
        i = 1;
        while (i < numRounds) {
            ARIA.A(this.roundKeysD[i]);
            ++i;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 16 || keySize == 24 || keySize == 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(16);
    }

    private void processBlock(byte[][] roundKeys, Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        byte[] z = block.getDataRef();
        int i = 0;
        int rounds = roundKeys.length - 3;
        while (i < rounds) {
            ARIA.FO(z, roundKeys[i++]);
            ARIA.FE(z, roundKeys[i++]);
        }
        ARIA.FO(z, roundKeys[i++]);
        ARIA.xor(z, roundKeys[i++]);
        ARIA.SL2(z);
        ARIA.xor(z, roundKeys[i]);
    }

    @Override
    public void encryptBlock(Binary block) {
        this.processBlock(this.roundKeysE, block);
    }

    @Override
    public void decryptBlock(Binary block) {
        this.processBlock(this.roundKeysD, block);
    }

    private static void A(byte[] z) {
        byte x0 = z[0];
        byte x1 = z[1];
        byte x2 = z[2];
        byte x3 = z[3];
        byte x4 = z[4];
        byte x5 = z[5];
        byte x6 = z[6];
        byte x7 = z[7];
        byte x8 = z[8];
        byte x9 = z[9];
        byte x10 = z[10];
        byte x11 = z[11];
        byte x12 = z[12];
        byte x13 = z[13];
        byte x14 = z[14];
        byte x15 = z[15];
        z[0] = (byte)(x3 ^ x4 ^ x6 ^ x8 ^ x9 ^ x13 ^ x14);
        z[1] = (byte)(x2 ^ x5 ^ x7 ^ x8 ^ x9 ^ x12 ^ x15);
        z[2] = (byte)(x1 ^ x4 ^ x6 ^ x10 ^ x11 ^ x12 ^ x15);
        z[3] = (byte)(x0 ^ x5 ^ x7 ^ x10 ^ x11 ^ x13 ^ x14);
        z[4] = (byte)(x0 ^ x2 ^ x5 ^ x8 ^ x11 ^ x14 ^ x15);
        z[5] = (byte)(x1 ^ x3 ^ x4 ^ x9 ^ x10 ^ x14 ^ x15);
        z[6] = (byte)(x0 ^ x2 ^ x7 ^ x9 ^ x10 ^ x12 ^ x13);
        z[7] = (byte)(x1 ^ x3 ^ x6 ^ x8 ^ x11 ^ x12 ^ x13);
        z[8] = (byte)(x0 ^ x1 ^ x4 ^ x7 ^ x10 ^ x13 ^ x15);
        z[9] = (byte)(x0 ^ x1 ^ x5 ^ x6 ^ x11 ^ x12 ^ x14);
        z[10] = (byte)(x2 ^ x3 ^ x5 ^ x6 ^ x8 ^ x13 ^ x15);
        z[11] = (byte)(x2 ^ x3 ^ x4 ^ x7 ^ x9 ^ x12 ^ x14);
        z[12] = (byte)(x1 ^ x2 ^ x6 ^ x7 ^ x9 ^ x11 ^ x12);
        z[13] = (byte)(x0 ^ x3 ^ x6 ^ x7 ^ x8 ^ x10 ^ x13);
        z[14] = (byte)(x0 ^ x3 ^ x4 ^ x5 ^ x9 ^ x11 ^ x14);
        z[15] = (byte)(x1 ^ x2 ^ x4 ^ x5 ^ x8 ^ x10 ^ x15);
    }

    private static void FE(byte[] D, byte[] RK) {
        ARIA.xor(D, RK);
        ARIA.SL2(D);
        ARIA.A(D);
    }

    private static void FO(byte[] D, byte[] RK) {
        ARIA.xor(D, RK);
        ARIA.SL1(D);
        ARIA.A(D);
    }

    private void keyScheduleRound(byte[] rk, byte[] w, byte[] wr, int n) {
        int off = n >>> 3;
        int right = n & 7;
        int left = 8 - right;
        int hi = wr[15 - off] & 0xFF;
        int to = 0;
        while (to < 16) {
            int lo = wr[to - off & 0xF] & 0xFF;
            int b = hi << left | lo >>> right;
            rk[to] = (byte)(b ^= w[to] & 0xFF);
            hi = lo;
            ++to;
        }
    }

    private static void reverseKeys(byte[][] keys) {
        int length = keys.length;
        int limit = length / 2;
        int last = length - 1;
        int i = 0;
        while (i < limit) {
            byte[] t = keys[i];
            keys[i] = keys[last - i];
            keys[last - i] = t;
            ++i;
        }
    }

    private static byte SB1(byte x) {
        return SB1_sbox[x & 0xFF];
    }

    private static byte SB2(byte x) {
        return SB2_sbox[x & 0xFF];
    }

    private static byte SB3(byte x) {
        return SB3_sbox[x & 0xFF];
    }

    private static byte SB4(byte x) {
        return SB4_sbox[x & 0xFF];
    }

    private static void SL1(byte[] z) {
        z[0] = ARIA.SB1(z[0]);
        z[1] = ARIA.SB2(z[1]);
        z[2] = ARIA.SB3(z[2]);
        z[3] = ARIA.SB4(z[3]);
        z[4] = ARIA.SB1(z[4]);
        z[5] = ARIA.SB2(z[5]);
        z[6] = ARIA.SB3(z[6]);
        z[7] = ARIA.SB4(z[7]);
        z[8] = ARIA.SB1(z[8]);
        z[9] = ARIA.SB2(z[9]);
        z[10] = ARIA.SB3(z[10]);
        z[11] = ARIA.SB4(z[11]);
        z[12] = ARIA.SB1(z[12]);
        z[13] = ARIA.SB2(z[13]);
        z[14] = ARIA.SB3(z[14]);
        z[15] = ARIA.SB4(z[15]);
    }

    private static void SL2(byte[] z) {
        z[0] = ARIA.SB3(z[0]);
        z[1] = ARIA.SB4(z[1]);
        z[2] = ARIA.SB1(z[2]);
        z[3] = ARIA.SB2(z[3]);
        z[4] = ARIA.SB3(z[4]);
        z[5] = ARIA.SB4(z[5]);
        z[6] = ARIA.SB1(z[6]);
        z[7] = ARIA.SB2(z[7]);
        z[8] = ARIA.SB3(z[8]);
        z[9] = ARIA.SB4(z[9]);
        z[10] = ARIA.SB1(z[10]);
        z[11] = ARIA.SB2(z[11]);
        z[12] = ARIA.SB3(z[12]);
        z[13] = ARIA.SB4(z[13]);
        z[14] = ARIA.SB1(z[14]);
        z[15] = ARIA.SB2(z[15]);
    }

    private static void xor(byte[] z, byte[] x) {
        int i = 0;
        while (i < 16) {
            int n = i;
            z[n] = (byte)(z[n] ^ x[i]);
            ++i;
        }
    }
}

