/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class GOST28147
extends BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 32;
    private final int[] wSBox0 = new int[256];
    private final int[] wSBox1 = new int[256];
    private final int[] wSBox2 = new int[256];
    private final int[] wSBox3 = new int[256];
    private int[] wKey = new int[8];

    public GOST28147(byte[] sBox) {
        this(sBox, Binary.Bin(32));
    }

    public GOST28147(byte[] sBox, Binary key) {
        super.initialize(8);
        this.setSBox(sBox);
        this.setKey(key);
    }

    public GOST28147 setSBox(byte[] sBox) {
        Ex.MUST(sBox.length == 128, "SBox must be 128 bytes");
        int i = 0;
        while (i < 256) {
            int iLo = i & 0xF;
            int iHi = i >> 4;
            this.wSBox0[i] = Integer.rotateLeft(sBox[16 + iHi] << 4 | sBox[0 + iLo], 11);
            this.wSBox1[i] = Integer.rotateLeft((sBox[48 + iHi] << 4 | sBox[32 + iLo]) << 8, 11);
            this.wSBox2[i] = Integer.rotateLeft((sBox[80 + iHi] << 4 | sBox[64 + iLo]) << 16, 11);
            this.wSBox3[i] = Integer.rotateLeft((sBox[112 + iHi] << 4 | sBox[96 + iLo]) << 24, 11);
            ++i;
        }
        return this;
    }

    @Override
    public GOST28147 clone() {
        GOST28147 nw = new GOST28147(new byte[128], this.key);
        System.arraycopy(this.wSBox0, 0, nw.wSBox0, 0, this.wSBox0.length);
        System.arraycopy(this.wSBox1, 0, nw.wSBox1, 0, this.wSBox1.length);
        System.arraycopy(this.wSBox2, 0, nw.wSBox2, 0, this.wSBox2.length);
        System.arraycopy(this.wSBox3, 0, nw.wSBox3, 0, this.wSBox3.length);
        return nw;
    }

    @Override
    public String getAlgName() {
        return "GOST28147-89";
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(32);
        this.setKey(k);
        return k;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int i = 0;
        while (i < 8) {
            this.wKey[i] = key.getIntLE(i << 2);
            ++i;
        }
    }

    private int gostStep(int cm) {
        return this.wSBox3[cm >> 24 & 0xFF] | this.wSBox2[cm >> 16 & 0xFF] | this.wSBox1[cm >> 8 & 0xFF] | this.wSBox0[cm & 0xFF];
    }

    @Override
    public void encryptBlock(Binary block) {
        int tmp;
        Ex.MUST(block.size() == 8, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int N1 = Binary.getIntLE(arr, 0);
        int N2 = Binary.getIntLE(arr, 4);
        int i = 0;
        while (i < 24) {
            tmp = N1;
            N1 = N2 ^ this.gostStep(N1 + this.wKey[i & 7]);
            N2 = tmp;
            ++i;
        }
        i = 7;
        while (i > 0) {
            tmp = N1;
            N1 = N2 ^ this.gostStep(N1 + this.wKey[i]);
            N2 = tmp;
            --i;
        }
        Binary.setIntLE(arr, 0, N1);
        Binary.setIntLE(arr, 4, N2 ^= this.gostStep(N1 + this.wKey[0]));
    }

    @Override
    public void decryptBlock(Binary block) {
        int tmp;
        Ex.MUST(block.size() == 8, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int N1 = Binary.getIntLE(arr, 0);
        int N2 = Binary.getIntLE(arr, 4);
        int i = 0;
        while (i < 8) {
            tmp = N1;
            N1 = N2 ^ this.gostStep(N1 + this.wKey[i]);
            N2 = tmp;
            ++i;
        }
        i = 31;
        while (i > 8) {
            tmp = N1;
            N1 = N2 ^ this.gostStep(N1 + this.wKey[i & 7]);
            N2 = tmp;
            --i;
        }
        Binary.setIntLE(arr, 0, N1);
        Binary.setIntLE(arr, 4, N2 ^= this.gostStep(N1 + this.wKey[0]));
    }

    public Binary calcMacGost(Binary data) {
        Ex.MUST(data.size() > 0, "Empty data for MAC");
        byte[] inArr = data.getDataRef();
        byte[] mac = new byte[8];
        int restLen = data.size();
        int offset = 0;
        while (restLen > 0) {
            int partSize = Math.min(8, restLen);
            int i = 0;
            while (i < partSize) {
                int n = i++;
                mac[n] = (byte)(mac[n] ^ inArr[offset++]);
            }
            restLen -= partSize;
            int N1 = Binary.getIntLE(mac, 0);
            int N2 = Binary.getIntLE(mac, 4);
            int i2 = 0;
            while (i2 < 16) {
                int tmp = N1;
                N1 = N2 ^ this.gostStep(N1 + this.wKey[i2 & 7]);
                N2 = tmp;
                ++i2;
            }
            Binary.setIntLE(mac, 0, N1);
            Binary.setIntLE(mac, 4, N2);
        }
        return new Binary(mac, 0, 4);
    }
}

