/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Magma
extends BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 32;
    private int key0;
    private int key1;
    private int key2;
    private int key3;
    private int key4;
    private int key5;
    private int key6;
    private int key7;
    private static final byte[] pi0;
    private static final byte[] pi1;
    private static final byte[] pi2;
    private static final byte[] pi3;
    private static final byte[] pi4;
    private static final byte[] pi5;
    private static final byte[] pi6;
    private static final byte[] pi7;
    private static final int[] pi76;
    private static final int[] pi54;
    private static final int[] pi32;
    private static final int[] pi10;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 12;
        byArray[1] = 4;
        byArray[2] = 6;
        byArray[3] = 2;
        byArray[4] = 10;
        byArray[5] = 5;
        byArray[6] = 11;
        byArray[7] = 9;
        byArray[8] = 14;
        byArray[9] = 8;
        byArray[10] = 13;
        byArray[11] = 7;
        byArray[13] = 3;
        byArray[14] = 15;
        byArray[15] = 1;
        pi0 = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 6;
        byArray2[1] = 8;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 9;
        byArray2[5] = 10;
        byArray2[6] = 5;
        byArray2[7] = 12;
        byArray2[8] = 1;
        byArray2[9] = 14;
        byArray2[10] = 4;
        byArray2[11] = 7;
        byArray2[12] = 11;
        byArray2[13] = 13;
        byArray2[15] = 15;
        pi1 = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 11;
        byArray3[1] = 3;
        byArray3[2] = 5;
        byArray3[3] = 8;
        byArray3[4] = 2;
        byArray3[5] = 15;
        byArray3[6] = 10;
        byArray3[7] = 13;
        byArray3[8] = 14;
        byArray3[9] = 1;
        byArray3[10] = 7;
        byArray3[11] = 4;
        byArray3[12] = 12;
        byArray3[13] = 9;
        byArray3[14] = 6;
        pi2 = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 12;
        byArray4[1] = 8;
        byArray4[2] = 2;
        byArray4[3] = 1;
        byArray4[4] = 13;
        byArray4[5] = 4;
        byArray4[6] = 15;
        byArray4[7] = 6;
        byArray4[8] = 7;
        byArray4[10] = 10;
        byArray4[11] = 5;
        byArray4[12] = 3;
        byArray4[13] = 14;
        byArray4[14] = 9;
        byArray4[15] = 11;
        pi3 = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 7;
        byArray5[1] = 15;
        byArray5[2] = 5;
        byArray5[3] = 10;
        byArray5[4] = 8;
        byArray5[5] = 1;
        byArray5[6] = 6;
        byArray5[7] = 13;
        byArray5[9] = 9;
        byArray5[10] = 3;
        byArray5[11] = 14;
        byArray5[12] = 11;
        byArray5[13] = 4;
        byArray5[14] = 2;
        byArray5[15] = 12;
        pi4 = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 5;
        byArray6[1] = 13;
        byArray6[2] = 15;
        byArray6[3] = 6;
        byArray6[4] = 9;
        byArray6[5] = 2;
        byArray6[6] = 12;
        byArray6[7] = 10;
        byArray6[8] = 11;
        byArray6[9] = 7;
        byArray6[10] = 8;
        byArray6[11] = 1;
        byArray6[12] = 4;
        byArray6[13] = 3;
        byArray6[14] = 14;
        pi5 = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[0] = 8;
        byArray7[1] = 14;
        byArray7[2] = 2;
        byArray7[3] = 5;
        byArray7[4] = 6;
        byArray7[5] = 9;
        byArray7[6] = 1;
        byArray7[7] = 12;
        byArray7[8] = 15;
        byArray7[9] = 4;
        byArray7[10] = 11;
        byArray7[12] = 13;
        byArray7[13] = 10;
        byArray7[14] = 3;
        byArray7[15] = 7;
        pi6 = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 1;
        byArray8[1] = 7;
        byArray8[2] = 14;
        byArray8[3] = 13;
        byArray8[5] = 5;
        byArray8[6] = 8;
        byArray8[7] = 3;
        byArray8[8] = 4;
        byArray8[9] = 15;
        byArray8[10] = 10;
        byArray8[11] = 6;
        byArray8[12] = 9;
        byArray8[13] = 12;
        byArray8[14] = 11;
        byArray8[15] = 2;
        pi7 = byArray8;
        pi76 = new int[256];
        pi54 = new int[256];
        pi32 = new int[256];
        pi10 = new int[256];
        int i = 0;
        while (i < 256) {
            int iLo = i & 0xF;
            int iHi = i >> 4;
            Magma.pi10[i] = Integer.rotateLeft(pi1[iHi] << 4 | pi0[iLo], 11);
            Magma.pi32[i] = Integer.rotateLeft((pi3[iHi] << 4 | pi2[iLo]) << 8, 11);
            Magma.pi54[i] = Integer.rotateLeft((pi5[iHi] << 4 | pi4[iLo]) << 16, 11);
            Magma.pi76[i] = Integer.rotateLeft((pi7[iHi] << 4 | pi6[iLo]) << 24, 11);
            ++i;
        }
    }

    public Magma() {
        this(Binary.Bin(32));
    }

    public Magma(Binary key) {
        super.initialize(8);
        this.setKey(key);
    }

    @Override
    public Magma clone() {
        return new Magma(this.key);
    }

    @Override
    public String getAlgName() {
        return "Magma";
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(32);
        this.setKey(k);
        return k;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Invalid key size");
        this.key = key.clone();
        byte[] k = key.getDataRef();
        this.key0 = Binary.getIntBE(k, 0);
        this.key1 = Binary.getIntBE(k, 4);
        this.key2 = Binary.getIntBE(k, 8);
        this.key3 = Binary.getIntBE(k, 12);
        this.key4 = Binary.getIntBE(k, 16);
        this.key5 = Binary.getIntBE(k, 20);
        this.key6 = Binary.getIntBE(k, 24);
        this.key7 = Binary.getIntBE(k, 28);
    }

    private static int g(int m) {
        return pi76[m >> 24 & 0xFF] | pi54[m >> 16 & 0xFF] | pi32[m >> 8 & 0xFF] | pi10[m & 0xFF];
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int n2 = Binary.getIntBE(arr, 0);
        int n1 = Binary.getIntBE(arr, 4);
        int i = 0;
        while (i < 3) {
            n2 ^= Magma.g(n1 + this.key0);
            n1 ^= Magma.g(n2 + this.key1);
            n2 ^= Magma.g(n1 + this.key2);
            n1 ^= Magma.g(n2 + this.key3);
            n2 ^= Magma.g(n1 + this.key4);
            n1 ^= Magma.g(n2 + this.key5);
            n2 ^= Magma.g(n1 + this.key6);
            n1 ^= Magma.g(n2 + this.key7);
            ++i;
        }
        n2 ^= Magma.g(n1 + this.key7);
        n1 ^= Magma.g(n2 + this.key6);
        n2 ^= Magma.g(n1 + this.key5);
        n1 ^= Magma.g(n2 + this.key4);
        n2 ^= Magma.g(n1 + this.key3);
        n1 ^= Magma.g(n2 + this.key2);
        n2 ^= Magma.g(n1 + this.key1);
        Binary.setIntBE(arr, 0, n1 ^= Magma.g(n2 + this.key0));
        Binary.setIntBE(arr, 4, n2);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int n2 = Binary.getIntBE(arr, 0);
        int n1 = Binary.getIntBE(arr, 4);
        n2 ^= Magma.g(n1 + this.key0);
        n1 ^= Magma.g(n2 + this.key1);
        n2 ^= Magma.g(n1 + this.key2);
        n1 ^= Magma.g(n2 + this.key3);
        n2 ^= Magma.g(n1 + this.key4);
        n1 ^= Magma.g(n2 + this.key5);
        n2 ^= Magma.g(n1 + this.key6);
        n1 ^= Magma.g(n2 + this.key7);
        int i = 0;
        while (i < 3) {
            n2 ^= Magma.g(n1 + this.key7);
            n1 ^= Magma.g(n2 + this.key6);
            n2 ^= Magma.g(n1 + this.key5);
            n1 ^= Magma.g(n2 + this.key4);
            n2 ^= Magma.g(n1 + this.key3);
            n1 ^= Magma.g(n2 + this.key2);
            n2 ^= Magma.g(n1 + this.key1);
            n1 ^= Magma.g(n2 + this.key0);
            ++i;
        }
        Binary.setIntBE(arr, 0, n1);
        Binary.setIntBE(arr, 4, n2);
    }
}

