/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class RC5_64
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final long P64 = -5196783011329398165L;
    private static final long Q64 = -7046029254386353131L;
    private int roundsNum;
    private long[] sKey;

    public RC5_64() {
        this(12, Binary.Bin(16));
    }

    public RC5_64(int roundsNumber) {
        this(roundsNumber, Binary.Bin(16));
    }

    public RC5_64(int roundsNumber, Binary key) {
        super.initialize(16);
        this.roundsNum = roundsNumber;
        this.sKey = new long[2 * (this.roundsNum + 1)];
        this.setKey(key);
    }

    @Override
    public RC5_64 clone() {
        return new RC5_64(this.roundsNum, this.key);
    }

    @Override
    public String getAlgName() {
        return "RC5-64";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 1 && key.size() <= 255, "Invalid key size");
        this.key = key.clone();
        long[] L = new long[(key.size() + 7) / 8];
        int i = 0;
        while (i != key.size()) {
            int n = i / 8;
            L[n] = L[n] + ((long)key.get(i) << 8 * (i % 8));
            ++i;
        }
        this.sKey[0] = -5196783011329398165L;
        i = 1;
        while (i < this.sKey.length) {
            this.sKey[i] = this.sKey[i - 1] + -7046029254386353131L;
            ++i;
        }
        int iter = L.length > this.sKey.length ? 3 * L.length : 3 * this.sKey.length;
        long A = 0L;
        long B = 0L;
        int i2 = 0;
        int j = 0;
        int k = 0;
        while (k < iter) {
            A = this.sKey[i2] = Long.rotateLeft(this.sKey[i2] + A + B, 3);
            B = L[j] = Long.rotateLeft(L[j] + A + B, (int)(A + B));
            i2 = (i2 + 1) % this.sKey.length;
            j = (j + 1) % L.length;
            ++k;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize >= 1 && keySize <= 255, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        long A = block.getLongLE(0) + this.sKey[0];
        long B = block.getLongLE(8) + this.sKey[1];
        int i = 1;
        while (i <= this.roundsNum) {
            A = Long.rotateLeft(A ^ B, (int)B) + this.sKey[2 * i];
            B = Long.rotateLeft(B ^ A, (int)A) + this.sKey[2 * i + 1];
            ++i;
        }
        block.setLongLE(0, A);
        block.setLongLE(8, B);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        long A = block.getLongLE(0);
        long B = block.getLongLE(8);
        int i = this.roundsNum;
        while (i >= 1) {
            B = Long.rotateRight(B - this.sKey[2 * i + 1], (int)A) ^ A;
            A = Long.rotateRight(A - this.sKey[2 * i], (int)B) ^ B;
            --i;
        }
        block.setLongLE(0, A - this.sKey[0]);
        block.setLongLE(8, B - this.sKey[1]);
    }
}

