/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.SerpentBase;

public final class Serpent
extends SerpentBase {
    public Serpent() {
        this(Binary.Bin(16));
    }

    public Serpent(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public Serpent clone() {
        return new Serpent(this.key);
    }

    @Override
    public String getAlgName() {
        return "Serpent";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 24 || key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int[] kPad = new int[16];
        int off = 0;
        int length = 0;
        off = 0;
        while (off + 4 < key.size()) {
            kPad[length++] = key.getIntLE(off);
            off += 4;
        }
        kPad[length++] = key.getIntLE(off);
        if (length < 8) {
            kPad[length] = 1;
        }
        int i = 8;
        while (i < 16) {
            kPad[i] = Integer.rotateLeft(kPad[i - 8] ^ kPad[i - 5] ^ kPad[i - 3] ^ kPad[i - 1] ^ 0x9E3779B9 ^ i - 8, 11);
            ++i;
        }
        System.arraycopy(kPad, 8, this.w, 0, 8);
        this.setKeyCommon();
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 16 || keySize == 24 || keySize == 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(16);
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        this.X0 = block.getIntLE(0);
        this.X1 = block.getIntLE(4);
        this.X2 = block.getIntLE(8);
        this.X3 = block.getIntLE(12);
        this.encryptBlockCommon();
        block.setIntLE(0, this.w[128] ^ this.X0);
        block.setIntLE(4, this.w[129] ^ this.X1);
        block.setIntLE(8, this.w[130] ^ this.X2);
        block.setIntLE(12, this.w[131] ^ this.X3);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        this.X0 = this.w[128] ^ block.getIntLE(0);
        this.X1 = this.w[129] ^ block.getIntLE(4);
        this.X2 = this.w[130] ^ block.getIntLE(8);
        this.X3 = this.w[131] ^ block.getIntLE(12);
        this.decryptBlockCommon();
        block.setIntLE(0, this.X0 ^ this.w[0]);
        block.setIntLE(4, this.X1 ^ this.w[1]);
        block.setIntLE(8, this.X2 ^ this.w[2]);
        block.setIntLE(12, this.X3 ^ this.w[3]);
    }
}

