/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Threefish512
extends BlockCipher {
    public static final int BLOCK_SIZE = 64;
    public static final int KEY_SIZE = 64;
    private static final int BLOCK_SIZE_WORDS = 8;
    private static final int ROUNDS_NUM = 72;
    private static int[] MOD3 = new int[72];
    private static int[] MOD9 = new int[72];
    private long[] tw = new long[5];
    private long[] kw = new long[17];

    static {
        int i = 0;
        while (i < MOD3.length) {
            Threefish512.MOD3[i] = i % 3;
            Threefish512.MOD9[i] = i % 9;
            ++i;
        }
    }

    public Threefish512() {
        this(Binary.Bin(64));
    }

    public Threefish512(Binary key) {
        super.initialize(64);
        this.setKey(Binary.Bin(64));
    }

    @Override
    public Threefish512 clone() {
        return new Threefish512(this.key);
    }

    @Override
    public String getAlgName() {
        return "Threefish-512";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 64, "Invalid key size");
        this.key = key.clone();
        byte[] arr = key.getDataRef();
        long knw = 2004413935125273122L;
        int i = 0;
        while (i < 8) {
            this.kw[i] = Binary.getLongLE(arr, i << 3);
            knw ^= this.kw[i];
            ++i;
        }
        this.kw[8] = knw;
        System.arraycopy(this.kw, 0, this.kw, 9, 8);
    }

    @Override
    public Binary generateKey() {
        Binary akey = new Binary().randomSecure(64);
        this.setKey(akey);
        return akey;
    }

    public void setTweak(Binary tweak) {
        Ex.MUST(tweak.size() == 16, "Incorrect tweak size");
        byte[] arr = tweak.getDataRef();
        this.tw[0] = Binary.getLongLE(arr, 0);
        this.tw[1] = Binary.getLongLE(arr, 8);
        this.tw[2] = this.tw[0] ^ this.tw[1];
        this.tw[3] = this.tw[0];
        this.tw[4] = this.tw[1];
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 64, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0) + this.kw[0];
        long b1 = Binary.getLongLE(arr, 8) + this.kw[1];
        long b2 = Binary.getLongLE(arr, 16) + this.kw[2];
        long b3 = Binary.getLongLE(arr, 24) + this.kw[3];
        long b4 = Binary.getLongLE(arr, 32) + this.kw[4];
        long b5 = Binary.getLongLE(arr, 40) + this.kw[5] + this.tw[0];
        long b6 = Binary.getLongLE(arr, 48) + this.kw[6] + this.tw[1];
        long b7 = Binary.getLongLE(arr, 56) + this.kw[7];
        int d = 1;
        while (d < 18) {
            int dm9 = MOD9[d];
            int dm3 = MOD3[d];
            b0 += b1;
            b1 = Long.rotateLeft(b1, 46) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 36) ^ b2;
            b4 += b5;
            b5 = Long.rotateLeft(b5, 19) ^ b4;
            b6 += b7;
            b7 = Long.rotateLeft(b7, 37) ^ b6;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 33) ^ b2;
            b4 += b7;
            b7 = Long.rotateLeft(b7, 27) ^ b4;
            b6 += b5;
            b5 = Long.rotateLeft(b5, 14) ^ b6;
            b0 += b3;
            b3 = Long.rotateLeft(b3, 42) ^ b0;
            b4 += b1;
            b1 = Long.rotateLeft(b1, 17) ^ b4;
            b6 += b3;
            b3 = Long.rotateLeft(b3, 49) ^ b6;
            b0 += b5;
            b5 = Long.rotateLeft(b5, 36) ^ b0;
            b2 += b7;
            b7 = Long.rotateLeft(b7, 39) ^ b2;
            b6 += b1;
            b1 = Long.rotateLeft(b1, 44) ^ b6;
            b0 += b7;
            b7 = Long.rotateLeft(b7, 9) ^ b0;
            b2 += b5;
            b5 = Long.rotateLeft(b5, 54) ^ b2;
            b4 += b3;
            b3 = Long.rotateLeft(b3, 56) ^ b4;
            b0 += this.kw[dm9];
            b1 += this.kw[dm9 + 1];
            b2 += this.kw[dm9 + 2];
            b3 += this.kw[dm9 + 3];
            b4 += this.kw[dm9 + 4];
            b5 += this.kw[dm9 + 5] + this.tw[dm3];
            b6 += this.kw[dm9 + 6] + this.tw[dm3 + 1];
            b7 += this.kw[dm9 + 7] + (long)d;
            b0 += b1;
            b1 = Long.rotateLeft(b1, 39) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 30) ^ b2;
            b4 += b5;
            b5 = Long.rotateLeft(b5, 34) ^ b4;
            b6 += b7;
            b7 = Long.rotateLeft(b7, 24) ^ b6;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 13) ^ b2;
            b4 += b7;
            b7 = Long.rotateLeft(b7, 50) ^ b4;
            b6 += b5;
            b5 = Long.rotateLeft(b5, 10) ^ b6;
            b0 += b3;
            b3 = Long.rotateLeft(b3, 17) ^ b0;
            b4 += b1;
            b1 = Long.rotateLeft(b1, 25) ^ b4;
            b6 += b3;
            b3 = Long.rotateLeft(b3, 29) ^ b6;
            b0 += b5;
            b5 = Long.rotateLeft(b5, 39) ^ b0;
            b2 += b7;
            b7 = Long.rotateLeft(b7, 43) ^ b2;
            b6 += b1;
            b1 = Long.rotateLeft(b1, 8) ^ b6;
            b0 += b7;
            b7 = Long.rotateLeft(b7, 35) ^ b0;
            b2 += b5;
            b5 = Long.rotateLeft(b5, 56) ^ b2;
            b4 += b3;
            b3 = Long.rotateLeft(b3, 22) ^ b4;
            b0 += this.kw[dm9 + 1];
            b1 += this.kw[dm9 + 2];
            b2 += this.kw[dm9 + 3];
            b3 += this.kw[dm9 + 4];
            b4 += this.kw[dm9 + 5];
            b5 += this.kw[dm9 + 6] + this.tw[dm3 + 1];
            b6 += this.kw[dm9 + 7] + this.tw[dm3 + 2];
            b7 += this.kw[dm9 + 8] + (long)d + 1L;
            d += 2;
        }
        Binary.setLongLE(arr, 0, b0);
        Binary.setLongLE(arr, 8, b1);
        Binary.setLongLE(arr, 16, b2);
        Binary.setLongLE(arr, 24, b3);
        Binary.setLongLE(arr, 32, b4);
        Binary.setLongLE(arr, 40, b5);
        Binary.setLongLE(arr, 48, b6);
        Binary.setLongLE(arr, 56, b7);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 64, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0);
        long b1 = Binary.getLongLE(arr, 8);
        long b2 = Binary.getLongLE(arr, 16);
        long b3 = Binary.getLongLE(arr, 24);
        long b4 = Binary.getLongLE(arr, 32);
        long b5 = Binary.getLongLE(arr, 40);
        long b6 = Binary.getLongLE(arr, 48);
        long b7 = Binary.getLongLE(arr, 56);
        int d = 17;
        while (d >= 1) {
            int dm9 = MOD9[d];
            int dm3 = MOD3[d];
            b0 -= this.kw[dm9 + 1];
            b1 -= this.kw[dm9 + 2];
            b2 -= this.kw[dm9 + 3];
            b3 -= this.kw[dm9 + 4];
            b4 -= this.kw[dm9 + 5];
            b5 -= this.kw[dm9 + 6] + this.tw[dm3 + 1];
            b7 -= this.kw[dm9 + 8] + (long)d + 1L;
            b1 = Long.rotateRight(b1 ^ (b6 -= this.kw[dm9 + 7] + this.tw[dm3 + 2]), 8);
            b6 -= b1;
            b7 = Long.rotateRight(b7 ^ b0, 35);
            b0 -= b7;
            b5 = Long.rotateRight(b5 ^ b2, 56);
            b2 -= b5;
            b3 = Long.rotateRight(b3 ^ b4, 22);
            b1 = Long.rotateRight(b1 ^ (b4 -= b3), 25);
            b4 -= b1;
            b3 = Long.rotateRight(b3 ^ b6, 29);
            b6 -= b3;
            b5 = Long.rotateRight(b5 ^ b0, 39);
            b0 -= b5;
            b7 = Long.rotateRight(b7 ^ b2, 43);
            b1 = Long.rotateRight(b1 ^ (b2 -= b7), 13);
            b2 -= b1;
            b7 = Long.rotateRight(b7 ^ b4, 50);
            b4 -= b7;
            b5 = Long.rotateRight(b5 ^ b6, 10);
            b6 -= b5;
            b3 = Long.rotateRight(b3 ^ b0, 17);
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 39);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 30);
            b2 -= b3;
            b5 = Long.rotateRight(b5 ^ b4, 34);
            b4 -= b5;
            b7 = Long.rotateRight(b7 ^ b6, 24);
            b6 -= b7;
            b0 -= this.kw[dm9];
            b1 -= this.kw[dm9 + 1];
            b2 -= this.kw[dm9 + 2];
            b3 -= this.kw[dm9 + 3];
            b4 -= this.kw[dm9 + 4];
            b5 -= this.kw[dm9 + 5] + this.tw[dm3];
            b7 -= this.kw[dm9 + 7] + (long)d;
            b1 = Long.rotateRight(b1 ^ (b6 -= this.kw[dm9 + 6] + this.tw[dm3 + 1]), 44);
            b6 -= b1;
            b7 = Long.rotateRight(b7 ^ b0, 9);
            b0 -= b7;
            b5 = Long.rotateRight(b5 ^ b2, 54);
            b2 -= b5;
            b3 = Long.rotateRight(b3 ^ b4, 56);
            b1 = Long.rotateRight(b1 ^ (b4 -= b3), 17);
            b4 -= b1;
            b3 = Long.rotateRight(b3 ^ b6, 49);
            b6 -= b3;
            b5 = Long.rotateRight(b5 ^ b0, 36);
            b0 -= b5;
            b7 = Long.rotateRight(b7 ^ b2, 39);
            b1 = Long.rotateRight(b1 ^ (b2 -= b7), 33);
            b2 -= b1;
            b7 = Long.rotateRight(b7 ^ b4, 27);
            b4 -= b7;
            b5 = Long.rotateRight(b5 ^ b6, 14);
            b6 -= b5;
            b3 = Long.rotateRight(b3 ^ b0, 42);
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 46);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 36);
            b2 -= b3;
            b5 = Long.rotateRight(b5 ^ b4, 19);
            b4 -= b5;
            b7 = Long.rotateRight(b7 ^ b6, 37);
            b6 -= b7;
            d -= 2;
        }
        Binary.setLongLE(arr, 0, b0 - this.kw[0]);
        Binary.setLongLE(arr, 8, b1 - this.kw[1]);
        Binary.setLongLE(arr, 16, b2 - this.kw[2]);
        Binary.setLongLE(arr, 24, b3 - this.kw[3]);
        Binary.setLongLE(arr, 32, b4 - this.kw[4]);
        Binary.setLongLE(arr, 40, b5 - this.kw[5] - this.tw[0]);
        Binary.setLongLE(arr, 48, b6 - this.kw[6] - this.tw[1]);
        Binary.setLongLE(arr, 56, b7 - this.kw[7]);
    }
}

