/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.blockcipher.DES;

public class TripleDES
extends BlockCipher {
    public static final int BLOCK_SIZE = 8;
    private DES des1 = new DES();
    private DES des2 = new DES();
    private DES des3 = new DES();

    public TripleDES() {
        this(Binary.Bin(16));
    }

    public TripleDES(Binary key) {
        super.initialize(8);
        this.setKey(key);
    }

    public TripleDES(String keyHex) {
        this(Binary.Bin(keyHex));
    }

    @Override
    public TripleDES clone() {
        return new TripleDES(this.key);
    }

    @Override
    public String getAlgName() {
        return "TripleDES";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 24, "Invalid TripleDES key size");
        this.key = key.clone();
        this.des1.setKey(key.first(8));
        this.des2.setKey(key.slice(8, 8));
        if (key.size() == 24) {
            this.des3.setKey(key.last(8));
        } else {
            this.des3.setKey(key.first(8));
        }
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(this.key.size());
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 16 || keySize == 24, "Invalid TripleDES key size");
        Binary akey = new Binary().randomSecure(keySize);
        DES.setOddParityBits(akey);
        this.setKey(akey);
        return akey;
    }

    @Override
    public void encryptBlock(Binary block) {
        this.des1.encryptBlock(block);
        this.des2.decryptBlock(block);
        this.des3.encryptBlock(block);
    }

    @Override
    public void decryptBlock(Binary block) {
        this.des3.decryptBlock(block);
        this.des2.encryptBlock(block);
        this.des1.decryptBlock(block);
    }

    public Binary calcMACAlg3(Binary data, AlignMode alignMode, Binary iv) {
        Binary mac = this.des1.calcMAC(data, alignMode, iv);
        this.des2.decryptBlock(mac);
        this.des3.encryptBlock(mac);
        return mac;
    }

    public Binary calcKCV() {
        Binary crypt = this.encrypt(Binary.Bin(8), CryptoMode.ECB, AlignMode.NONE, null);
        return crypt.slice(0, 3);
    }
}

