/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.F2mCurveAbstract;
import org.denom.crypt.ec.F2m.LongArray;

public class F2mCurve
extends F2mCurveAbstract {
    public F2mCurve(String oid, int m, int k1, int k2, int k3, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex) {
        super(m, k1, k2, k3, F2mCurve.isKoblitzCurve(F2mCurve.Hex2BigInt(aHex), F2mCurve.Hex2BigInt(bHex)));
        super.init(new F2mElement(), new F2mPoint(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private class F2mElement
    extends F2mCurveAbstract.F2mElementAbstract {
        public LongArray x;

        protected F2mElement() {
            super(F2mCurve.this);
        }

        public F2mElement(LongArray x) {
            super(F2mCurve.this);
            this.x = x;
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new F2mElement(new LongArray(x));
        }

        @Override
        public int bitLength() {
            return this.x.degree();
        }

        @Override
        public boolean isOne() {
            return this.x.isOne();
        }

        @Override
        public boolean isZero() {
            return this.x.isZero();
        }

        @Override
        public boolean testBitZero() {
            return this.x.testBitZero();
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x.toBigInteger();
        }

        @Override
        public ECCurve.ECElement add(ECCurve.ECElement b) {
            LongArray iarrClone = (LongArray)this.x.clone();
            F2mElement bF2m = (F2mElement)b;
            iarrClone.addShiftedByWords(bF2m.x, 0);
            return new F2mElement(iarrClone);
        }

        @Override
        public ECCurve.ECElement addOne() {
            return new F2mElement(this.x.addOne());
        }

        @Override
        public ECCurve.ECElement subtract(ECCurve.ECElement b) {
            return this.add(b);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            return new F2mElement(this.x.modMultiply(((F2mElement)b).x, F2mCurve.this.m, F2mCurve.this.ks));
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            LongArray ax = this.x;
            LongArray bx = ((F2mElement)b).x;
            LongArray xx = ((F2mElement)x).x;
            LongArray yx = ((F2mElement)y).x;
            LongArray ab = ax.multiply(bx);
            LongArray xy = xx.multiply(yx);
            if (ab == ax || ab == bx) {
                ab = (LongArray)ab.clone();
            }
            ab.addShiftedByWords(xy, 0);
            ab.reduce(F2mCurve.this.m, F2mCurve.this.ks);
            return new F2mElement(ab);
        }

        @Override
        public ECCurve.ECElement divide(ECCurve.ECElement b) {
            ECCurve.ECElement bInv = b.invert();
            return this.multiply(bInv);
        }

        @Override
        public ECCurve.ECElement negate() {
            return this;
        }

        @Override
        public ECCurve.ECElement square() {
            return new F2mElement(this.x.modSquare(F2mCurve.this.m, F2mCurve.this.ks));
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            LongArray ax = this.x;
            LongArray xx = ((F2mElement)x).x;
            LongArray yx = ((F2mElement)y).x;
            LongArray aa = ax.square();
            LongArray xy = xx.multiply(yx);
            if (aa == ax) {
                aa = (LongArray)aa.clone();
            }
            aa.addShiftedByWords(xy, 0);
            aa.reduce(F2mCurve.this.m, F2mCurve.this.ks);
            return new F2mElement(aa);
        }

        @Override
        public ECCurve.ECElement squarePow(int pow) {
            return pow < 1 ? this : new F2mElement(this.x.modSquareN(pow, F2mCurve.this.m, F2mCurve.this.ks));
        }

        @Override
        public ECCurve.ECElement invert() {
            return new F2mElement(this.x.modInverse(F2mCurve.this.m, F2mCurve.this.ks));
        }

        @Override
        public ECCurve.ECElement sqrt() {
            return this.x.isZero() || this.x.isOne() ? this : this.squarePow(F2mCurve.this.m - 1);
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2mElement)) {
                return false;
            }
            F2mElement b = (F2mElement)anObject;
            return this.x.equals(b.x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ F2mCurve.this.m ^ Arrays.hashCode(F2mCurve.this.ks);
        }
    }

    private class F2mPoint
    extends F2mCurveAbstract.F2mPointAbstract {
        private F2mPoint(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(F2mCurve.this, x, y);
        }

        private F2mPoint(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(F2mCurve.this, x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new F2mPoint(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new F2mPoint(x, y, zs);
        }

        @Override
        public ECCurve.ECElement getYCoord() {
            ECCurve.ECElement X = this.x;
            ECCurve.ECElement L = this.y;
            if (this.isInfinity() || X.isZero()) {
                return L;
            }
            ECCurve.ECElement Y = L.add(X).multiply(X);
            ECCurve.ECElement Z = this.zs[0];
            if (!Z.isOne()) {
                Y = Y.divide(Z);
            }
            return Y;
        }

        @Override
        protected boolean getCompressionYTilde() {
            ECCurve.ECElement X = this.getRawXCoord();
            if (X.isZero()) {
                return false;
            }
            ECCurve.ECElement Y = this.getRawYCoord();
            return Y.testBitZero() ^ X.testBitZero();
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            ECCurve.ECElement Z3;
            ECCurve.ECElement L3;
            ECCurve.ECElement X3;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement X2 = b.x;
            if (X1.isZero()) {
                if (X2.isZero()) {
                    return F2mCurve.this.getInfinity();
                }
                return b.add(this);
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement L2 = b.y;
            ECCurve.ECElement Z2 = b.zs[0];
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement U2 = X2;
            ECCurve.ECElement S2 = L2;
            if (!Z1IsOne) {
                U2 = U2.multiply(Z1);
                S2 = S2.multiply(Z1);
            }
            boolean Z2IsOne = Z2.isOne();
            ECCurve.ECElement U1 = X1;
            ECCurve.ECElement S1 = L1;
            if (!Z2IsOne) {
                U1 = U1.multiply(Z2);
                S1 = S1.multiply(Z2);
            }
            ECCurve.ECElement A = S1.add(S2);
            ECCurve.ECElement B = U1.add(U2);
            if (B.isZero()) {
                if (A.isZero()) {
                    return this.twice();
                }
                return F2mCurve.this.getInfinity();
            }
            if (X2.isZero()) {
                ECCurve.ECElement Y2;
                ECCurve.ECPoint p = this.normalize();
                X1 = p.getXCoord();
                ECCurve.ECElement Y1 = p.getYCoord();
                ECCurve.ECElement L = Y1.add(Y2 = L2).divide(X1);
                X3 = L.square().add(L).add(X1).add(F2mCurve.this.getA());
                if (X3.isZero()) {
                    return new F2mPoint(X3, F2mCurve.this.getB().sqrt());
                }
                ECCurve.ECElement Y3 = L.multiply(X1.add(X3)).add(X3).add(Y1);
                L3 = Y3.divide(X3).add(X3);
                Z3 = F2mCurve.this.fromBigInteger(BigInteger.ONE);
            } else {
                ECCurve.ECElement AU2;
                B = B.square();
                ECCurve.ECElement AU1 = A.multiply(U1);
                X3 = AU1.multiply(AU2 = A.multiply(U2));
                if (X3.isZero()) {
                    return new F2mPoint(X3, F2mCurve.this.getB().sqrt());
                }
                ECCurve.ECElement ABZ2 = A.multiply(B);
                if (!Z2IsOne) {
                    ABZ2 = ABZ2.multiply(Z2);
                }
                L3 = AU2.add(B).squarePlusProduct(ABZ2, L1.add(Z1));
                Z3 = ABZ2;
                if (!Z1IsOne) {
                    Z3 = Z3.multiply(Z1);
                }
            }
            return new F2mPoint(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twice() {
            ECCurve.ECElement L3;
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X1 = this.x;
            if (X1.isZero()) {
                return F2mCurve.this.getInfinity();
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement L1Z1 = Z1IsOne ? L1 : L1.multiply(Z1);
            ECCurve.ECElement Z1Sq = Z1IsOne ? Z1 : Z1.square();
            ECCurve.ECElement a = F2mCurve.this.getA();
            ECCurve.ECElement aZ1Sq = Z1IsOne ? a : a.multiply(Z1Sq);
            ECCurve.ECElement T = L1.square().add(L1Z1).add(aZ1Sq);
            if (T.isZero()) {
                return new F2mPoint(T, F2mCurve.this.getB().sqrt());
            }
            ECCurve.ECElement X3 = T.square();
            ECCurve.ECElement Z3 = Z1IsOne ? T : T.multiply(Z1Sq);
            ECCurve.ECElement b = F2mCurve.this.getB();
            if (b.bitLength() < F2mCurve.this.getFieldSize() >> 1) {
                ECCurve.ECElement t1 = L1.add(X1).square();
                ECCurve.ECElement t2 = b.isOne() ? aZ1Sq.add(Z1Sq).square() : aZ1Sq.squarePlusProduct(b, Z1Sq.square());
                L3 = t1.add(T).add(Z1Sq).multiply(t1).add(t2).add(X3);
                if (a.isZero()) {
                    L3 = L3.add(Z3);
                } else if (!a.isOne()) {
                    L3 = L3.add(a.addOne().multiply(Z3));
                }
            } else {
                ECCurve.ECElement X1Z1 = Z1IsOne ? X1 : X1.multiply(Z1);
                L3 = X1Z1.squarePlusProduct(T, L1Z1).add(X3).add(Z3);
            }
            return new F2mPoint(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twicePlus(ECCurve.ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this.twice();
            }
            ECCurve.ECElement X1 = this.x;
            if (X1.isZero()) {
                return b;
            }
            ECCurve.ECElement X2 = b.x;
            ECCurve.ECElement Z2 = b.zs[0];
            if (X2.isZero() || !Z2.isOne()) {
                return this.twice().add(b);
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement L2 = b.y;
            ECCurve.ECElement X1Sq = X1.square();
            ECCurve.ECElement L1Sq = L1.square();
            ECCurve.ECElement Z1Sq = Z1.square();
            ECCurve.ECElement L1Z1 = L1.multiply(Z1);
            ECCurve.ECElement T = F2mCurve.this.getA().multiply(Z1Sq).add(L1Sq).add(L1Z1);
            ECCurve.ECElement L2plus1 = L2.addOne();
            ECCurve.ECElement A = F2mCurve.this.getA().add(L2plus1).multiply(Z1Sq).add(L1Sq).multiplyPlusProduct(T, X1Sq, Z1Sq);
            ECCurve.ECElement X2Z1Sq = X2.multiply(Z1Sq);
            ECCurve.ECElement B = X2Z1Sq.add(T).square();
            if (B.isZero()) {
                if (A.isZero()) {
                    return b.twice();
                }
                return F2mCurve.this.getInfinity();
            }
            if (A.isZero()) {
                return new F2mPoint(A, F2mCurve.this.getB().sqrt());
            }
            ECCurve.ECElement X3 = A.square().multiply(X2Z1Sq);
            ECCurve.ECElement Z3 = A.multiply(B).multiply(Z1Sq);
            ECCurve.ECElement L3 = A.add(B).square().multiplyPlusProduct(T, L2plus1, Z3);
            return new F2mPoint(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint negate() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X = this.x;
            if (X.isZero()) {
                return this;
            }
            ECCurve.ECElement L = this.y;
            ECCurve.ECElement Z = this.zs[0];
            return new F2mPoint(X, L.add(Z), new ECCurve.ECElement[]{Z});
        }
    }
}

