/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m;

import java.math.BigInteger;
import org.denom.Ex;

public class LongArray
implements Cloneable {
    private static final short[] INTERLEAVE2_TABLE;
    private long[] longs;

    static {
        short[] sArray = new short[256];
        sArray[1] = 1;
        sArray[2] = 4;
        sArray[3] = 5;
        sArray[4] = 16;
        sArray[5] = 17;
        sArray[6] = 20;
        sArray[7] = 21;
        sArray[8] = 64;
        sArray[9] = 65;
        sArray[10] = 68;
        sArray[11] = 69;
        sArray[12] = 80;
        sArray[13] = 81;
        sArray[14] = 84;
        sArray[15] = 85;
        sArray[16] = 256;
        sArray[17] = 257;
        sArray[18] = 260;
        sArray[19] = 261;
        sArray[20] = 272;
        sArray[21] = 273;
        sArray[22] = 276;
        sArray[23] = 277;
        sArray[24] = 320;
        sArray[25] = 321;
        sArray[26] = 324;
        sArray[27] = 325;
        sArray[28] = 336;
        sArray[29] = 337;
        sArray[30] = 340;
        sArray[31] = 341;
        sArray[32] = 1024;
        sArray[33] = 1025;
        sArray[34] = 1028;
        sArray[35] = 1029;
        sArray[36] = 1040;
        sArray[37] = 1041;
        sArray[38] = 1044;
        sArray[39] = 1045;
        sArray[40] = 1088;
        sArray[41] = 1089;
        sArray[42] = 1092;
        sArray[43] = 1093;
        sArray[44] = 1104;
        sArray[45] = 1105;
        sArray[46] = 1108;
        sArray[47] = 1109;
        sArray[48] = 1280;
        sArray[49] = 1281;
        sArray[50] = 1284;
        sArray[51] = 1285;
        sArray[52] = 1296;
        sArray[53] = 1297;
        sArray[54] = 1300;
        sArray[55] = 1301;
        sArray[56] = 1344;
        sArray[57] = 1345;
        sArray[58] = 1348;
        sArray[59] = 1349;
        sArray[60] = 1360;
        sArray[61] = 1361;
        sArray[62] = 1364;
        sArray[63] = 1365;
        sArray[64] = 4096;
        sArray[65] = 4097;
        sArray[66] = 4100;
        sArray[67] = 4101;
        sArray[68] = 4112;
        sArray[69] = 4113;
        sArray[70] = 4116;
        sArray[71] = 4117;
        sArray[72] = 4160;
        sArray[73] = 4161;
        sArray[74] = 4164;
        sArray[75] = 4165;
        sArray[76] = 4176;
        sArray[77] = 4177;
        sArray[78] = 4180;
        sArray[79] = 4181;
        sArray[80] = 4352;
        sArray[81] = 4353;
        sArray[82] = 4356;
        sArray[83] = 4357;
        sArray[84] = 4368;
        sArray[85] = 4369;
        sArray[86] = 4372;
        sArray[87] = 4373;
        sArray[88] = 4416;
        sArray[89] = 4417;
        sArray[90] = 4420;
        sArray[91] = 4421;
        sArray[92] = 4432;
        sArray[93] = 4433;
        sArray[94] = 4436;
        sArray[95] = 4437;
        sArray[96] = 5120;
        sArray[97] = 5121;
        sArray[98] = 5124;
        sArray[99] = 5125;
        sArray[100] = 5136;
        sArray[101] = 5137;
        sArray[102] = 5140;
        sArray[103] = 5141;
        sArray[104] = 5184;
        sArray[105] = 5185;
        sArray[106] = 5188;
        sArray[107] = 5189;
        sArray[108] = 5200;
        sArray[109] = 5201;
        sArray[110] = 5204;
        sArray[111] = 5205;
        sArray[112] = 5376;
        sArray[113] = 5377;
        sArray[114] = 5380;
        sArray[115] = 5381;
        sArray[116] = 5392;
        sArray[117] = 5393;
        sArray[118] = 5396;
        sArray[119] = 5397;
        sArray[120] = 5440;
        sArray[121] = 5441;
        sArray[122] = 5444;
        sArray[123] = 5445;
        sArray[124] = 5456;
        sArray[125] = 5457;
        sArray[126] = 5460;
        sArray[127] = 5461;
        sArray[128] = 16384;
        sArray[129] = 16385;
        sArray[130] = 16388;
        sArray[131] = 16389;
        sArray[132] = 16400;
        sArray[133] = 16401;
        sArray[134] = 16404;
        sArray[135] = 16405;
        sArray[136] = 16448;
        sArray[137] = 16449;
        sArray[138] = 16452;
        sArray[139] = 16453;
        sArray[140] = 16464;
        sArray[141] = 16465;
        sArray[142] = 16468;
        sArray[143] = 16469;
        sArray[144] = 16640;
        sArray[145] = 16641;
        sArray[146] = 16644;
        sArray[147] = 16645;
        sArray[148] = 16656;
        sArray[149] = 16657;
        sArray[150] = 16660;
        sArray[151] = 16661;
        sArray[152] = 16704;
        sArray[153] = 16705;
        sArray[154] = 16708;
        sArray[155] = 16709;
        sArray[156] = 16720;
        sArray[157] = 16721;
        sArray[158] = 16724;
        sArray[159] = 16725;
        sArray[160] = 17408;
        sArray[161] = 17409;
        sArray[162] = 17412;
        sArray[163] = 17413;
        sArray[164] = 17424;
        sArray[165] = 17425;
        sArray[166] = 17428;
        sArray[167] = 17429;
        sArray[168] = 17472;
        sArray[169] = 17473;
        sArray[170] = 17476;
        sArray[171] = 17477;
        sArray[172] = 17488;
        sArray[173] = 17489;
        sArray[174] = 17492;
        sArray[175] = 17493;
        sArray[176] = 17664;
        sArray[177] = 17665;
        sArray[178] = 17668;
        sArray[179] = 17669;
        sArray[180] = 17680;
        sArray[181] = 17681;
        sArray[182] = 17684;
        sArray[183] = 17685;
        sArray[184] = 17728;
        sArray[185] = 17729;
        sArray[186] = 17732;
        sArray[187] = 17733;
        sArray[188] = 17744;
        sArray[189] = 17745;
        sArray[190] = 17748;
        sArray[191] = 17749;
        sArray[192] = 20480;
        sArray[193] = 20481;
        sArray[194] = 20484;
        sArray[195] = 20485;
        sArray[196] = 20496;
        sArray[197] = 20497;
        sArray[198] = 20500;
        sArray[199] = 20501;
        sArray[200] = 20544;
        sArray[201] = 20545;
        sArray[202] = 20548;
        sArray[203] = 20549;
        sArray[204] = 20560;
        sArray[205] = 20561;
        sArray[206] = 20564;
        sArray[207] = 20565;
        sArray[208] = 20736;
        sArray[209] = 20737;
        sArray[210] = 20740;
        sArray[211] = 20741;
        sArray[212] = 20752;
        sArray[213] = 20753;
        sArray[214] = 20756;
        sArray[215] = 20757;
        sArray[216] = 20800;
        sArray[217] = 20801;
        sArray[218] = 20804;
        sArray[219] = 20805;
        sArray[220] = 20816;
        sArray[221] = 20817;
        sArray[222] = 20820;
        sArray[223] = 20821;
        sArray[224] = 21504;
        sArray[225] = 21505;
        sArray[226] = 21508;
        sArray[227] = 21509;
        sArray[228] = 21520;
        sArray[229] = 21521;
        sArray[230] = 21524;
        sArray[231] = 21525;
        sArray[232] = 21568;
        sArray[233] = 21569;
        sArray[234] = 21572;
        sArray[235] = 21573;
        sArray[236] = 21584;
        sArray[237] = 21585;
        sArray[238] = 21588;
        sArray[239] = 21589;
        sArray[240] = 21760;
        sArray[241] = 21761;
        sArray[242] = 21764;
        sArray[243] = 21765;
        sArray[244] = 21776;
        sArray[245] = 21777;
        sArray[246] = 21780;
        sArray[247] = 21781;
        sArray[248] = 21824;
        sArray[249] = 21825;
        sArray[250] = 21828;
        sArray[251] = 21829;
        sArray[252] = 21840;
        sArray[253] = 21841;
        sArray[254] = 21844;
        sArray[255] = 21845;
        INTERLEAVE2_TABLE = sArray;
    }

    public LongArray(int intLen) {
        this.longs = new long[intLen];
    }

    public LongArray(long[] ints) {
        this.longs = ints;
    }

    public LongArray(long[] ints, int off, int len) {
        if (off == 0 && len == ints.length) {
            this.longs = ints;
        } else {
            this.longs = new long[len];
            System.arraycopy(ints, off, this.longs, 0, len);
        }
    }

    public LongArray(BigInteger bigInt) {
        Ex.MUST(bigInt != null && bigInt.signum() >= 0);
        if (bigInt.signum() == 0) {
            this.longs = new long[1];
            return;
        }
        byte[] barr = bigInt.toByteArray();
        int barrLen = barr.length;
        int barrStart = 0;
        if (barr[0] == 0) {
            --barrLen;
            barrStart = 1;
        }
        int intLen = (barrLen + 7) / 8;
        this.longs = new long[intLen];
        int iarrJ = intLen - 1;
        int rem = barrLen % 8 + barrStart;
        long temp = 0L;
        int barrI = barrStart;
        if (barrStart < rem) {
            while (barrI < rem) {
                temp <<= 8;
                int barrBarrI = barr[barrI] & 0xFF;
                temp |= (long)barrBarrI;
                ++barrI;
            }
            this.longs[iarrJ--] = temp;
        }
        while (iarrJ >= 0) {
            temp = 0L;
            int i = 0;
            while (i < 8) {
                temp <<= 8;
                int barrBarrI = barr[barrI++] & 0xFF;
                temp |= (long)barrBarrI;
                ++i;
            }
            this.longs[iarrJ] = temp;
            --iarrJ;
        }
    }

    public void copyTo(long[] z, int zOff) {
        System.arraycopy(this.longs, 0, z, zOff, this.longs.length);
    }

    public boolean isOne() {
        long[] a = this.longs;
        if (a[0] != 1L) {
            return false;
        }
        int i = 1;
        while (i < a.length) {
            if (a[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isZero() {
        long[] a = this.longs;
        int i = 0;
        while (i < a.length) {
            if (a[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getUsedLength() {
        return this.getUsedLengthFrom(this.longs.length);
    }

    public int getUsedLengthFrom(int from) {
        long[] a = this.longs;
        if ((from = Math.min(from, a.length)) < 1) {
            return 0;
        }
        if (a[0] != 0L) {
            while (a[--from] == 0L) {
            }
            return from + 1;
        }
        do {
            if (a[--from] == 0L) continue;
            return from + 1;
        } while (from > 0);
        return 0;
    }

    public int degree() {
        long w;
        int i = this.longs.length;
        do {
            if (i != 0) continue;
            return 0;
        } while ((w = this.longs[--i]) == 0L);
        return (i << 6) + (64 - Long.numberOfLeadingZeros(w));
    }

    private int degreeFrom(int limit) {
        long w;
        int i = limit + 62 >>> 6;
        do {
            if (i != 0) continue;
            return 0;
        } while ((w = this.longs[--i]) == 0L);
        return (i << 6) + (64 - Long.numberOfLeadingZeros(w));
    }

    private long[] resizedInts(int newLen) {
        long[] newInts = new long[newLen];
        System.arraycopy(this.longs, 0, newInts, 0, Math.min(this.longs.length, newLen));
        return newInts;
    }

    public BigInteger toBigInteger() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return BigInteger.valueOf(0L);
        }
        long highestInt = this.longs[usedLen - 1];
        byte[] temp = new byte[8];
        int barrI = 0;
        boolean trailingZeroBytesDone = false;
        int j = 7;
        while (j >= 0) {
            byte thisByte = (byte)(highestInt >>> 8 * j);
            if (trailingZeroBytesDone || thisByte != 0) {
                trailingZeroBytesDone = true;
                temp[barrI++] = thisByte;
            }
            --j;
        }
        int barrLen = 8 * (usedLen - 1) + barrI;
        byte[] barr = new byte[barrLen];
        int j2 = 0;
        while (j2 < barrI) {
            barr[j2] = temp[j2];
            ++j2;
        }
        int iarrJ = usedLen - 2;
        while (iarrJ >= 0) {
            long mi = this.longs[iarrJ];
            int j3 = 7;
            while (j3 >= 0) {
                barr[barrI++] = (byte)(mi >>> 8 * j3);
                --j3;
            }
            --iarrJ;
        }
        return new BigInteger(1, barr);
    }

    private static long shiftUp(long[] x, int xOff, long[] z, int zOff, int count, int shift) {
        int shiftInv = 64 - shift;
        long prev = 0L;
        int i = 0;
        while (i < count) {
            long next = x[xOff + i];
            z[zOff + i] = next << shift | prev;
            prev = next >>> shiftInv;
            ++i;
        }
        return prev;
    }

    public LongArray addOne() {
        if (this.longs.length == 0) {
            return new LongArray(new long[]{1L});
        }
        int resultLen = Math.max(1, this.getUsedLength());
        long[] ints = this.resizedInts(resultLen);
        ints[0] = ints[0] ^ 1L;
        return new LongArray(ints);
    }

    private void addShiftedByBitsSafe(LongArray other, int otherDegree, int bits) {
        int otherLen = otherDegree + 63 >>> 6;
        int words = bits >>> 6;
        int shift = bits & 0x3F;
        if (shift == 0) {
            LongArray.add(this.longs, words, other.longs, 0, otherLen);
            return;
        }
        long carry = LongArray.addShiftedUp(this.longs, words, other.longs, 0, otherLen, shift);
        if (carry != 0L) {
            int n = otherLen + words;
            this.longs[n] = this.longs[n] ^ carry;
        }
    }

    private static long addShiftedUp(long[] x, int xOff, long[] y, int yOff, int count, int shift) {
        int shiftInv = 64 - shift;
        long prev = 0L;
        int i = 0;
        while (i < count) {
            long next = y[yOff + i];
            int n = xOff + i;
            x[n] = x[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
            ++i;
        }
        return prev;
    }

    private static long addShiftedDown(long[] x, int xOff, long[] y, int yOff, int count, int shift) {
        int shiftInv = 64 - shift;
        long prev = 0L;
        int i = count;
        while (--i >= 0) {
            long next = y[yOff + i];
            int n = xOff + i;
            x[n] = x[n] ^ (next >>> shift | prev);
            prev = next << shiftInv;
        }
        return prev;
    }

    public void addShiftedByWords(LongArray other, int words) {
        int otherUsedLen = other.getUsedLength();
        if (otherUsedLen == 0) {
            return;
        }
        int minLen = otherUsedLen + words;
        if (minLen > this.longs.length) {
            this.longs = this.resizedInts(minLen);
        }
        LongArray.add(this.longs, words, other.longs, 0, otherUsedLen);
    }

    private static void add(long[] x, int xOff, long[] y, int yOff, int count) {
        int i = 0;
        while (i < count) {
            int n = xOff + i;
            x[n] = x[n] ^ y[yOff + i];
            ++i;
        }
    }

    private static void add(long[] x, int xOff, long[] y, int yOff, long[] z, int zOff, int count) {
        int i = 0;
        while (i < count) {
            z[zOff + i] = x[xOff + i] ^ y[yOff + i];
            ++i;
        }
    }

    private static void addBoth(long[] x, int xOff, long[] y1, int y1Off, long[] y2, int y2Off, int count) {
        int i = 0;
        while (i < count) {
            int n = xOff + i;
            x[n] = x[n] ^ (y1[y1Off + i] ^ y2[y2Off + i]);
            ++i;
        }
    }

    private static void flipWord(long[] buf, int off, int bit, long word) {
        int n = off + (bit >>> 6);
        int shift = bit & 0x3F;
        if (shift == 0) {
            int n2 = n;
            buf[n2] = buf[n2] ^ word;
        } else {
            int n3 = n++;
            buf[n3] = buf[n3] ^ word << shift;
            if ((word >>>= 64 - shift) != 0L) {
                int n4 = n;
                buf[n4] = buf[n4] ^ word;
            }
        }
    }

    public boolean testBitZero() {
        return this.longs.length > 0 && (this.longs[0] & 1L) != 0L;
    }

    private static boolean testBit(long[] buf, int off, int n) {
        int theInt = n >>> 6;
        int theBit = n & 0x3F;
        long tester = 1L << theBit;
        return (buf[off + theInt] & tester) != 0L;
    }

    private static void flipBit(long[] buf, int off, int n) {
        int theInt = n >>> 6;
        int theBit = n & 0x3F;
        long flipper = 1L << theBit;
        int n2 = off + theInt;
        buf[n2] = buf[n2] ^ flipper;
    }

    private static void multiplyWord(long a, long[] b, int bLen, long[] c, int cOff) {
        if ((a & 1L) != 0L) {
            LongArray.add(c, cOff, b, 0, bLen);
        }
        int k = 1;
        while ((a >>>= 1) != 0L) {
            long carry;
            if ((a & 1L) != 0L && (carry = LongArray.addShiftedUp(c, cOff, b, 0, bLen, k)) != 0L) {
                int n = cOff + bLen;
                c[n] = c[n] ^ carry;
            }
            ++k;
        }
    }

    public LongArray modMultiply(LongArray other, int m, int[] ks) {
        int tOff;
        int aDeg = this.degree();
        if (aDeg == 0) {
            return this;
        }
        int bDeg = other.degree();
        if (bDeg == 0) {
            return other;
        }
        LongArray A = this;
        LongArray B = other;
        if (aDeg > bDeg) {
            A = other;
            B = this;
            int tmp = aDeg;
            aDeg = bDeg;
            bDeg = tmp;
        }
        int aLen = aDeg + 63 >>> 6;
        int bLen = bDeg + 63 >>> 6;
        int cLen = aDeg + bDeg + 62 >>> 6;
        if (aLen == 1) {
            long a0 = A.longs[0];
            if (a0 == 1L) {
                return B;
            }
            long[] c0 = new long[cLen];
            LongArray.multiplyWord(a0, B.longs, bLen, c0, 0);
            return LongArray.reduceResult(c0, 0, cLen, m, ks);
        }
        int bMax = bDeg + 7 + 63 >>> 6;
        int[] ti = new int[16];
        long[] T0 = new long[bMax << 4];
        ti[1] = tOff = bMax;
        System.arraycopy(B.longs, 0, T0, tOff, bLen);
        int i = 2;
        while (i < 16) {
            ti[i] = tOff += bMax;
            if ((i & 1) == 0) {
                LongArray.shiftUp(T0, tOff >>> 1, T0, tOff, bMax, 1);
            } else {
                LongArray.add(T0, bMax, T0, tOff - bMax, T0, tOff, bMax);
            }
            ++i;
        }
        long[] T1 = new long[T0.length];
        LongArray.shiftUp(T0, 0, T1, 0, T0.length, 4);
        long[] a = A.longs;
        long[] c = new long[cLen << 3];
        int MASK = 15;
        int aPos = 0;
        while (aPos < aLen) {
            long aVal = a[aPos];
            int cOff = aPos;
            while (true) {
                int u = (int)aVal & MASK;
                int v = (int)(aVal >>>= 4) & MASK;
                LongArray.addBoth(c, cOff, T0, ti[u], T1, ti[v], bMax);
                if ((aVal >>>= 4) == 0L) break;
                cOff += cLen;
            }
            ++aPos;
        }
        int cOff = c.length;
        while ((cOff -= cLen) != 0) {
            LongArray.addShiftedUp(c, cOff - cLen, c, cOff, cLen, 8);
        }
        return LongArray.reduceResult(c, 0, cLen, m, ks);
    }

    public LongArray modReduce(int m, int[] ks) {
        long[] buf = (long[])this.longs.clone();
        int rLen = LongArray.reduceInPlace(buf, 0, buf.length, m, ks);
        return new LongArray(buf, 0, rLen);
    }

    public LongArray multiply(LongArray other) {
        int tOff;
        int aDeg = this.degree();
        if (aDeg == 0) {
            return this;
        }
        int bDeg = other.degree();
        if (bDeg == 0) {
            return other;
        }
        LongArray A = this;
        LongArray B = other;
        if (aDeg > bDeg) {
            A = other;
            B = this;
            int tmp = aDeg;
            aDeg = bDeg;
            bDeg = tmp;
        }
        int aLen = aDeg + 63 >>> 6;
        int bLen = bDeg + 63 >>> 6;
        int cLen = aDeg + bDeg + 62 >>> 6;
        if (aLen == 1) {
            long a0 = A.longs[0];
            if (a0 == 1L) {
                return B;
            }
            long[] c0 = new long[cLen];
            LongArray.multiplyWord(a0, B.longs, bLen, c0, 0);
            return new LongArray(c0, 0, cLen);
        }
        int bMax = bDeg + 7 + 63 >>> 6;
        int[] ti = new int[16];
        long[] T0 = new long[bMax << 4];
        ti[1] = tOff = bMax;
        System.arraycopy(B.longs, 0, T0, tOff, bLen);
        int i = 2;
        while (i < 16) {
            ti[i] = tOff += bMax;
            if ((i & 1) == 0) {
                LongArray.shiftUp(T0, tOff >>> 1, T0, tOff, bMax, 1);
            } else {
                LongArray.add(T0, bMax, T0, tOff - bMax, T0, tOff, bMax);
            }
            ++i;
        }
        long[] T1 = new long[T0.length];
        LongArray.shiftUp(T0, 0, T1, 0, T0.length, 4);
        long[] a = A.longs;
        long[] c = new long[cLen << 3];
        int MASK = 15;
        int aPos = 0;
        while (aPos < aLen) {
            long aVal = a[aPos];
            int cOff = aPos;
            while (true) {
                int u = (int)aVal & MASK;
                int v = (int)(aVal >>>= 4) & MASK;
                LongArray.addBoth(c, cOff, T0, ti[u], T1, ti[v], bMax);
                if ((aVal >>>= 4) == 0L) break;
                cOff += cLen;
            }
            ++aPos;
        }
        int cOff = c.length;
        while ((cOff -= cLen) != 0) {
            LongArray.addShiftedUp(c, cOff - cLen, c, cOff, cLen, 8);
        }
        return new LongArray(c, 0, cLen);
    }

    public void reduce(int m, int[] ks) {
        long[] buf = this.longs;
        int rLen = LongArray.reduceInPlace(buf, 0, buf.length, m, ks);
        if (rLen < buf.length) {
            this.longs = new long[rLen];
            System.arraycopy(buf, 0, this.longs, 0, rLen);
        }
    }

    private static LongArray reduceResult(long[] buf, int off, int len, int m, int[] ks) {
        int rLen = LongArray.reduceInPlace(buf, off, len, m, ks);
        return new LongArray(buf, off, rLen);
    }

    private static int reduceInPlace(long[] buf, int off, int len, int m, int[] ks) {
        int mLen = m + 63 >>> 6;
        if (len < mLen) {
            return len;
        }
        int numBits = Math.min(len << 6, (m << 1) - 1);
        int excessBits = (len << 6) - numBits;
        while (excessBits >= 64) {
            --len;
            excessBits -= 64;
        }
        int kLen = ks.length;
        int kMax = ks[kLen - 1];
        int kNext = kLen > 1 ? ks[kLen - 2] : 0;
        int wordWiseLimit = Math.max(m, kMax + 64);
        int vectorableWords = excessBits + Math.min(numBits - wordWiseLimit, m - kNext) >> 6;
        if (vectorableWords > 1) {
            int vectorWiseWords = len - vectorableWords;
            LongArray.reduceVectorWise(buf, off, len, vectorWiseWords, m, ks);
            while (len > vectorWiseWords) {
                buf[off + --len] = 0L;
            }
            numBits = vectorWiseWords << 6;
        }
        if (numBits > wordWiseLimit) {
            LongArray.reduceWordWise(buf, off, len, wordWiseLimit, m, ks);
            numBits = wordWiseLimit;
        }
        if (numBits > m) {
            LongArray.reduceBitWise(buf, off, numBits, m, ks);
        }
        return mLen;
    }

    private static void reduceBitWise(long[] buf, int off, int bitlength, int m, int[] ks) {
        while (--bitlength >= m) {
            if (!LongArray.testBit(buf, off, bitlength)) continue;
            LongArray.reduceBit(buf, off, bitlength, m, ks);
        }
    }

    private static void reduceBit(long[] buf, int off, int bit, int m, int[] ks) {
        LongArray.flipBit(buf, off, bit);
        int n = bit - m;
        int j = ks.length;
        while (--j >= 0) {
            LongArray.flipBit(buf, off, ks[j] + n);
        }
        LongArray.flipBit(buf, off, n);
    }

    private static void reduceWordWise(long[] buf, int off, int len, int toBit, int m, int[] ks) {
        int toPos = toBit >>> 6;
        while (--len > toPos) {
            long word = buf[off + len];
            if (word == 0L) continue;
            buf[off + len] = 0L;
            LongArray.reduceWord(buf, off, len << 6, word, m, ks);
        }
        int partial = toBit & 0x3F;
        long word = buf[off + toPos] >>> partial;
        if (word != 0L) {
            int n = off + toPos;
            buf[n] = buf[n] ^ word << partial;
            LongArray.reduceWord(buf, off, toBit, word, m, ks);
        }
    }

    private static void reduceWord(long[] buf, int off, int bit, long word, int m, int[] ks) {
        int offset = bit - m;
        int j = ks.length;
        while (--j >= 0) {
            LongArray.flipWord(buf, off, offset + ks[j], word);
        }
        LongArray.flipWord(buf, off, offset, word);
    }

    private static void reduceVectorWise(long[] buf, int off, int len, int words, int m, int[] ks) {
        int baseBit = (words << 6) - m;
        int j = ks.length;
        while (--j >= 0) {
            LongArray.flipVector(buf, off, buf, off + words, len - words, baseBit + ks[j]);
        }
        LongArray.flipVector(buf, off, buf, off + words, len - words, baseBit);
    }

    private static void flipVector(long[] x, int xOff, long[] y, int yOff, int yLen, int bits) {
        xOff += bits >>> 6;
        if ((bits &= 0x3F) == 0) {
            LongArray.add(x, xOff, y, yOff, yLen);
        } else {
            long carry = LongArray.addShiftedDown(x, xOff + 1, y, yOff, yLen, 64 - bits);
            int n = xOff;
            x[n] = x[n] ^ carry;
        }
    }

    public LongArray modSquare(int m, int[] ks) {
        int len = this.getUsedLength();
        if (len == 0) {
            return this;
        }
        int _2len = len << 1;
        long[] r = new long[_2len];
        int pos = 0;
        while (pos < _2len) {
            long mi = this.longs[pos >>> 1];
            r[pos++] = LongArray.interleave2_32to64((int)mi);
            r[pos++] = LongArray.interleave2_32to64((int)(mi >>> 32));
        }
        return new LongArray(r, 0, LongArray.reduceInPlace(r, 0, r.length, m, ks));
    }

    public LongArray modSquareN(int n, int m, int[] ks) {
        int len = this.getUsedLength();
        if (len == 0) {
            return this;
        }
        int mLen = m + 63 >>> 6;
        long[] r = new long[mLen << 1];
        System.arraycopy(this.longs, 0, r, 0, len);
        while (--n >= 0) {
            LongArray.squareInPlace(r, len, m, ks);
            len = LongArray.reduceInPlace(r, 0, r.length, m, ks);
        }
        return new LongArray(r, 0, len);
    }

    public LongArray square() {
        int len = this.getUsedLength();
        if (len == 0) {
            return this;
        }
        int _2len = len << 1;
        long[] r = new long[_2len];
        int pos = 0;
        while (pos < _2len) {
            long mi = this.longs[pos >>> 1];
            r[pos++] = LongArray.interleave2_32to64((int)mi);
            r[pos++] = LongArray.interleave2_32to64((int)(mi >>> 32));
        }
        return new LongArray(r, 0, r.length);
    }

    private static void squareInPlace(long[] x, int xLen, int m, int[] ks) {
        int pos = xLen << 1;
        while (--xLen >= 0) {
            long xVal = x[xLen];
            x[--pos] = LongArray.interleave2_32to64((int)(xVal >>> 32));
            x[--pos] = LongArray.interleave2_32to64((int)xVal);
        }
    }

    private static long interleave2_32to64(int x) {
        int r00 = INTERLEAVE2_TABLE[x & 0xFF] | INTERLEAVE2_TABLE[x >>> 8 & 0xFF] << 16;
        int r32 = INTERLEAVE2_TABLE[x >>> 16 & 0xFF] | INTERLEAVE2_TABLE[x >>> 24] << 16;
        return ((long)r32 & 0xFFFFFFFFL) << 32 | (long)r00 & 0xFFFFFFFFL;
    }

    public LongArray modInverse(int m, int[] ks) {
        int uzDegree = this.degree();
        if (uzDegree == 0) {
            throw new IllegalStateException();
        }
        if (uzDegree == 1) {
            return this;
        }
        LongArray uz = (LongArray)this.clone();
        int t = m + 63 >>> 6;
        LongArray vz = new LongArray(t);
        LongArray.reduceBit(vz.longs, 0, m, m, ks);
        LongArray g1z = new LongArray(t);
        g1z.longs[0] = 1L;
        LongArray g2z = new LongArray(t);
        int[] uvDeg = new int[]{uzDegree, m + 1};
        LongArray[] uv = new LongArray[]{uz, vz};
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] ggDeg = nArray;
        LongArray[] gg = new LongArray[]{g1z, g2z};
        int b = 1;
        int duv1 = uvDeg[b];
        int dgg1 = ggDeg[b];
        int j = duv1 - uvDeg[1 - b];
        while (true) {
            if (j < 0) {
                j = -j;
                uvDeg[b] = duv1;
                ggDeg[b] = dgg1;
                b = 1 - b;
                duv1 = uvDeg[b];
                dgg1 = ggDeg[b];
            }
            uv[b].addShiftedByBitsSafe(uv[1 - b], uvDeg[1 - b], j);
            int duv2 = uv[b].degreeFrom(duv1);
            if (duv2 == 0) {
                return gg[1 - b];
            }
            int dgg2 = ggDeg[1 - b];
            gg[b].addShiftedByBitsSafe(gg[1 - b], dgg2, j);
            if ((dgg2 += j) > dgg1) {
                dgg1 = dgg2;
            } else if (dgg2 == dgg1) {
                dgg1 = gg[b].degreeFrom(dgg1);
            }
            j += duv2 - duv1;
            duv1 = duv2;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof LongArray)) {
            return false;
        }
        LongArray other = (LongArray)o;
        int usedLen = this.getUsedLength();
        if (other.getUsedLength() != usedLen) {
            return false;
        }
        int i = 0;
        while (i < usedLen) {
            if (this.longs[i] != other.longs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int usedLen = this.getUsedLength();
        int hash = 1;
        int i = 0;
        while (i < usedLen) {
            long mi = this.longs[i];
            hash *= 31;
            hash ^= (int)mi;
            hash *= 31;
            hash ^= (int)(mi >>> 32);
            ++i;
        }
        return hash;
    }

    public Object clone() {
        return new LongArray((long[])this.longs.clone());
    }
}

