/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m;

import java.math.BigInteger;
import org.denom.Ex;

class SimpleBigDecimal {
    private final BigInteger bigInt;
    final int scale;

    SimpleBigDecimal(BigInteger bigInt, int scale) {
        this.bigInt = bigInt;
        this.scale = scale;
    }

    SimpleBigDecimal adjustScale(int newScale) {
        Ex.MUST(newScale >= 0, "scale may not be negative");
        if (newScale == this.scale) {
            return this;
        }
        return new SimpleBigDecimal(this.bigInt.shiftLeft(newScale - this.scale), newScale);
    }

    SimpleBigDecimal add(SimpleBigDecimal b) {
        Ex.MUST(this.scale == b.scale);
        return new SimpleBigDecimal(this.bigInt.add(b.bigInt), this.scale);
    }

    SimpleBigDecimal negate() {
        return new SimpleBigDecimal(this.bigInt.negate(), this.scale);
    }

    SimpleBigDecimal subtract(SimpleBigDecimal b) {
        return this.add(b.negate());
    }

    SimpleBigDecimal subtract(BigInteger b) {
        return new SimpleBigDecimal(this.bigInt.subtract(b.shiftLeft(this.scale)), this.scale);
    }

    int compareTo(BigInteger val) {
        return this.bigInt.compareTo(val.shiftLeft(this.scale));
    }

    BigInteger floor() {
        return this.bigInt.shiftRight(this.scale);
    }

    BigInteger round() {
        SimpleBigDecimal oneHalf = new SimpleBigDecimal(BigInteger.ONE, 1);
        return this.add(oneHalf.adjustScale(this.scale)).floor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleBigDecimal)) {
            return false;
        }
        SimpleBigDecimal other = (SimpleBigDecimal)o;
        return this.bigInt.equals(other.bigInt) && this.scale == other.scale;
    }
}

