/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m.custom;

import java.math.BigInteger;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.F2mCurveAbstract;
import org.denom.crypt.ec.Nat;

abstract class CustomF2mCurve
extends F2mCurveAbstract {
    final int arrLen;
    final int arrLen2;

    protected CustomF2mCurve(int m, int k1, int k2, int k3, int arrLen, boolean isKoblitz) {
        super(m, k1, k2, k3, isKoblitz);
        this.arrLen = arrLen;
        this.arrLen2 = arrLen * 2;
    }

    protected static void add(long[] x, long[] y, long[] z) {
        int len = x.length;
        int i = 0;
        while (i < len) {
            z[i] = x[i] ^ y[i];
            ++i;
        }
    }

    protected static void addOne(long[] x, long[] z) {
        System.arraycopy(x, 0, z, 0, x.length);
        z[0] = z[0] ^ 1L;
    }

    protected abstract class Element
    extends F2mCurveAbstract.F2mElementAbstract {
        protected final long[] arr;

        protected Element() {
            super(CustomF2mCurve.this);
            this.arr = null;
        }

        protected Element(BigInteger X) {
            super(CustomF2mCurve.this);
            Ex.MUST(X != null && X.signum() >= 0 && X.bitLength() <= CustomF2mCurve.this.m);
            this.arr = Nat.fromBigInteger64(CustomF2mCurve.this.m, X);
        }

        protected Element(long[] x) {
            super(CustomF2mCurve.this);
            this.arr = x;
        }

        protected abstract Element create(long[] var1);

        @Override
        public final boolean isOne() {
            return Nat.isOne64(this.arr);
        }

        @Override
        public final boolean isZero() {
            return Nat.isZero64(this.arr);
        }

        @Override
        public final boolean testBitZero() {
            return (this.arr[0] & 1L) != 0L;
        }

        @Override
        public final BigInteger toBigInteger() {
            return Nat.toBigInteger64(this.arr);
        }

        @Override
        public final ECCurve.ECElement add(ECCurve.ECElement b) {
            long[] z = new long[CustomF2mCurve.this.arrLen];
            CustomF2mCurve.add(this.arr, ((Element)b).arr, z);
            return this.create(z);
        }

        @Override
        public final ECCurve.ECElement addOne() {
            long[] z = new long[CustomF2mCurve.this.arrLen];
            CustomF2mCurve.addOne(this.arr, z);
            return this.create(z);
        }

        @Override
        public final ECCurve.ECElement subtract(ECCurve.ECElement b) {
            return this.add(b);
        }

        @Override
        public final ECCurve.ECElement divide(ECCurve.ECElement b) {
            return this.multiply(b.invert());
        }

        @Override
        public final ECCurve.ECElement negate() {
            return this;
        }
    }

    class Point
    extends F2mCurveAbstract.F2mPointAbstract {
        Point(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(CustomF2mCurve.this, x, y);
        }

        Point(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(CustomF2mCurve.this, x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new Point(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new Point(x, y, zs);
        }

        @Override
        public ECCurve.ECElement getYCoord() {
            ECCurve.ECElement X = this.x;
            ECCurve.ECElement L = this.y;
            if (this.isInfinity() || X.isZero()) {
                return L;
            }
            ECCurve.ECElement Y = L.add(X).multiply(X);
            ECCurve.ECElement Z = this.zs[0];
            if (!Z.isOne()) {
                Y = Y.divide(Z);
            }
            return Y;
        }

        @Override
        protected boolean getCompressionYTilde() {
            ECCurve.ECElement X = this.getRawXCoord();
            if (X.isZero()) {
                return false;
            }
            ECCurve.ECElement Y = this.getRawYCoord();
            return Y.testBitZero() ^ X.testBitZero();
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            ECCurve.ECElement Z3;
            ECCurve.ECElement L3;
            ECCurve.ECElement X3;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement X2 = b.getRawXCoord();
            if (X1.isZero()) {
                if (X2.isZero()) {
                    return CustomF2mCurve.this.getInfinity();
                }
                return b.add(this);
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement L2 = b.getRawYCoord();
            ECCurve.ECElement Z2 = b.getZCoord(0);
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement U2 = X2;
            ECCurve.ECElement S2 = L2;
            if (!Z1IsOne) {
                U2 = U2.multiply(Z1);
                S2 = S2.multiply(Z1);
            }
            boolean Z2IsOne = Z2.isOne();
            ECCurve.ECElement U1 = X1;
            ECCurve.ECElement S1 = L1;
            if (!Z2IsOne) {
                U1 = U1.multiply(Z2);
                S1 = S1.multiply(Z2);
            }
            ECCurve.ECElement A = S1.add(S2);
            ECCurve.ECElement B = U1.add(U2);
            if (B.isZero()) {
                if (A.isZero()) {
                    return this.twice();
                }
                return CustomF2mCurve.this.getInfinity();
            }
            if (X2.isZero()) {
                ECCurve.ECElement Y2;
                ECCurve.ECPoint p = this.normalize();
                X1 = p.getXCoord();
                ECCurve.ECElement Y1 = p.getYCoord();
                ECCurve.ECElement L = Y1.add(Y2 = L2).divide(X1);
                X3 = L.square().add(L).add(X1).add(CustomF2mCurve.this.getA());
                if (X3.isZero()) {
                    return new Point(X3, CustomF2mCurve.this.getB().sqrt());
                }
                ECCurve.ECElement Y3 = L.multiply(X1.add(X3)).add(X3).add(Y1);
                L3 = Y3.divide(X3).add(X3);
                Z3 = CustomF2mCurve.this.fromBigInteger(BigInteger.ONE);
            } else {
                ECCurve.ECElement AU2;
                B = B.square();
                ECCurve.ECElement AU1 = A.multiply(U1);
                X3 = AU1.multiply(AU2 = A.multiply(U2));
                if (X3.isZero()) {
                    return new Point(X3, CustomF2mCurve.this.getB().sqrt());
                }
                ECCurve.ECElement ABZ2 = A.multiply(B);
                if (!Z2IsOne) {
                    ABZ2 = ABZ2.multiply(Z2);
                }
                L3 = AU2.add(B).squarePlusProduct(ABZ2, L1.add(Z1));
                Z3 = ABZ2;
                if (!Z1IsOne) {
                    Z3 = Z3.multiply(Z1);
                }
            }
            return new Point(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X1 = this.x;
            if (X1.isZero()) {
                return CustomF2mCurve.this.getInfinity();
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement L1Z1 = Z1IsOne ? L1 : L1.multiply(Z1);
            ECCurve.ECElement Z1Sq = Z1IsOne ? Z1 : Z1.square();
            ECCurve.ECElement a = CustomF2mCurve.this.getA();
            ECCurve.ECElement aZ1Sq = Z1IsOne ? a : a.multiply(Z1Sq);
            ECCurve.ECElement T = L1.square().add(L1Z1).add(aZ1Sq);
            if (T.isZero()) {
                return new Point(T, CustomF2mCurve.this.getB().sqrt());
            }
            ECCurve.ECElement X3 = T.square();
            ECCurve.ECElement Z3 = Z1IsOne ? T : T.multiply(Z1Sq);
            ECCurve.ECElement X1Z1 = Z1IsOne ? X1 : X1.multiply(Z1);
            ECCurve.ECElement L3 = X1Z1.squarePlusProduct(T, L1Z1).add(X3).add(Z3);
            return new Point(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twicePlus(ECCurve.ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this.twice();
            }
            ECCurve.ECElement X1 = this.x;
            if (X1.isZero()) {
                return b;
            }
            ECCurve.ECElement X2 = b.getRawXCoord();
            ECCurve.ECElement Z2 = b.getZCoord(0);
            if (X2.isZero() || !Z2.isOne()) {
                return this.twice().add(b);
            }
            ECCurve.ECElement L1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement L2 = b.getRawYCoord();
            ECCurve.ECElement X1Sq = X1.square();
            ECCurve.ECElement L1Sq = L1.square();
            ECCurve.ECElement Z1Sq = Z1.square();
            ECCurve.ECElement L1Z1 = L1.multiply(Z1);
            ECCurve.ECElement T = CustomF2mCurve.this.getA().multiply(Z1Sq).add(L1Sq).add(L1Z1);
            ECCurve.ECElement L2plus1 = L2.addOne();
            ECCurve.ECElement A = CustomF2mCurve.this.getA().add(L2plus1).multiply(Z1Sq).add(L1Sq).multiplyPlusProduct(T, X1Sq, Z1Sq);
            ECCurve.ECElement X2Z1Sq = X2.multiply(Z1Sq);
            ECCurve.ECElement B = X2Z1Sq.add(T).square();
            if (B.isZero()) {
                if (A.isZero()) {
                    return b.twice();
                }
                return CustomF2mCurve.this.getInfinity();
            }
            if (A.isZero()) {
                return new Point(A, CustomF2mCurve.this.getB().sqrt());
            }
            ECCurve.ECElement X3 = A.square().multiply(X2Z1Sq);
            ECCurve.ECElement Z3 = A.multiply(B).multiply(Z1Sq);
            ECCurve.ECElement L3 = A.add(B).square().multiplyPlusProduct(T, L2plus1, Z3);
            return new Point(X3, L3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint negate() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X = this.x;
            if (X.isZero()) {
                return this;
            }
            ECCurve.ECElement L = this.y;
            ECCurve.ECElement Z = this.zs[0];
            return new Point(X, L.add(Z), new ECCurve.ECElement[]{Z});
        }
    }
}

