/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Curve25519
extends CustomFpCurve {
    private static final int ARR_LEN = 8;
    private static final int ARR_LEN2 = 16;
    private static final long M = 0xFFFFFFFFL;
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int P7 = Integer.MAX_VALUE;
    private static final int[] PExt;
    private static final int PInv = 19;
    private static final int[] PRECOMP_POW2;

    static {
        int[] nArray = new int[16];
        nArray[0] = 361;
        nArray[8] = -19;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = 0x3FFFFFFF;
        PExt = nArray;
        PRECOMP_POW2 = new int[]{1242472624, -991028441, -1389370248, 792926214, 1039914919, 726466713, 1338105611, 730014848};
    }

    public Curve25519() {
        super(P, "7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED", 8, true);
        super.init(new Element(), new Point(null, null, null), "", "2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144", "7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864", "1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED", "08", "04 2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD245A 20AE19A1B8A086B4E01EDD2C7748D14C923D4D7E6D7C61B229E9C5A27ECED3D9");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        int xx07 = xx[7];
        Nat.shiftUpBit(8, xx, 8, xx07, z, 0);
        int c = Curve25519.mulByWordAddTo(8, 19, xx, z) << 1;
        int z7 = z[7];
        c += (z7 >>> 31) - (xx07 >>> 31);
        z7 &= Integer.MAX_VALUE;
        z[7] = z7 += Nat.addWordTo(7, c * 19, z);
        if (Nat.gte(8, z, P)) {
            Curve25519.subPFrom(z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        int z7 = z[7];
        int c = x << 1 | z7 >>> 31;
        z7 &= Integer.MAX_VALUE;
        z[7] = z7 += Nat.addWordTo(7, c * 19, z);
        if (Nat.gte(8, z, P)) {
            Curve25519.subPFrom(z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        Nat.add(8, x, y, z);
        if (Nat.gte(8, z, P)) {
            Curve25519.subPFrom(z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        Nat.inc(8, x, z);
        if (Nat.gte(8, z, P)) {
            Curve25519.subPFrom(z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        Nat.mulAddTo(8, x, y, zz);
        if (Nat.gte(16, zz, PExt)) {
            Curve25519.subPExtFrom(zz);
        }
    }

    private static int mulByWordAddTo(int len, int x, int[] y, int[] z) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += xVal * ((long)z[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(8, x, y, z);
        if (c != 0) {
            Curve25519.addPTo(z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        Nat.shiftUpBit(8, x, 0, z);
        if (Nat.gte(8, z, P)) {
            Curve25519.subPFrom(z);
        }
    }

    private static int addPTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - 19L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            c = Nat.decAt(7, z, 1);
        }
        z[7] = (int)(c += ((long)z[7] & 0xFFFFFFFFL) + 0x80000000L);
        return (int)(c >>= 32);
    }

    private static int subPFrom(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + 19L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            c = Nat.incAt(7, z, 1);
        }
        z[7] = (int)(c += ((long)z[7] & 0xFFFFFFFFL) - 0x80000000L);
        return (int)(c >>= 32);
    }

    private static int subPExtFrom(int[] zz) {
        long c = ((long)zz[0] & 0xFFFFFFFFL) - ((long)PExt[0] & 0xFFFFFFFFL);
        zz[0] = (int)c;
        if ((c >>= 32) != 0L) {
            c = Nat.decAt(8, zz, 1);
        }
        zz[8] = (int)(c += ((long)zz[8] & 0xFFFFFFFFL) + 19L);
        if ((c >>= 32) != 0L) {
            c = Nat.incAt(15, zz, 9);
        }
        zz[15] = (int)(c += ((long)zz[15] & 0xFFFFFFFFL) - ((long)(PExt[15] + 1) & 0xFFFFFFFFL));
        return (int)(c >>= 32);
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element(BigInteger X) {
            super(Curve25519.this);
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Curve25519.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(256, X);
            while (Nat.gte(8, this.arr, P)) {
                Nat.subFrom(8, P, this.arr);
            }
        }

        private Element() {
            super(Curve25519.this);
            this.arr = new int[8];
        }

        protected Element(int[] x) {
            super(Curve25519.this);
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(8, x1) || Nat.isOne(8, x1)) {
                return this;
            }
            int[] x2 = new int[8];
            Curve25519.this.elSquare(x1, x2);
            Curve25519.this.elMultiply(x2, x1, x2);
            int[] x3 = x2;
            Curve25519.this.elSquare(x2, x3);
            Curve25519.this.elMultiply(x3, x1, x3);
            int[] x4 = new int[8];
            Curve25519.this.elSquare(x3, x4);
            Curve25519.this.elMultiply(x4, x1, x4);
            int[] x7 = new int[8];
            Curve25519.this.elSquareN(x4, 3, x7);
            Curve25519.this.elMultiply(x7, x3, x7);
            int[] x11 = x3;
            Curve25519.this.elSquareN(x7, 4, x11);
            Curve25519.this.elMultiply(x11, x4, x11);
            int[] x15 = x7;
            Curve25519.this.elSquareN(x11, 4, x15);
            Curve25519.this.elMultiply(x15, x4, x15);
            int[] x30 = x4;
            Curve25519.this.elSquareN(x15, 15, x30);
            Curve25519.this.elMultiply(x30, x15, x30);
            int[] x60 = x15;
            Curve25519.this.elSquareN(x30, 30, x60);
            Curve25519.this.elMultiply(x60, x30, x60);
            int[] x120 = x30;
            Curve25519.this.elSquareN(x60, 60, x120);
            Curve25519.this.elMultiply(x120, x60, x120);
            int[] x131 = x60;
            Curve25519.this.elSquareN(x120, 11, x131);
            Curve25519.this.elMultiply(x131, x11, x131);
            int[] x251 = x11;
            Curve25519.this.elSquareN(x131, 120, x251);
            Curve25519.this.elMultiply(x251, x120, x251);
            int[] t1 = x251;
            Curve25519.this.elSquare(t1, t1);
            int[] t2 = x120;
            Curve25519.this.elSquare(t1, t2);
            if (Arrays.equals(x1, t2)) {
                return new Element(t1);
            }
            Curve25519.this.elMultiply(t1, PRECOMP_POW2, t1);
            Curve25519.this.elSquare(t1, t2);
            if (Arrays.equals(x1, t2)) {
                return new Element(t1);
            }
            return null;
        }
    }

    private class Point
    extends CustomFpCurve.Point {
        private Point(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(Curve25519.this, x, y);
        }

        private Point(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(Curve25519.this, x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new Point(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new Point(x, y, zs);
        }

        @Override
        public ECCurve.ECElement getZCoord(int index) {
            if (index == 1) {
                return this.getJacobianModifiedW();
            }
            return super.getZCoord(index);
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            int[] S1;
            int[] U1;
            int[] S2;
            int[] U2;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this == b) {
                return this.twice();
            }
            Element X1 = (Element)this.x;
            Element Y1 = (Element)this.y;
            Element Z1 = (Element)this.zs[0];
            Element X2 = (Element)b.getXCoord();
            Element Y2 = (Element)b.getYCoord();
            Element Z2 = (Element)b.getZCoord(0);
            int[] tt1 = new int[16];
            int[] t2 = new int[8];
            int[] t3 = new int[8];
            int[] t4 = new int[8];
            boolean Z1IsOne = Z1.isOne();
            if (Z1IsOne) {
                U2 = X2.arr;
                S2 = Y2.arr;
            } else {
                S2 = t3;
                Curve25519.this.elSquare(Z1.arr, S2);
                U2 = t2;
                Curve25519.this.elMultiply(S2, X2.arr, U2);
                Curve25519.this.elMultiply(S2, Z1.arr, S2);
                Curve25519.this.elMultiply(S2, Y2.arr, S2);
            }
            boolean Z2IsOne = Z2.isOne();
            if (Z2IsOne) {
                U1 = X1.arr;
                S1 = Y1.arr;
            } else {
                S1 = t4;
                Curve25519.this.elSquare(Z2.arr, S1);
                U1 = tt1;
                Curve25519.this.elMultiply(S1, X1.arr, U1);
                Curve25519.this.elMultiply(S1, Z2.arr, S1);
                Curve25519.this.elMultiply(S1, Y1.arr, S1);
            }
            int[] H = new int[8];
            Curve25519.this.elSubtract(U1, U2, H);
            int[] R = t2;
            Curve25519.this.elSubtract(S1, S2, R);
            if (Nat.isZero(8, H)) {
                if (Nat.isZero(8, R)) {
                    return this.twice();
                }
                return Curve25519.this.getInfinity();
            }
            int[] HSquared = new int[8];
            Curve25519.this.elSquare(H, HSquared);
            int[] G = new int[8];
            Curve25519.this.elMultiply(HSquared, H, G);
            int[] V = t3;
            Curve25519.this.elMultiply(HSquared, U1, V);
            Curve25519.this.elNegate(G, G);
            Nat.mul(8, S1, G, tt1);
            int c = Nat.addBothTo(8, V, V, G);
            Curve25519.this.elReduceInt(c, G);
            Element X3 = new Element(t4);
            Curve25519.this.elSquare(R, X3.arr);
            Curve25519.this.elSubtract(X3.arr, G, X3.arr);
            Element Y3 = new Element(G);
            Curve25519.this.elSubtract(V, X3.arr, Y3.arr);
            Curve25519.this.elMultiplyAddToExt(Y3.arr, R, tt1);
            Curve25519.this.elReduce(tt1, Y3.arr);
            Element Z3 = new Element(H);
            if (!Z1IsOne) {
                Curve25519.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            if (!Z2IsOne) {
                Curve25519.this.elMultiply(Z3.arr, Z2.arr, Z3.arr);
            }
            int[] Z3Squared = Z1IsOne && Z2IsOne ? HSquared : null;
            Element W3 = this.calculateJacobianModifiedW(Z3, Z3Squared);
            ECCurve.ECElement[] zs = new ECCurve.ECElement[]{Z3, W3};
            return new Point((ECCurve.ECElement)X3, (ECCurve.ECElement)Y3, zs);
        }

        @Override
        public ECCurve.ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return Curve25519.this.getInfinity();
            }
            return this.twiceJacobianModified(true);
        }

        @Override
        public ECCurve.ECPoint twicePlus(ECCurve.ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this.twice();
            }
            ECCurve.ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return b;
            }
            return this.twiceJacobianModified(false).add(b);
        }

        private Element calculateJacobianModifiedW(Element Z, int[] ZSquared) {
            Element a4 = (Element)Curve25519.this.getA();
            if (Z.isOne()) {
                return a4;
            }
            Element W = new Element();
            if (ZSquared == null) {
                ZSquared = W.arr;
                Curve25519.this.elSquare(Z.arr, ZSquared);
            }
            Curve25519.this.elSquare(ZSquared, W.arr);
            Curve25519.this.elMultiply(W.arr, a4.arr, W.arr);
            return W;
        }

        private Element getJacobianModifiedW() {
            Element W = (Element)this.zs[1];
            if (W == null) {
                W = this.calculateJacobianModifiedW((Element)this.zs[0], null);
                this.zs[1] = W;
            }
            return W;
        }

        private Point twiceJacobianModified(boolean calculateW) {
            Element X1 = (Element)this.x;
            Element Y1 = (Element)this.y;
            Element Z1 = (Element)this.zs[0];
            Element W1 = this.getJacobianModifiedW();
            int[] M = new int[8];
            Curve25519.this.elSquare(X1.arr, M);
            int c = Nat.addBothTo(8, M, M, M);
            Curve25519.this.elReduceInt(c += Nat.addTo(8, W1.arr, M), M);
            int[] _2Y1 = new int[8];
            Curve25519.this.elTwice(Y1.arr, _2Y1);
            int[] _2Y1Squared = new int[8];
            Curve25519.this.elMultiply(_2Y1, Y1.arr, _2Y1Squared);
            int[] S = new int[8];
            Curve25519.this.elMultiply(_2Y1Squared, X1.arr, S);
            Curve25519.this.elTwice(S, S);
            int[] _8T = new int[8];
            Curve25519.this.elSquare(_2Y1Squared, _8T);
            Curve25519.this.elTwice(_8T, _8T);
            Element X3 = new Element(_2Y1Squared);
            Curve25519.this.elSquare(M, X3.arr);
            Curve25519.this.elSubtract(X3.arr, S, X3.arr);
            Curve25519.this.elSubtract(X3.arr, S, X3.arr);
            Element Y3 = new Element(S);
            Curve25519.this.elSubtract(S, X3.arr, Y3.arr);
            Curve25519.this.elMultiply(Y3.arr, M, Y3.arr);
            Curve25519.this.elSubtract(Y3.arr, _8T, Y3.arr);
            Element Z3 = new Element(_2Y1);
            if (!Nat.isOne(8, Z1.arr)) {
                Curve25519.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            Element W3 = null;
            if (calculateW) {
                W3 = new Element(_8T);
                Curve25519.this.elMultiply(W3.arr, W1.arr, W3.arr);
                Curve25519.this.elTwice(W3.arr, W3.arr);
            }
            return new Point((ECCurve.ECElement)X3, (ECCurve.ECElement)Y3, new ECCurve.ECElement[]{Z3, W3});
        }
    }
}

