/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.FpCurveAbstract;
import org.denom.crypt.ec.Nat;

abstract class CustomFpCurve
extends FpCurveAbstract {
    final int arrLen;
    final int arrLen2;
    final int[] P;

    protected CustomFpCurve(int[] P, String modulePHex, int arrLen, boolean isJacobianModified) {
        super(modulePHex, isJacobianModified);
        this.arrLen = arrLen;
        this.arrLen2 = arrLen * 2;
        this.P = P;
    }

    protected abstract void elReduce(int[] var1, int[] var2);

    protected abstract void elReduceInt(int var1, int[] var2);

    protected void elAdd(int[] x, int[] y, int[] z) {
    }

    protected void elAddOne(int[] x, int[] z) {
    }

    protected void elSubtract(int[] x, int[] y, int[] z) {
    }

    protected void elTwice(int[] x, int[] z) {
    }

    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
    }

    protected void elMultiply(int[] x, int[] y, int[] z) {
        int[] tt = new int[this.arrLen2];
        Nat.mul(this.arrLen, x, y, tt);
        this.elReduce(tt, z);
    }

    protected void elNegate(int[] x, int[] z) {
        if (Nat.isZero(this.arrLen, x)) {
            Nat.zero(this.arrLen, z);
        } else {
            Nat.sub(this.arrLen, this.P, x, z);
        }
    }

    protected void elSquare(int[] x, int[] z) {
        int[] tt = new int[this.arrLen2];
        Nat.square(this.arrLen, x, tt);
        this.elReduce(tt, z);
    }

    protected void elSquareN(int[] x, int n, int[] z) {
        int[] tt = new int[this.arrLen2];
        Nat.square(this.arrLen, x, tt);
        this.elReduce(tt, z);
        while (--n > 0) {
            Nat.square(this.arrLen, z, tt);
            this.elReduce(tt, z);
        }
    }

    protected abstract class Element
    extends FpCurveAbstract.FpElementAbstract {
        protected int[] arr;

        protected Element() {
            super(CustomFpCurve.this);
        }

        protected abstract ECCurve.ECElement create(int[] var1);

        @Override
        public final boolean isZero() {
            return Nat.isZero(CustomFpCurve.this.arrLen, this.arr);
        }

        @Override
        public final boolean isOne() {
            return Nat.isOne(CustomFpCurve.this.arrLen, this.arr);
        }

        @Override
        public final boolean testBitZero() {
            return Nat.getBit(this.arr, 0) == 1;
        }

        @Override
        public final BigInteger toBigInteger() {
            return Nat.toBigInteger(CustomFpCurve.this.arrLen, this.arr);
        }

        @Override
        public ECCurve.ECElement add(ECCurve.ECElement b) {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elAdd(this.arr, ((Element)b).arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement addOne() {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elAddOne(this.arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement subtract(ECCurve.ECElement b) {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elSubtract(this.arr, ((Element)b).arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elMultiply(this.arr, ((Element)b).arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement divide(ECCurve.ECElement b) {
            int[] z = new int[CustomFpCurve.this.arrLen];
            Nat.invert(CustomFpCurve.this.P, ((Element)b).arr, z);
            CustomFpCurve.this.elMultiply(z, this.arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement negate() {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elNegate(this.arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement square() {
            int[] z = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elSquare(this.arr, z);
            return this.create(z);
        }

        @Override
        public ECCurve.ECElement invert() {
            int[] z = new int[CustomFpCurve.this.arrLen];
            Nat.invert(CustomFpCurve.this.P, this.arr, z);
            return this.create(z);
        }

        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element o = (Element)other;
            return Arrays.equals(this.arr, o.arr);
        }
    }

    protected class Point
    extends FpCurveAbstract.FpPointAbstract {
        protected Point(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(CustomFpCurve.this, x, y);
        }

        protected Point(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(CustomFpCurve.this, x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new Point(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new Point(x, y, zs);
        }

        Element elCreate(int[] x) {
            return (Element)((Element)CustomFpCurve.this.myElement).create(x);
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            int[] S1;
            int[] U1;
            int[] S2;
            int[] U2;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this == b) {
                return this.twice();
            }
            Element X1 = (Element)this.x;
            Element Y1 = (Element)this.y;
            Element X2 = (Element)b.getXCoord();
            Element Y2 = (Element)b.getYCoord();
            Element Z1 = (Element)this.zs[0];
            Element Z2 = (Element)b.getZCoord(0);
            int[] tt1 = new int[CustomFpCurve.this.arrLen2];
            int[] t2 = new int[CustomFpCurve.this.arrLen];
            int[] t3 = new int[CustomFpCurve.this.arrLen];
            int[] t4 = new int[CustomFpCurve.this.arrLen];
            boolean Z1IsOne = Z1.isOne();
            if (Z1IsOne) {
                U2 = X2.arr;
                S2 = Y2.arr;
            } else {
                S2 = t3;
                CustomFpCurve.this.elSquare(Z1.arr, S2);
                U2 = t2;
                CustomFpCurve.this.elMultiply(S2, X2.arr, U2);
                CustomFpCurve.this.elMultiply(S2, Z1.arr, S2);
                CustomFpCurve.this.elMultiply(S2, Y2.arr, S2);
            }
            boolean Z2IsOne = Z2.isOne();
            if (Z2IsOne) {
                U1 = X1.arr;
                S1 = Y1.arr;
            } else {
                S1 = t4;
                CustomFpCurve.this.elSquare(Z2.arr, S1);
                U1 = tt1;
                CustomFpCurve.this.elMultiply(S1, X1.arr, U1);
                CustomFpCurve.this.elMultiply(S1, Z2.arr, S1);
                CustomFpCurve.this.elMultiply(S1, Y1.arr, S1);
            }
            int[] H = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elSubtract(U1, U2, H);
            int[] R = t2;
            CustomFpCurve.this.elSubtract(S1, S2, R);
            if (Nat.isZero(CustomFpCurve.this.arrLen, H)) {
                if (Nat.isZero(CustomFpCurve.this.arrLen, R)) {
                    return this.twice();
                }
                return CustomFpCurve.this.getInfinity();
            }
            int[] HSquared = t3;
            CustomFpCurve.this.elSquare(H, HSquared);
            int[] G = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elMultiply(HSquared, H, G);
            int[] V = t3;
            CustomFpCurve.this.elMultiply(HSquared, U1, V);
            CustomFpCurve.this.elNegate(G, G);
            Nat.mul(CustomFpCurve.this.arrLen, S1, G, tt1);
            int c = Nat.addBothTo(CustomFpCurve.this.arrLen, V, V, G);
            CustomFpCurve.this.elReduceInt(c, G);
            Element X3 = this.elCreate(t4);
            CustomFpCurve.this.elSquare(R, X3.arr);
            CustomFpCurve.this.elSubtract(X3.arr, G, X3.arr);
            Element Y3 = this.elCreate(G);
            CustomFpCurve.this.elSubtract(V, X3.arr, Y3.arr);
            CustomFpCurve.this.elMultiplyAddToExt(Y3.arr, R, tt1);
            CustomFpCurve.this.elReduce(tt1, Y3.arr);
            Element Z3 = this.elCreate(H);
            if (!Z1IsOne) {
                CustomFpCurve.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            if (!Z2IsOne) {
                CustomFpCurve.this.elMultiply(Z3.arr, Z2.arr, Z3.arr);
            }
            return this.create(X3, Y3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            Element Y1 = (Element)this.y;
            if (Y1.isZero()) {
                return CustomFpCurve.this.getInfinity();
            }
            if (CustomFpCurve.this.getA().isZero()) {
                Element X1 = (Element)this.x;
                Element Z1 = (Element)this.zs[0];
                int[] Y1Squared = new int[CustomFpCurve.this.arrLen];
                CustomFpCurve.this.elSquare(Y1.arr, Y1Squared);
                int[] T = new int[CustomFpCurve.this.arrLen];
                CustomFpCurve.this.elSquare(Y1Squared, T);
                int[] M = new int[CustomFpCurve.this.arrLen];
                CustomFpCurve.this.elSquare(X1.arr, M);
                int c = Nat.addBothTo(CustomFpCurve.this.arrLen, M, M, M);
                CustomFpCurve.this.elReduceInt(c, M);
                int[] S = Y1Squared;
                CustomFpCurve.this.elMultiply(Y1Squared, X1.arr, S);
                c = Nat.shiftUpBits(CustomFpCurve.this.arrLen, S, 2, 0);
                CustomFpCurve.this.elReduceInt(c, S);
                int[] t1 = new int[CustomFpCurve.this.arrLen];
                c = Nat.shiftUpBits(CustomFpCurve.this.arrLen, T, 3, 0, t1);
                CustomFpCurve.this.elReduceInt(c, t1);
                Element X3 = this.elCreate(T);
                CustomFpCurve.this.elSquare(M, X3.arr);
                CustomFpCurve.this.elSubtract(X3.arr, S, X3.arr);
                CustomFpCurve.this.elSubtract(X3.arr, S, X3.arr);
                Element Y3 = this.elCreate(S);
                CustomFpCurve.this.elSubtract(S, X3.arr, Y3.arr);
                CustomFpCurve.this.elMultiply(Y3.arr, M, Y3.arr);
                CustomFpCurve.this.elSubtract(Y3.arr, t1, Y3.arr);
                Element Z3 = this.elCreate(M);
                CustomFpCurve.this.elTwice(Y1.arr, Z3.arr);
                if (!Z1.isOne()) {
                    CustomFpCurve.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
                }
                return this.create(X3, Y3, new ECCurve.ECElement[]{Z3});
            }
            Element X1 = (Element)this.x;
            Element Z1 = (Element)this.zs[0];
            int[] t1 = new int[CustomFpCurve.this.arrLen];
            int[] t2 = new int[CustomFpCurve.this.arrLen];
            int[] Y1Squared = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elSquare(Y1.arr, Y1Squared);
            int[] T = new int[CustomFpCurve.this.arrLen];
            CustomFpCurve.this.elSquare(Y1Squared, T);
            int[] Z1Squared = Z1.arr;
            if (!Z1.isOne()) {
                Z1Squared = t2;
                CustomFpCurve.this.elSquare(Z1.arr, Z1Squared);
            }
            CustomFpCurve.this.elSubtract(X1.arr, Z1Squared, t1);
            int[] M = t2;
            CustomFpCurve.this.elAdd(X1.arr, Z1Squared, M);
            CustomFpCurve.this.elMultiply(M, t1, M);
            int c = Nat.addBothTo(CustomFpCurve.this.arrLen, M, M, M);
            CustomFpCurve.this.elReduceInt(c, M);
            int[] S = Y1Squared;
            CustomFpCurve.this.elMultiply(Y1Squared, X1.arr, S);
            c = Nat.shiftUpBits(CustomFpCurve.this.arrLen, S, 2, 0);
            CustomFpCurve.this.elReduceInt(c, S);
            c = Nat.shiftUpBits(CustomFpCurve.this.arrLen, T, 3, 0, t1);
            CustomFpCurve.this.elReduceInt(c, t1);
            Element X3 = this.elCreate(T);
            CustomFpCurve.this.elSquare(M, X3.arr);
            CustomFpCurve.this.elSubtract(X3.arr, S, X3.arr);
            CustomFpCurve.this.elSubtract(X3.arr, S, X3.arr);
            Element Y3 = this.elCreate(S);
            CustomFpCurve.this.elSubtract(S, X3.arr, Y3.arr);
            CustomFpCurve.this.elMultiply(Y3.arr, M, Y3.arr);
            CustomFpCurve.this.elSubtract(Y3.arr, t1, Y3.arr);
            Element Z3 = this.elCreate(M);
            CustomFpCurve.this.elTwice(Y1.arr, Z3.arr);
            if (!Z1.isOne()) {
                CustomFpCurve.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            return this.create(X3, Y3, new ECCurve.ECElement[]{Z3});
        }
    }
}

