/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp192r1
extends CustomFpCurve {
    private static final int ARR_LEN = 6;
    private static final long M = 0xFFFFFFFFL;
    private static final int[] P = new int[]{-1, -1, -2, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P5 = -1;
    private static final int PExt11 = -1;

    static {
        int[] nArray = new int[12];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[4] = 1;
        nArray[6] = -2;
        nArray[7] = -1;
        nArray[8] = -3;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        PExt = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = -3;
        nArray2[3] = -1;
        nArray2[4] = -2;
        nArray2[5] = -1;
        nArray2[6] = 1;
        nArray2[8] = 2;
        PExtInv = nArray2;
    }

    public Secp192r1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF", 6, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.2.840.10045.3.1.1", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC", "64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1", "FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831", "01", "04 188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012 07192B95FFC8DA78631011ED6B24CDD573F977A11E794811");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long xx06 = (long)xx[6] & 0xFFFFFFFFL;
        long xx07 = (long)xx[7] & 0xFFFFFFFFL;
        long xx08 = (long)xx[8] & 0xFFFFFFFFL;
        long xx09 = (long)xx[9] & 0xFFFFFFFFL;
        long xx10 = (long)xx[10] & 0xFFFFFFFFL;
        long xx11 = (long)xx[11] & 0xFFFFFFFFL;
        long t0 = xx06 + xx10;
        long t1 = xx07 + xx11;
        long cc = 0L;
        int z0 = (int)(cc += ((long)xx[0] & 0xFFFFFFFFL) + t0);
        cc >>= 32;
        z[1] = (int)(cc += ((long)xx[1] & 0xFFFFFFFFL) + t1);
        cc >>= 32;
        long z2 = (cc += ((long)xx[2] & 0xFFFFFFFFL) + (t0 += xx08)) & 0xFFFFFFFFL;
        cc >>= 32;
        z[3] = (int)(cc += ((long)xx[3] & 0xFFFFFFFFL) + (t1 += xx09));
        cc >>= 32;
        z[4] = (int)(cc += ((long)xx[4] & 0xFFFFFFFFL) + (t0 -= xx06));
        cc >>= 32;
        z[5] = (int)(cc += ((long)xx[5] & 0xFFFFFFFFL) + (t1 -= xx07));
        z2 += (cc >>= 32);
        z[0] = (int)(cc += (long)z0 & 0xFFFFFFFFL);
        if ((cc >>= 32) != 0L) {
            z[1] = (int)(cc += (long)z[1] & 0xFFFFFFFFL);
            z2 += cc >> 32;
        }
        z[2] = (int)z2;
        cc = z2 >> 32;
        if (cc != 0L && Nat.incAt(6, z, 3) != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        long cc = 0L;
        if (x != 0) {
            long xx06 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(cc += ((long)z[0] & 0xFFFFFFFFL) + xx06);
            if ((cc >>= 32) != 0L) {
                z[1] = (int)(cc += (long)z[1] & 0xFFFFFFFFL);
                cc >>= 32;
            }
            z[2] = (int)(cc += ((long)z[2] & 0xFFFFFFFFL) + xx06);
            cc >>= 32;
        }
        if (cc != 0L && Nat.incAt(6, z, 3) != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(6, x, y, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(6, x, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(6, x, y, zz);
        if ((c != 0 || zz[11] == -1 && Nat.gte(12, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(12, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(6, x, y, z);
        if (c != 0) {
            this.subPInvFrom(z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(6, x, 0, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            this.addPInvTo(z);
        }
    }

    private void addPInvTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[2] = (int)(c += ((long)z[2] & 0xFFFFFFFFL) + 1L);
        if ((c >>= 32) != 0L) {
            Nat.incAt(6, z, 3);
        }
    }

    private void subPInvFrom(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[2] = (int)(c += ((long)z[2] & 0xFFFFFFFFL) - 1L);
        if ((c >>= 32) != 0L) {
            Nat.decAt(6, z, 3);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp192r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(192, X);
            if (this.arr[5] == -1 && Nat.gte(6, this.arr, P)) {
                Nat.subFrom(6, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(6, x1) || Nat.isOne(6, x1)) {
                return this;
            }
            int[] t1 = new int[6];
            int[] t2 = new int[6];
            Secp192r1.this.elSquare(x1, t1);
            Secp192r1.this.elMultiply(t1, x1, t1);
            Secp192r1.this.elSquareN(t1, 2, t2);
            Secp192r1.this.elMultiply(t2, t1, t2);
            Secp192r1.this.elSquareN(t2, 4, t1);
            Secp192r1.this.elMultiply(t1, t2, t1);
            Secp192r1.this.elSquareN(t1, 8, t2);
            Secp192r1.this.elMultiply(t2, t1, t2);
            Secp192r1.this.elSquareN(t2, 16, t1);
            Secp192r1.this.elMultiply(t1, t2, t1);
            Secp192r1.this.elSquareN(t1, 32, t2);
            Secp192r1.this.elMultiply(t2, t1, t2);
            Secp192r1.this.elSquareN(t2, 64, t1);
            Secp192r1.this.elMultiply(t1, t2, t1);
            Secp192r1.this.elSquareN(t1, 62, t1);
            Secp192r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

