/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp224k1
extends CustomFpCurve {
    private static final int ARR_LEN = 7;
    private static final int ARR_LEN2 = 14;
    private static final int[] PRECOMP_POW2 = new int[]{868209154, -587542221, 579297866, -1014948952, -1470801668, 514782679, -1897982644};
    private static final int[] P = new int[]{-6803, -2, -1, -1, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P6 = -1;
    private static final int PExt13 = -1;
    private static final int PInv33 = 6803;

    static {
        int[] nArray = new int[14];
        nArray[0] = 46280809;
        nArray[1] = 13606;
        nArray[2] = 1;
        nArray[7] = -13606;
        nArray[8] = -3;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        PExt = nArray;
        PExtInv = new int[]{-46280809, -13607, -2, -1, -1, -1, -1, 13605, 2};
    }

    public Secp224k1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D", 7, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.32", "00", "05", "010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7", "01", "04 A1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45C 7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long cc = Nat.mul33Add(7, 6803, xx, 7, xx, 0, z, 0);
        int c = Nat.mul33DWordAdd(7, 6803, cc, z, 0);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            Nat.add33To(7, 6803, z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        if (x != 0 && Nat.mul33WordAdd(7, 6803, x, z, 0) != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            Nat.add33To(7, 6803, z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(7, x, y, z);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            Nat.add33To(7, 6803, z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(7, x, y, zz);
        if ((c != 0 || zz[13] == -1 && Nat.gte(14, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(14, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(7, x, y, z);
        if (c != 0) {
            Nat.sub33From(7, 6803, z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(7, x, 0, z);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            Nat.add33To(7, 6803, z);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp224k1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(224, X);
            if (this.arr[6] == -1 && Nat.gte(7, this.arr, P)) {
                Nat.add33To(7, 6803, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(7, x1) || Nat.isOne(7, x1)) {
                return this;
            }
            int[] x2 = new int[7];
            Secp224k1.this.elSquare(x1, x2);
            Secp224k1.this.elMultiply(x2, x1, x2);
            int[] x3 = x2;
            Secp224k1.this.elSquare(x2, x3);
            Secp224k1.this.elMultiply(x3, x1, x3);
            int[] x4 = new int[7];
            Secp224k1.this.elSquare(x3, x4);
            Secp224k1.this.elMultiply(x4, x1, x4);
            int[] x8 = new int[7];
            Secp224k1.this.elSquareN(x4, 4, x8);
            Secp224k1.this.elMultiply(x8, x4, x8);
            int[] x11 = new int[7];
            Secp224k1.this.elSquareN(x8, 3, x11);
            Secp224k1.this.elMultiply(x11, x3, x11);
            int[] x19 = x11;
            Secp224k1.this.elSquareN(x11, 8, x19);
            Secp224k1.this.elMultiply(x19, x8, x19);
            int[] x23 = x8;
            Secp224k1.this.elSquareN(x19, 4, x23);
            Secp224k1.this.elMultiply(x23, x4, x23);
            int[] x42 = x4;
            Secp224k1.this.elSquareN(x23, 19, x42);
            Secp224k1.this.elMultiply(x42, x19, x42);
            int[] x84 = new int[7];
            Secp224k1.this.elSquareN(x42, 42, x84);
            Secp224k1.this.elMultiply(x84, x42, x84);
            int[] x107 = x42;
            Secp224k1.this.elSquareN(x84, 23, x107);
            Secp224k1.this.elMultiply(x107, x23, x107);
            int[] x191 = x23;
            Secp224k1.this.elSquareN(x107, 84, x191);
            Secp224k1.this.elMultiply(x191, x84, x191);
            int[] t1 = x191;
            Secp224k1.this.elSquareN(t1, 20, t1);
            Secp224k1.this.elMultiply(t1, x19, t1);
            Secp224k1.this.elSquareN(t1, 3, t1);
            Secp224k1.this.elMultiply(t1, x1, t1);
            Secp224k1.this.elSquareN(t1, 2, t1);
            Secp224k1.this.elMultiply(t1, x1, t1);
            Secp224k1.this.elSquareN(t1, 4, t1);
            Secp224k1.this.elMultiply(t1, x3, t1);
            Secp224k1.this.elSquare(t1, t1);
            int[] t2 = x84;
            Secp224k1.this.elSquare(t1, t2);
            if (Arrays.equals(x1, t2)) {
                return new Element(t1);
            }
            Secp224k1.this.elMultiply(t1, PRECOMP_POW2, t1);
            Secp224k1.this.elSquare(t1, t2);
            if (Arrays.equals(x1, t2)) {
                return new Element(t1);
            }
            return null;
        }
    }
}

